/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.AudioEditor;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.xbup.audio.swing.XBWavePanel;

@ParametersAreNonnullByDefault
public class DrawingControlActions {
    public static final String DOTS_MODE_ACTION_ID = "dotsModeAction";
    public static final String LINE_MODE_ACTION_ID = "lineModeAction";
    public static final String INTEGRAL_MODE_ACTION_ID = "integralModeAction";
    public static final String DRAWING_RADIO_GROUP_ID = "drawingRadioGroup";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action dotsModeAction;
    private Action lineModeAction;
    private Action integralModeAction;
    private XBWavePanel.DrawMode drawMode = XBWavePanel.DrawMode.DOTS_MODE;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    public void setDrawMode(XBWavePanel.DrawMode mode) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        audioPanel.setDrawMode(mode);
    }

    @Nonnull
    public Action getDotsModeAction() {
        if (this.dotsModeAction == null) {
            this.dotsModeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DrawingControlActions.this.editorProvider instanceof AudioEditor) {
                        DrawingControlActions.this.setDrawMode(XBWavePanel.DrawMode.DOTS_MODE);
                    }
                }
            };
            ActionUtils.setupAction((Action)this.dotsModeAction, (ResourceBundle)this.resourceBundle, (String)DOTS_MODE_ACTION_ID);
            this.dotsModeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.dotsModeAction.putValue("radioGroup", DRAWING_RADIO_GROUP_ID);
            this.dotsModeAction.putValue("SwingSelectedKey", this.drawMode == XBWavePanel.DrawMode.DOTS_MODE);
        }
        return this.dotsModeAction;
    }

    @Nonnull
    public Action getLineModeAction() {
        if (this.lineModeAction == null) {
            this.lineModeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DrawingControlActions.this.editorProvider instanceof AudioEditor) {
                        DrawingControlActions.this.setDrawMode(XBWavePanel.DrawMode.LINE_MODE);
                    }
                }
            };
            ActionUtils.setupAction((Action)this.lineModeAction, (ResourceBundle)this.resourceBundle, (String)LINE_MODE_ACTION_ID);
            this.lineModeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.lineModeAction.putValue("radioGroup", DRAWING_RADIO_GROUP_ID);
            this.lineModeAction.putValue("SwingSelectedKey", this.drawMode == XBWavePanel.DrawMode.LINE_MODE);
        }
        return this.lineModeAction;
    }

    @Nonnull
    public Action getIntegralModeAction() {
        if (this.integralModeAction == null) {
            this.integralModeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DrawingControlActions.this.editorProvider instanceof AudioEditor) {
                        DrawingControlActions.this.setDrawMode(XBWavePanel.DrawMode.INTEGRAL_MODE);
                    }
                }
            };
            ActionUtils.setupAction((Action)this.integralModeAction, (ResourceBundle)this.resourceBundle, (String)INTEGRAL_MODE_ACTION_ID);
            this.integralModeAction.putValue("radioGroup", DRAWING_RADIO_GROUP_ID);
            this.integralModeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.integralModeAction.putValue("SwingSelectedKey", this.drawMode == XBWavePanel.DrawMode.INTEGRAL_MODE);
        }
        return this.integralModeAction;
    }
}

