/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended;

import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;

@ParametersAreNonnullByDefault
public class ExtendedCodeAreaDimensions {
    private int scrollPanelX;
    private int scrollPanelY;
    private int scrollPanelWidth;
    private int scrollPanelHeight;
    private int verticalScrollBarSize;
    private int horizontalScrollBarSize;
    private int dataViewWidth;
    private int dataViewHeight;
    private int halfCharOffset;
    private int rowOffset;
    private int headerAreaHeight;
    private int rowPositionAreaWidth;
    private int rowsPerRect;
    private int rowsPerPage;
    private int halfCharsPerPage;
    private int halfCharsPerRect;
    @Nullable
    private ExtendedCodeAreaLayoutProfile layoutProfile;
    @Nonnull
    private final Rectangle componentRectangle = new Rectangle();
    @Nonnull
    private final Rectangle mainAreaRectangle = new Rectangle();
    @Nonnull
    private final Rectangle headerAreaRectangle = new Rectangle();
    @Nonnull
    private final Rectangle rowPositionAreaRectangle = new Rectangle();
    @Nonnull
    private final Rectangle scrollPanelRectangle = new Rectangle();
    @Nonnull
    private final Rectangle dataViewRectangle = new Rectangle();

    public void recomputeSizes(BasicCodeAreaMetrics metrics, int componentX, int componentY, int componentWidth, int componentHeight, int rowPositionLength, int verticalScrollBarSize, int horizontalScrollBarSize, ExtendedCodeAreaLayoutProfile layoutProfile) {
        boolean availableHeight;
        this.componentRectangle.setBounds(componentX, componentY, componentWidth, componentHeight);
        this.layoutProfile = layoutProfile;
        this.verticalScrollBarSize = verticalScrollBarSize;
        this.horizontalScrollBarSize = horizontalScrollBarSize;
        int characterWidth = metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        this.headerAreaHeight = layoutProfile.computeHeaderAreaHeight(metrics.getFontHeight());
        this.rowPositionAreaWidth = layoutProfile.computeRowPositionAreaWidth(metrics.getCharacterWidth(), rowPositionLength);
        this.scrollPanelX = componentX + this.rowPositionAreaWidth;
        this.scrollPanelY = componentY + this.headerAreaHeight;
        this.scrollPanelWidth = componentWidth - this.rowPositionAreaWidth;
        this.scrollPanelHeight = componentHeight - this.headerAreaHeight;
        this.dataViewWidth = this.scrollPanelWidth - verticalScrollBarSize;
        this.dataViewHeight = this.scrollPanelHeight - horizontalScrollBarSize;
        this.halfCharsPerRect = this.computeHalfCharsPerRectangle(metrics);
        this.halfCharsPerPage = this.computeHalfCharsPerPage(metrics);
        this.rowsPerRect = this.computeRowsPerRectangle(metrics);
        this.rowsPerPage = this.computeRowsPerPage(metrics);
        this.halfCharOffset = metrics.isInitialized() ? this.dataViewWidth % halfSpaceWidth : 0;
        this.rowOffset = metrics.isInitialized() ? this.dataViewHeight % metrics.getRowHeight() : 0;
        boolean availableWidth = this.rowPositionAreaWidth + verticalScrollBarSize <= componentWidth;
        boolean bl = availableHeight = this.scrollPanelY + horizontalScrollBarSize <= componentHeight;
        if (availableWidth && availableHeight) {
            this.mainAreaRectangle.setBounds(componentX + this.rowPositionAreaWidth, this.scrollPanelY, componentWidth - this.rowPositionAreaWidth - verticalScrollBarSize, componentHeight - this.scrollPanelY - horizontalScrollBarSize);
        } else {
            this.mainAreaRectangle.setBounds(0, 0, 0, 0);
        }
        if (availableWidth) {
            this.headerAreaRectangle.setBounds(componentX + this.rowPositionAreaWidth, componentY, componentWidth - this.rowPositionAreaWidth - verticalScrollBarSize, this.headerAreaHeight);
        } else {
            this.headerAreaRectangle.setBounds(0, 0, 0, 0);
        }
        if (availableHeight) {
            this.rowPositionAreaRectangle.setBounds(componentX, this.scrollPanelY, this.rowPositionAreaWidth, componentHeight - this.scrollPanelY - horizontalScrollBarSize);
        } else {
            this.rowPositionAreaRectangle.setBounds(0, 0, 0, 0);
        }
        this.scrollPanelRectangle.setBounds(this.scrollPanelX, this.scrollPanelY, this.scrollPanelWidth, this.scrollPanelHeight);
        this.dataViewRectangle.setBounds(this.scrollPanelX, this.scrollPanelY, Math.max(this.dataViewWidth, 0), Math.max(this.dataViewHeight, 0));
    }

    @Nonnull
    public BasicCodeAreaZone getPositionZone(int positionX, int positionY) {
        if (positionY <= this.scrollPanelY) {
            if (positionX < this.rowPositionAreaWidth) {
                return BasicCodeAreaZone.TOP_LEFT_CORNER;
            }
            return BasicCodeAreaZone.HEADER;
        }
        if (positionX < this.rowPositionAreaWidth) {
            if (positionY >= this.scrollPanelY + this.scrollPanelHeight) {
                return BasicCodeAreaZone.BOTTOM_LEFT_CORNER;
            }
            return BasicCodeAreaZone.ROW_POSITIONS;
        }
        if (positionX >= this.scrollPanelX + this.scrollPanelWidth && positionY < this.scrollPanelY + this.scrollPanelHeight) {
            return BasicCodeAreaZone.VERTICAL_SCROLLBAR;
        }
        if (positionY >= this.scrollPanelY + this.scrollPanelHeight) {
            if (positionX >= this.scrollPanelX + this.scrollPanelWidth) {
                return BasicCodeAreaZone.SCROLLBAR_CORNER;
            }
            return BasicCodeAreaZone.HORIZONTAL_SCROLLBAR;
        }
        return BasicCodeAreaZone.CODE_AREA;
    }

    private int computeHalfCharsPerRectangle(BasicCodeAreaMetrics metrics) {
        int characterWidth = metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        if (characterWidth == 0) {
            return 0;
        }
        int width = this.dataViewWidth + halfSpaceWidth - 1;
        int halfChars = width / characterWidth * 2;
        if (width % characterWidth >= halfSpaceWidth) {
            ++halfChars;
        }
        return halfChars;
    }

    private int computeHalfCharsPerPage(BasicCodeAreaMetrics metrics) {
        int characterWidth = metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        if (characterWidth == 0) {
            return 0;
        }
        int halfChars = this.dataViewWidth / characterWidth * 2;
        if (this.dataViewWidth % characterWidth >= halfSpaceWidth) {
            ++halfChars;
        }
        return halfChars;
    }

    private int computeRowsPerRectangle(BasicCodeAreaMetrics metrics) {
        int rowHeight = metrics.getRowHeight();
        return rowHeight == 0 ? 0 : (this.dataViewHeight + rowHeight - 1) / rowHeight;
    }

    private int computeRowsPerPage(BasicCodeAreaMetrics metrics) {
        int rowHeight = metrics.getRowHeight();
        return rowHeight == 0 ? 0 : this.dataViewHeight / rowHeight;
    }

    public int getScrollPanelX() {
        return this.scrollPanelX;
    }

    public int getScrollPanelY() {
        return this.scrollPanelY;
    }

    public int getVerticalScrollBarSize() {
        return this.verticalScrollBarSize;
    }

    public int getHorizontalScrollBarSize() {
        return this.horizontalScrollBarSize;
    }

    public int getScrollPanelWidth() {
        return this.scrollPanelWidth;
    }

    public int getScrollPanelHeight() {
        return this.scrollPanelHeight;
    }

    public int getDataViewWidth() {
        return this.dataViewWidth;
    }

    public int getDataViewHeight() {
        return this.dataViewHeight;
    }

    public int getHeaderAreaHeight() {
        return this.headerAreaHeight;
    }

    public int getRowPositionAreaWidth() {
        return this.rowPositionAreaWidth;
    }

    public int getRowsPerRect() {
        return this.rowsPerRect;
    }

    public int getHalfCharsPerRect() {
        return this.halfCharsPerRect;
    }

    public int getHalfCharsPerPage() {
        return this.halfCharsPerPage;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public int getHalfCharOffset() {
        return this.halfCharOffset;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    @Nonnull
    public ExtendedCodeAreaLayoutProfile getLayoutProfile() {
        CodeAreaUtils.requireNonNull((Object)this.layoutProfile);
        return this.layoutProfile;
    }

    @Nonnull
    public Rectangle getComponentRectangle() {
        return this.componentRectangle;
    }

    @Nonnull
    public Rectangle getMainAreaRectangle() {
        return this.mainAreaRectangle;
    }

    @Nonnull
    public Rectangle getScrollPanelRectangle() {
        return this.scrollPanelRectangle;
    }

    @Nonnull
    public Rectangle getDataViewRectangle() {
        return this.dataViewRectangle;
    }

    @Nonnull
    public Rectangle getHeaderAreaRectangle() {
        return this.headerAreaRectangle;
    }

    @Nonnull
    public Rectangle getRowPositionAreaRectangle() {
        return this.rowPositionAreaRectangle;
    }
}

