/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.layout.CControlPerspectiveResource;
import bibliothek.gui.dock.common.perspective.CControlPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.frontend.SettingsBlop;
import bibliothek.gui.dock.support.util.ApplicationResourceManager;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CControlPerspectiveBlop {
    private CControlPerspective control;
    private ApplicationResourceManager resourceManager = new ApplicationResourceManager();
    private CControlPerspectiveResource resource;

    public CControlPerspectiveBlop(CControlPerspective control) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = control;
        this.resource = new CControlPerspectiveResource(control);
        try {
            this.resourceManager.put("ccontrol.frontend", this.resource);
        }
        catch (IOException e) {
            throw new IllegalStateException("This cannot happen", e);
        }
    }

    public String[] getPerspectiveNames() {
        return this.resource.getSettings().getNames();
    }

    public CSetting getSetting(String name) {
        return (CSetting)this.resource.getSettings().getSetting(name);
    }

    public CPerspective getPerspective(String name) {
        CSetting setting = this.getSetting(name);
        if (setting == null) {
            return null;
        }
        return this.control.read(setting, false);
    }

    public void putPerspective(String name, CPerspective perspective) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (perspective == null) {
            throw new IllegalArgumentException("perspective must not be null");
        }
        CSetting setting = this.control.write(perspective, false);
        this.putSetting(name, setting);
    }

    public void putSetting(String name, CSetting setting) {
        this.resource.getSettings().put(name, (Setting)setting);
    }

    public void removePerspective(String name) {
        this.resource.getSettings().remove(name);
    }

    public String getPerspectiveName() {
        return this.resource.getSettings().getCurrentName();
    }

    public void setPerspectiveName(String name) {
        SettingsBlop blop = this.resource.getSettings();
        blop.setCurrent(name, blop.getCurrentSetting());
    }

    public CPerspective getPerspective() {
        CSetting setting = this.getSetting();
        if (setting == null) {
            return null;
        }
        return this.control.read(setting, true);
    }

    public CSetting getSetting() {
        return (CSetting)this.resource.getSettings().getCurrentSetting();
    }

    public void setPerspective(CPerspective perspective) {
        CSetting setting = this.control.write(perspective, true);
        this.setSetting(setting);
    }

    public void setSetting(CSetting setting) {
        SettingsBlop blop = this.resource.getSettings();
        blop.setCurrent(blop.getCurrentName(), (Setting)setting);
    }

    public void readXML(XElement root) throws XException {
        this.resourceManager.readXML(root);
    }

    public void read(DataInputStream in) throws IOException {
        this.resourceManager.readStream(in);
    }

    public void writeXML(XElement root) {
        this.resource.writeXML(root);
    }

    public void write(DataOutputStream out) throws IOException {
        this.resource.write(out);
    }
}

