/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogSpecsTableModel
extends AbstractTableModel {
    private XBCatalog catalog;
    private XBCXNameService nameService;
    private XBCNode node = null;
    private final String[] columnNames = new String[]{"Name", "Type", "XBIndex"};
    private final Class[] columnClasses = new Class[]{String.class, String.class, Long.class};
    private List<CatalogSpecTableItem> items = new ArrayList<CatalogSpecTableItem>();

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.items.get(rowIndex).getName();
            }
            case 1: {
                return this.items.get(rowIndex).getType();
            }
            case 2: {
                return this.items.get(rowIndex).getItem().getXBIndex();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    public XBCNode getNode() {
        return this.node;
    }

    public void setNode(@Nullable XBCNode node) {
        this.node = node;
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        this.items = new ArrayList<CatalogSpecTableItem>();
        if (node != null) {
            this.items.add(new CatalogSpecTableItem((XBCItem)node, CatalogItemType.NODE));
            List formatSpecs = specService.getFormatSpecs(node);
            for (Object spec : formatSpecs) {
                this.items.add(new CatalogSpecTableItem((XBCItem)spec, CatalogItemType.FORMAT));
            }
            List groupSpecs = specService.getGroupSpecs(node);
            for (XBCGroupSpec spec : groupSpecs) {
                this.items.add(new CatalogSpecTableItem((XBCItem)spec, CatalogItemType.GROUP));
            }
            List blockSpecs = specService.getBlockSpecs(node);
            for (XBCBlockSpec spec : blockSpecs) {
                this.items.add(new CatalogSpecTableItem((XBCItem)spec, CatalogItemType.BLOCK));
            }
        }
    }

    public XBCItem getItem(int index) {
        return this.items.get(index).getItem();
    }

    public int getIndexOfItem(CatalogSpecTableItem item) {
        return this.items.indexOf(item);
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
    }

    public class CatalogSpecTableItem {
        private XBCItem item;
        private String name;
        private String type;

        public CatalogSpecTableItem(XBCItem item) {
            this(item, CatalogItemType.NODE);
        }

        public CatalogSpecTableItem(XBCItem item, CatalogItemType itemType) {
            XBCXName itemName;
            this.item = item;
            switch (itemType) {
                case NODE: {
                    this.type = "Node";
                    break;
                }
                case FORMAT: {
                    this.type = "Format";
                    break;
                }
                case GROUP: {
                    this.type = "Group";
                    break;
                }
                case BLOCK: {
                    this.type = "Block";
                    break;
                }
                default: {
                    this.type = "Unknown";
                }
            }
            this.name = itemType == CatalogItemType.NODE ? "." : (CatalogSpecsTableModel.this.nameService != null ? (item == null ? null : ((itemName = CatalogSpecsTableModel.this.nameService.getDefaultItemName(item)) == null ? "" : itemName.getText())) : "spec");
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public XBCItem getItem() {
            return this.item;
        }

        public void setItem(XBCItem item) {
            this.item = item;
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + Objects.hashCode(this.item.getId());
            return hash;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CatalogSpecTableItem other = (CatalogSpecTableItem)obj;
            return Objects.equals(this.item.getId(), other.item.getId());
        }
    }
}

