/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogSelectPlugUiPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;

@ParametersAreNonnullByDefault
public class CatalogSelectUiPanelViewerPanel
extends JPanel {
    private XBACatalog catalog;
    private XBCXPlugUi plugUi;
    private XBApplication application;
    private ButtonGroup editorButtonGroup;
    private JRadioButton noViewerRadioButton;
    private JButton selectViewerButton;
    private JRadioButton viewerRadioButton;
    private JTextField viewerTextField;

    public CatalogSelectUiPanelViewerPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.editorButtonGroup = new ButtonGroup();
        this.noViewerRadioButton = new JRadioButton();
        this.viewerRadioButton = new JRadioButton();
        this.viewerTextField = new JTextField();
        this.selectViewerButton = new JButton();
        this.editorButtonGroup.add(this.noViewerRadioButton);
        this.noViewerRadioButton.setSelected(true);
        this.noViewerRadioButton.setText("No Viewer");
        this.editorButtonGroup.add(this.viewerRadioButton);
        this.viewerRadioButton.setText("Viewer");
        this.viewerTextField.setEditable(false);
        this.selectViewerButton.setText("Select...");
        this.selectViewerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogSelectUiPanelViewerPanel.this.selectViewerButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.viewerTextField, -1, 272, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectViewerButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noViewerRadioButton).addComponent(this.viewerRadioButton)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.noViewerRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewerRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.viewerTextField, -2, -1, -2).addComponent(this.selectViewerButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    private void selectViewerButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectPlugUiPanel selectPanel = new CatalogSelectPlugUiPanel(XBPlugUiType.PANEL_VIEWER);
        selectPanel.setApplication(this.application);
        selectPanel.setCatalog(this.catalog);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)selectPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                this.plugUi = selectPanel.getPlugUi();
                this.viewerRadioButton.setSelected(true);
                this.viewerTextField.setText(String.valueOf(this.plugUi.getId()));
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    @Nullable
    public XBCXPlugUi getPlugUi() {
        return this.noViewerRadioButton.isSelected() ? null : this.plugUi;
    }

    public void setPlugUi(@Nullable XBCXPlugUi plugUi) {
        this.plugUi = plugUi;
        if (plugUi == null) {
            this.noViewerRadioButton.setSelected(true);
            this.viewerTextField.setText("");
        } else {
            this.viewerRadioButton.setSelected(true);
            this.viewerTextField.setText(String.valueOf(plugUi.getId()));
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSelectUiPanelViewerPanel());
    }
}

