/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogSelectSpecPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

@ParametersAreNonnullByDefault
public class CatalogSelectPlugUiPanel
extends JPanel {
    private XBACatalog catalog;
    private XBApplication application;
    private XBCNode node;
    private List<XBCXPlugin> plugins;
    private List<XBCXPlugUi> plugUis;
    private final XBPlugUiType plugUiType;
    private JLabel hooksLabel;
    private JList<String> hooksList;
    private JScrollPane hooksScrollPane;
    private JLabel nodeLabel;
    private JButton nodeSelectButton;
    private JTextField nodeTextField;
    private JLabel pluginsLabel;
    private JList<String> pluginsList;
    private JScrollPane pluginsScrollPane;

    public CatalogSelectPlugUiPanel(XBPlugUiType plugUiType) {
        this.plugUiType = plugUiType;
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setNode(XBCNode node) {
        this.node = node;
        XBCXPlugService plugService = (XBCXPlugService)this.catalog.getCatalogService(XBCXPlugService.class);
        DefaultListModel model = (DefaultListModel)this.pluginsList.getModel();
        model.removeAllElements();
        this.plugins = plugService.findPluginsForNode(node);
        if (this.plugins != null) {
            for (XBCXPlugin plugin : this.plugins) {
                model.addElement(String.valueOf(plugin.getId()) + ": " + plugin.getPluginFile().getFilename());
            }
        }
    }

    @Nullable
    public XBCXPlugUi getPlugUi() {
        int selectedIndex = this.hooksList.getSelectedIndex();
        return selectedIndex < 0 ? null : this.plugUis.get(selectedIndex);
    }

    private void initComponents() {
        this.nodeLabel = new JLabel();
        this.nodeTextField = new JTextField();
        this.nodeSelectButton = new JButton();
        this.pluginsScrollPane = new JScrollPane();
        this.pluginsList = new JList();
        this.pluginsLabel = new JLabel();
        this.hooksLabel = new JLabel();
        this.hooksScrollPane = new JScrollPane();
        this.hooksList = new JList();
        this.nodeLabel.setText("Node");
        this.nodeTextField.setEditable(false);
        this.nodeSelectButton.setText("Select...");
        this.nodeSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogSelectPlugUiPanel.this.nodeSelectButtonActionPerformed(evt);
            }
        });
        this.pluginsList.setModel(new DefaultListModel());
        this.pluginsList.setSelectionMode(0);
        this.pluginsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CatalogSelectPlugUiPanel.this.pluginsListValueChanged(evt);
            }
        });
        this.pluginsScrollPane.setViewportView(this.pluginsList);
        this.pluginsLabel.setText("Plugins");
        this.hooksLabel.setText("Plugin Hooks");
        this.hooksList.setModel(new DefaultListModel());
        this.hooksList.setSelectionMode(0);
        this.hooksScrollPane.setViewportView(this.hooksList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeSelectButton)).addComponent(this.hooksScrollPane).addComponent(this.pluginsScrollPane, -1, 388, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nodeLabel).addComponent(this.hooksLabel).addComponent(this.pluginsLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.nodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeTextField, -2, -1, -2).addComponent(this.nodeSelectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pluginsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pluginsScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hooksLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hooksScrollPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void nodeSelectButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectSpecPanel selectPanel = new CatalogSelectSpecPanel(CatalogItemType.NODE);
        selectPanel.setCatalog(this.catalog);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)selectPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBCNode selectedNode = (XBCNode)selectPanel.getSpec();
                this.setNode(selectedNode);
                XBCXNameService nodeService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
                this.nodeTextField.setText(nodeService.getItemNamePath((XBCItem)selectedNode));
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    private void pluginsListValueChanged(ListSelectionEvent evt) {
        XBCXPlugin plugin = this.plugins.get(this.pluginsList.getSelectedIndex());
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        this.plugUis = uiService.getPlugUis(plugin, this.plugUiType);
        DefaultListModel model = (DefaultListModel)this.hooksList.getModel();
        model.removeAllElements();
        if (this.plugUis != null) {
            for (XBCXPlugUi plugUi : this.plugUis) {
                model.addElement(String.valueOf(plugUi.getId()) + ": " + plugUi.getMethodIndex());
            }
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogSelectPlugUiPanel(XBPlugUiType.ROW_EDITOR));
    }
}

