/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

@ParametersAreNonnullByDefault
public class CatalogPluginsTableModel
extends AbstractTableModel {
    private XBCatalog catalog;
    private XBCXPlugService pluginService;
    private XBCNode node = null;
    private final String[] columnNames = new String[]{"Index", "Filename", "Row Editors", "Panel Viewers", "Panel Editors"};
    private final Class[] columnClasses = new Class[]{Long.class, String.class, Long.class, Long.class, Long.class};
    private List<PluginItemRecord> items = new ArrayList<PluginItemRecord>();

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                XBCXPlugin plugin = this.items.get((int)rowIndex).plugin;
                return plugin == null ? 0L : plugin.getId();
            }
            case 1: {
                return this.items.get((int)rowIndex).fileName;
            }
            case 2: {
                return this.items.get((int)rowIndex).rowEditorsCount;
            }
            case 3: {
                return this.items.get((int)rowIndex).panelViewersCount;
            }
            case 4: {
                return this.items.get((int)rowIndex).panelEditorsCount;
            }
        }
        return "";
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Nullable
    public XBCNode getNode() {
        return this.node;
    }

    public void setNode(@Nullable XBCNode node) {
        this.node = node;
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        this.items = new ArrayList<PluginItemRecord>();
        if (node != null) {
            for (XBCXPlugin plugin : this.pluginService.findPluginsForNode(node)) {
                long rowEditorsCount = uiService.getPlugUisCount(plugin, XBPlugUiType.ROW_EDITOR);
                long panelViewersCount = uiService.getPlugUisCount(plugin, XBPlugUiType.PANEL_VIEWER);
                long panelEditorsCount = uiService.getPlugUisCount(plugin, XBPlugUiType.PANEL_EDITOR);
                this.items.add(new PluginItemRecord(plugin, plugin.getPluginFile(), rowEditorsCount, panelViewersCount, panelEditorsCount));
            }
        }
    }

    public XBCXPlugin getItem(int rowIndex) {
        return this.items.get((int)rowIndex).plugin;
    }

    public void updateItem(int rowIndex, XBCXPlugin plugin, long rowEditorsCount, long panelViewersCount, long panelEditorsCount) {
        PluginItemRecord record = this.items.get(rowIndex);
        record.plugin = plugin;
        record.file = plugin.getPluginFile();
        record.fileName = record.file == null ? "" : record.file.getFilename();
        record.rowEditorsCount = rowEditorsCount;
        record.panelViewersCount = panelViewersCount;
        record.panelEditorsCount = panelEditorsCount;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void addItem(XBCXPlugin plugin, XBCXFile file, long rowEditorsCount, long panelViewersCount, long panelEditorsCount) {
        this.items.add(new PluginItemRecord(plugin, file, rowEditorsCount, panelViewersCount, panelEditorsCount));
        this.fireTableDataChanged();
    }

    public XBCXPlugin removeItem(int rowIndex) {
        XBCXPlugin result = this.items.remove((int)rowIndex).plugin;
        this.fireTableDataChanged();
        return result;
    }

    public void setCatalog(XBCatalog catalog) {
        this.catalog = catalog;
        this.pluginService = catalog == null ? null : (XBCXPlugService)catalog.getCatalogService(XBCXPlugService.class);
    }

    @ParametersAreNonnullByDefault
    private static class PluginItemRecord {
        public XBCXPlugin plugin = null;
        public XBCXFile file;
        public String fileName = null;
        public long rowEditorsCount;
        public long panelViewersCount;
        public long panelEditorsCount;

        public PluginItemRecord(@Nullable XBCXPlugin plugin, XBCXFile file, long rowEditorsCount, long panelViewersCount, long panelEditorsCount) {
            this.plugin = plugin;
            this.file = file;
            this.fileName = file == null ? "" : file.getFilename();
            this.rowEditorsCount = rowEditorsCount;
            this.panelViewersCount = panelViewersCount;
            this.panelEditorsCount = panelEditorsCount;
        }
    }
}

