/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogNodesTreeModel
implements TreeModel {
    private XBCatalog catalog;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    private CatalogNodesTreeItem rootItem = null;

    public CatalogNodesTreeModel() {
        this(null);
    }

    public CatalogNodesTreeModel(@Nullable XBCNode rootNode) {
        this.rootItem = rootNode == null ? null : new CatalogNodesTreeItem(rootNode);
    }

    public void setCatalog(XBCatalog catalog) {
        this.catalog = catalog;
        if (this.rootItem != null) {
            this.rootItem.updateNode();
        }
    }

    @Override
    public Object getRoot() {
        return this.rootItem;
    }

    @Override
    @Nullable
    public Object getChild(Object parent, int index) {
        if (parent == null) {
            return null;
        }
        return ((CatalogNodesTreeItem)parent).getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            throw new NullPointerException("No parent");
        }
        return ((CatalogNodesTreeItem)parent).getChildren().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        return false;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((CatalogNodesTreeItem)parent).getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener tml) {
        this.treeModelListeners.add(tml);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener tml) {
        this.treeModelListeners.remove(tml);
    }

    @Nonnull
    public TreePath findPathForSpec(XBCSpec spec) {
        Long[] specPath = this.catalog.getSpecPath(spec);
        Object[] nodePath = new CatalogNodesTreeItem[specPath.length - 1];
        CatalogNodesTreeItem node = this.rootItem;
        block0: for (int specPathDepth = 0; specPathDepth < specPath.length - 1; ++specPathDepth) {
            Long specPathIndex = specPath[specPathDepth];
            List<CatalogNodesTreeItem> children = node.getChildren();
            for (CatalogNodesTreeItem child : children) {
                if (child.getNode().getXBIndex() != specPathIndex.longValue()) continue;
                nodePath[specPathDepth] = child;
                node = child;
                continue block0;
            }
        }
        return new TreePath(nodePath);
    }

    public class CatalogNodesTreeItem {
        private XBCNode node;
        private String name;
        private boolean loaded = false;
        private final List<CatalogNodesTreeItem> children = new ArrayList<CatalogNodesTreeItem>();

        public CatalogNodesTreeItem(XBCNode node) {
            this.node = node;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public XBCNode getNode() {
            return this.node;
        }

        public void setNode(XBCNode node) {
            this.node = node;
            this.updateNode();
        }

        private void updateNode() {
            XBCXNameService nameService = (XBCXNameService)CatalogNodesTreeModel.this.catalog.getCatalogService(XBCXNameService.class);
            this.name = nameService.getDefaultText((XBCItem)this.node);
        }

        @Nonnull
        public List<CatalogNodesTreeItem> getChildren() {
            if (!this.loaded) {
                XBCNodeService nodeService = (XBCNodeService)CatalogNodesTreeModel.this.catalog.getCatalogService(XBCNodeService.class);
                List subNodes = nodeService.getSubNodes(this.node);
                for (XBCNode subNode : subNodes) {
                    CatalogNodesTreeItem subItem = new CatalogNodesTreeItem(subNode);
                    subItem.updateNode();
                    this.children.add(subItem);
                }
                this.loaded = true;
            }
            return this.children;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + Objects.hashCode(this.node);
            return hash;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CatalogNodesTreeItem other = (CatalogNodesTreeItem)obj;
            return Objects.equals(this.node, other.node);
        }
    }
}

