/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.YamlFileType;
import org.exbin.framework.xbup.catalog.gui.CatalogManagementAware;
import org.exbin.framework.xbup.catalog.item.gui.CatalogEditItemPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemsTableModel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogSearchTableModel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.convert.XBCatalogYaml;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

public class CatalogItemsSearchPanel
extends JPanel
implements CatalogManagementAware {
    private XBApplication application;
    private XBCItem currentItem;
    private XBACatalog catalog;
    private CatalogItemsTableModel itemsModel;
    private final CatalogSearchTableModel searchModel;
    private final XBCatalogYaml catalogYaml;
    private XBCNodeService nodeService;
    private XBCSpecService specService;
    private XBCXNameService nameService;
    private XBCXDescService descService;
    private XBCXStriService striService;
    private final Map<String, ActionListener> actionListenerMap = new HashMap<String, ActionListener>();
    private MenuManagement menuManagement;
    private CatalogSearchTableModel.CatalogSearchTableItem searchConditions = null;
    private SelectionListener selectionListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogItemsSearchPanel.class);
    private JScrollPane catalogItemListScrollPane;
    private JTable catalogItemsListTable;
    private JScrollPane catalogSearchScrollPane;
    private JTable catalogSearchTable;
    private JPopupMenu catalogTreePopupMenu;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JMenuItem popupEditMenuItem;
    private JMenuItem popupExportItemMenuItem;
    private JMenuItem popupRefreshMenuItem;
    private JButton searchButton;
    private JPanel searchPanel;

    public CatalogItemsSearchPanel() {
        this.itemsModel = new CatalogItemsTableModel();
        this.searchModel = new CatalogSearchTableModel();
        this.catalogYaml = new XBCatalogYaml();
        this.initComponents();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(0);
        defaultCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                if (CatalogItemsSearchPanel.this.catalogItemsListTable.getSelectedRowCount() == 0) {
                    CatalogItemsSearchPanel.this.performSearch();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        int columnCount = this.catalogSearchTable.getColumnModel().getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            TableColumn column = this.catalogSearchTable.getColumnModel().getColumn(columnIndex);
            column.setCellEditor(defaultCellEditor);
        }
        this.catalogItemsListTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.catalogItemsListTable.getSelectedRow() >= 0) {
                    this.setItem(this.itemsModel.getItem(this.catalogItemsListTable.getSelectedRow()));
                } else {
                    this.setItem(null);
                }
            }
        });
        this.actionListenerMap.put("cut-to-clipboard", e -> this.performCut());
        this.actionListenerMap.put("copy-to-clipboard", e -> this.performCopy());
        this.actionListenerMap.put("paste-from-clipboard", e -> this.performPaste());
        this.actionListenerMap.put("delete-next", e -> this.performDelete());
        this.actionListenerMap.put("delete", e -> this.performDelete());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void switchToSpecTypeMode(CatalogItemType specType) {
        this.itemsModel.setSpecType(specType);
        this.catalogItemsListTable.getSelectionModel().setSelectionMode(0);
        this.catalogSearchTable.changeSelection(0, 0, false, false);
    }

    private void initComponents() {
        this.catalogTreePopupMenu = new JPopupMenu();
        this.popupRefreshMenuItem = new JMenuItem();
        this.popupEditMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.popupExportItemMenuItem = new JMenuItem();
        this.searchPanel = new JPanel();
        this.catalogSearchScrollPane = new JScrollPane();
        this.catalogSearchTable = new JTable();
        this.searchButton = new JButton();
        this.catalogItemListScrollPane = new JScrollPane();
        this.catalogItemsListTable = new JTable();
        this.catalogTreePopupMenu.setName("catalogTreePopupMenu");
        this.popupRefreshMenuItem.setText(this.resourceBundle.getString("refreshMenuItem.text"));
        this.popupRefreshMenuItem.setToolTipText(this.resourceBundle.getString("refreshMenuItem.toolTipText"));
        this.popupRefreshMenuItem.setName("popupRefreshMenuItem");
        this.popupRefreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogItemsSearchPanel.this.popupRefreshMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupRefreshMenuItem);
        this.popupEditMenuItem.setText(this.resourceBundle.getString("editMenuItem.text"));
        this.popupEditMenuItem.setToolTipText(this.resourceBundle.getString("editMenuItem.toolTipText"));
        this.popupEditMenuItem.setName("popupEditMenuItem");
        this.popupEditMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogItemsSearchPanel.this.popupEditMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupEditMenuItem);
        this.jSeparator1.setName("jSeparator1");
        this.catalogTreePopupMenu.add(this.jSeparator1);
        this.jSeparator2.setName("jSeparator2");
        this.catalogTreePopupMenu.add(this.jSeparator2);
        this.popupExportItemMenuItem.setText(this.resourceBundle.getString("exportItemMenuItem.text"));
        this.popupExportItemMenuItem.setToolTipText(this.resourceBundle.getString("exportItemMenuItem.toolTipText"));
        this.popupExportItemMenuItem.setName("popupExportItemMenuItem");
        this.popupExportItemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogItemsSearchPanel.this.popupExportItemMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupExportItemMenuItem);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.searchPanel.setName("searchPanel");
        this.catalogSearchScrollPane.setName("catalogSearchScrollPane");
        this.catalogSearchTable.setModel(this.searchModel);
        this.catalogSearchTable.setName("catalogSearchTable");
        this.catalogSearchTable.setRowSelectionAllowed(false);
        this.catalogSearchScrollPane.setViewportView(this.catalogSearchTable);
        this.searchButton.setText("Search");
        this.searchButton.setName("searchButton");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogItemsSearchPanel.this.searchButtonActionPerformed(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(0, 409, Short.MAX_VALUE).addComponent(this.searchButton).addContainerGap()).addComponent(this.catalogSearchScrollPane));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.catalogSearchScrollPane, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.searchButton).addContainerGap()));
        this.add((Component)this.searchPanel, "North");
        this.catalogItemListScrollPane.setComponentPopupMenu(this.catalogTreePopupMenu);
        this.catalogItemListScrollPane.setName("catalogItemListScrollPane");
        this.catalogItemsListTable.setModel(this.itemsModel);
        this.catalogItemsListTable.setComponentPopupMenu(this.catalogTreePopupMenu);
        this.catalogItemsListTable.setName("catalogItemsListTable");
        this.catalogItemListScrollPane.setViewportView(this.catalogItemsListTable);
        this.add((Component)this.catalogItemListScrollPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popupExportItemMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentItem != null) {
            JFileChooser exportFileChooser = new JFileChooser();
            exportFileChooser.addChoosableFileFilter(new YamlFileType());
            exportFileChooser.setAcceptAllFileFilterUsed(true);
            if (exportFileChooser.showSaveDialog(UiUtils.getFrame((Component)this)) == 0) {
                try (FileWriter fileWriter = new FileWriter(exportFileChooser.getSelectedFile().getAbsolutePath());){
                    this.catalogYaml.exportCatalogItem(this.currentItem, (Writer)fileWriter);
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(CatalogItemsSearchPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(CatalogItemsSearchPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void popupRefreshMenuItemActionPerformed(ActionEvent evt) {
        Component invoker = this.catalogTreePopupMenu.getInvoker();
        this.reload();
    }

    private void popupEditMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentItem != null) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            CatalogEditItemPanel editPanel = new CatalogEditItemPanel();
            editPanel.setApplication(this.application);
            editPanel.setMenuManagement(this.menuManagement);
            editPanel.setCatalog(this.catalog);
            editPanel.setCatalogItem(this.currentItem);
            editPanel.setVisible(true);
            DefaultControlPanel controlPanel = new DefaultControlPanel();
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)editPanel, (JPanel)controlPanel);
            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), editPanel.getClass(), (ResourceBundle)editPanel.getResourceBundle());
            controlPanel.setHandler(actionType -> {
                if (actionType == DefaultControlHandler.ControlActionType.OK) {
                    EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                    EntityTransaction transaction = em.getTransaction();
                    transaction.begin();
                    editPanel.persist();
                    this.setItem(this.currentItem);
                    em.flush();
                    transaction.commit();
                    this.reload();
                }
                dialog.close();
            });
            dialog.showCentered((Component)this);
            dialog.dispose();
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.searchConditions = this.searchModel.getSearchConditions();
        this.reload();
    }

    public void performSearch() {
        UiUtils.doButtonClick((JButton)this.searchButton);
    }

    public void setItem(XBCItem item) {
        this.currentItem = item;
        this.popupEditMenuItem.setEnabled(item != null);
        this.popupExportItemMenuItem.setEnabled(item != null);
        if (this.selectionListener != null) {
            this.selectionListener.selectedItem(item);
        }
    }

    private void reload() {
        if (this.catalogSearchTable.getCellEditor() != null) {
            this.catalogSearchTable.getCellEditor().stopCellEditing();
        }
        this.itemsModel.performSearch(this.searchConditions);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemsSearchPanel());
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.nodeService = catalog == null ? null : (XBCNodeService)catalog.getCatalogService(XBCNodeService.class);
        this.specService = catalog == null ? null : (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
        this.descService = catalog == null ? null : (XBCXDescService)catalog.getCatalogService(XBCXDescService.class);
        this.striService = catalog == null ? null : (XBCXStriService)catalog.getCatalogService(XBCXStriService.class);
        this.itemsModel.setCatalog(catalog);
        this.catalogYaml.setCatalog(catalog);
    }

    public void performCut() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performPaste() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performDelete() {
        Object[] options = new Object[]{"Delete", "Cancel"};
        int result = JOptionPane.showOptionDialog(this, "Are you sure you want to delete this item?", "Delete Item", 1, 3, null, options, options[0]);
        if (result == 0) {
            EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            List names = this.nameService.getItemNames(this.currentItem);
            for (Object name : names) {
                this.nameService.removeItem((XBCBase)name);
            }
            List descs = this.descService.getItemDescs(this.currentItem);
            for (XBCXDesc desc : descs) {
                this.descService.removeItem((XBCBase)desc);
            }
            XBCXStri stri = this.striService.getItemStringId(this.currentItem);
            if (stri != null) {
                this.striService.removeItem((XBCBase)stri);
            }
            if (this.currentItem instanceof XBCNode) {
                this.nodeService.removeItem((XBCBase)((XBCNode)this.currentItem));
            } else {
                this.specService.removeItem((XBCBase)((XBCSpec)this.currentItem));
            }
            em.flush();
            transaction.commit();
            this.reload();
            this.repaint();
        }
    }

    @Override
    public void setMenuManagement(MenuManagement menuManagement) {
        this.menuManagement = menuManagement;
        menuManagement.insertMainPopupMenu(this.catalogTreePopupMenu, 3);
    }

    public XBCItem getItem() {
        return this.currentItem;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public static interface SelectionListener {
        public void selectedItem(XBCItem var1);
    }
}

