/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class CatalogAvailabilityPanel
extends JPanel {
    private JPanel catalogLoadingPanel;
    private JPanel catalogNotAvailablePanel;
    private JLabel loadingCatalogLabel;
    private JProgressBar loadingProgressBar;
    private JLabel notAvailableLabel;
    private JPanel progressBarPanel;

    public CatalogAvailabilityPanel() {
        this.initComponents();
        this.setNoCatalog();
    }

    private void initComponents() {
        this.catalogNotAvailablePanel = new JPanel();
        this.notAvailableLabel = new JLabel();
        this.catalogLoadingPanel = new JPanel();
        this.progressBarPanel = new JPanel();
        this.loadingProgressBar = new JProgressBar();
        this.loadingCatalogLabel = new JLabel();
        this.setLayout(new CardLayout());
        this.catalogNotAvailablePanel.setLayout(new GridBagLayout());
        this.notAvailableLabel.setHorizontalAlignment(0);
        this.notAvailableLabel.setText("Catalog is not available");
        this.catalogNotAvailablePanel.add((Component)this.notAvailableLabel, new GridBagConstraints());
        this.add((Component)this.catalogNotAvailablePanel, "notAvailable");
        this.catalogLoadingPanel.setLayout(new GridBagLayout());
        this.loadingProgressBar.setMaximum(0);
        this.loadingProgressBar.setIndeterminate(true);
        this.loadingProgressBar.setString("Catalog is loading...");
        this.loadingCatalogLabel.setHorizontalAlignment(0);
        this.loadingCatalogLabel.setText("Catalog is loading...");
        GroupLayout progressBarPanelLayout = new GroupLayout(this.progressBarPanel);
        this.progressBarPanel.setLayout(progressBarPanelLayout);
        progressBarPanelLayout.setHorizontalGroup(progressBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressBarPanelLayout.createSequentialGroup().addContainerGap().addGroup(progressBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadingCatalogLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(progressBarPanelLayout.createSequentialGroup().addComponent(this.loadingProgressBar, -2, 143, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        progressBarPanelLayout.setVerticalGroup(progressBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressBarPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadingCatalogLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadingProgressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.catalogLoadingPanel.add((Component)this.progressBarPanel, new GridBagConstraints());
        this.add((Component)this.catalogLoadingPanel, "catalogLoading");
        this.getAccessibleContext().setAccessibleName("catalog");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogAvailabilityPanel());
    }

    private void setNoCatalog() {
        ((CardLayout)this.getLayout()).show(this, "notAvailable");
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        if (catalog == null) {
            this.setNoCatalog();
        } else {
            ((CardLayout)this.getLayout()).show(this, "catalogLoading");
        }
    }
}

