/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.framework.xbup.catalog.CatalogEditor;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCRoot;

@ParametersAreNonnullByDefault
public class EditCatalogAction
extends AbstractAction {
    public static final String ACTION_ID = "editCatalogAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(EditCatalogAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCRoot activeItem;

    public void setup(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public void setActiveItem(XBCRoot activeItem) {
        this.activeItem = activeItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogEditor catalogEditor = new CatalogEditor();
        catalogEditor.setApplication(this.application);
        catalogEditor.setCatalog(this.catalog);
        catalogEditor.setCatalogRoot(this.activeItem);
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)catalogEditor.getCatalogEditorPanel(), (JPanel)controlPanel);
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        frameModule.setDialogTitle(dialog, catalogEditor.getCatalogEditorPanel().getResourceBundle());
        dialog.showCentered(this.parentComponent);
    }
}

