/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.gui.AddCatalogPanel;
import org.exbin.xbup.catalog.modifiable.XBMRoot;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.manager.XBCRootManager;

@ParametersAreNonnullByDefault
public class AddCatalogAction
extends AbstractAction {
    public static final String ACTION_ID = "addCatalogAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AddCatalogAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private XBCRoot resultRoot;
    private Component parentComponent;

    public void setup(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Nonnull
    public Optional<XBCRoot> getResultRoot() {
        return Optional.ofNullable(this.resultRoot);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        this.resultRoot = null;
        AddCatalogPanel panel = new AddCatalogPanel();
        panel.setApplication(this.application);
        panel.setCatalog(this.catalog);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBCRootManager rootManager = (XBCRootManager)this.catalog.getCatalogManager(XBCRootManager.class);
                this.resultRoot = (XBMRoot)rootManager.createEmptyRoot(panel.getCatalogUrl());
            }
            dialog.close();
            dialog.dispose();
        });
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        dialog.showCentered(this.parentComponent);
    }
}

