/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Comparable<Version> {
    public static final Version VERSION_1_0_4 = new Version(1, 0, 4, null);
    public static final Version VERSION_1_0_5 = new Version(1, 0, 5, null);
    public static final Version VERSION_1_0_6 = new Version(1, 0, 6, null);
    public static final Version VERSION_1_0_7 = new Version(1, 0, 7, null);
    public static final Version VERSION_1_0_8 = new Version(1, 0, 8, null);
    public static final Version VERSION_1_0_8a = new Version(1, 0, 8, "a");
    public static final Version VERSION_1_1_0 = new Version(1, 1, 0, null);
    public static final Version VERSION_1_1_0a = new Version(1, 1, 0, "a");
    public static final Version VERSION_1_1_1 = new Version(1, 1, 1, null);
    public static final Version VERSION_1_1_1a;
    public static final Version CURRENT;
    private int major;
    private int minor;
    private int mikro;
    private String add;

    public Version(int major, int minor, int mikro, String add) {
        if (major < 0) {
            throw new IllegalArgumentException("major must not be smaller than 0");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("minor must not be smaller than 0");
        }
        if (mikro < 0) {
            throw new IllegalArgumentException("mikro must not be smaller than 0");
        }
        if (add == null) {
            add = "";
        }
        this.major = major;
        this.mikro = mikro;
        this.minor = minor;
        this.add = add;
    }

    public static void write(DataOutputStream out, Version version) throws IOException {
        out.writeByte(1);
        out.writeInt(version.major);
        out.writeInt(version.minor);
        out.writeInt(version.mikro);
        out.writeUTF(version.add);
    }

    public static Version read(DataInputStream in) throws IOException {
        byte version = in.readByte();
        if (version != 1) {
            throw new IOException("Unknown format for version");
        }
        int major = in.readInt();
        int minor = in.readInt();
        int mikro = in.readInt();
        String add = in.readUTF();
        return new Version(major, minor, mikro, add);
    }

    public void checkCurrent() throws IOException {
        if (this.compareTo(CURRENT) > 0) {
            throw new IOException("Trying to read something from the future: " + this + " is greater than the current version " + CURRENT);
        }
    }

    public String getAdd() {
        return this.add;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMikro() {
        return this.mikro;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.mikro > o.mikro) {
            return 1;
        }
        if (this.mikro < o.mikro) {
            return -1;
        }
        return this.add.compareTo(o.add);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.mikro + this.add;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.add == null ? 0 : this.add.hashCode());
        result = 31 * result + this.major;
        result = 31 * result + this.mikro;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.add == null ? other.add != null : !this.add.equals(other.add)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.mikro != other.mikro) {
            return false;
        }
        return this.minor == other.minor;
    }

    static {
        CURRENT = VERSION_1_1_1a = new Version(1, 1, 1, "a");
    }
}

