/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.extension;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.extension.Extension;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.util.extension.SharedExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManager {
    private DockController controller;
    private List<Extension> extensions = new ArrayList<Extension>();
    private boolean alive = false;
    private Map<ExtensionName<?>, Share<?>> shared = new HashMap();

    public ExtensionManager(DockController controller) {
        this.controller = controller;
        this.tryLoadDefaultExtensions();
    }

    protected void tryLoadDefaultExtensions() {
        String[] list;
        for (String className : list = new String[]{"glass.eclipse.GlassExtension", "bibliothek.gui.ToolbarExtension"}) {
            try {
                this.tryLoadExtension(className);
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private void tryLoadExtension(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(className);
        Object extension = clazz.newInstance();
        if (extension instanceof Extension) {
            this.add((Extension)extension);
        }
    }

    public void add(Extension extension) {
        this.extensions.add(extension);
        if (this.alive) {
            extension.install(this.controller);
        }
    }

    public void remove(Extension extension) {
        if (this.extensions.remove(extension) && this.alive) {
            extension.uninstall(this.controller);
        }
    }

    public Extension[] getExtensions() {
        return this.extensions.toArray(new Extension[this.extensions.size()]);
    }

    public <E> List<E> load(ExtensionName<E> name) {
        ArrayList<E> result = new ArrayList<E>();
        for (Extension extension : this.extensions) {
            Collection<E> es = extension.load(this.controller, name);
            if (es == null) continue;
            result.addAll(es);
        }
        return result;
    }

    public <E> SharedExtension<E> share(final ExtensionName<E> name) {
        return new SharedExtension<E>(){
            private int bound = 0;

            @Override
            public void bind() {
                if (this.bound == 0) {
                    Share share = (Share)ExtensionManager.this.shared.get(name);
                    if (share == null) {
                        share = new Share(name);
                    }
                    share.bind();
                }
                ++this.bound;
            }

            @Override
            public void unbind() {
                Share share;
                if (this.bound == 0) {
                    throw new IllegalStateException("cannot unbind, counter is already 0");
                }
                --this.bound;
                if (this.bound == 0 && (share = (Share)ExtensionManager.this.shared.get(name)) != null) {
                    share.unbind();
                }
            }

            @Override
            public List<E> get() {
                if (this.bound == 0) {
                    throw new IllegalStateException("SharedExtension is not bound");
                }
                Share share = (Share)ExtensionManager.this.shared.get(name);
                return share.get();
            }

            @Override
            public Iterator<E> iterator() {
                return this.get().iterator();
            }

            @Override
            public ExtensionName<E> getName() {
                return name;
            }
        };
    }

    public void init() {
        this.alive = true;
        for (Extension extension : this.extensions) {
            extension.install(this.controller);
        }
    }

    public void kill() {
        if (this.alive) {
            this.alive = false;
            for (Extension extension : this.extensions) {
                extension.uninstall(this.controller);
            }
            this.extensions.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Share<T> {
        private int bound = 0;
        private List<T> extensions;
        private ExtensionName<T> name;

        public Share(ExtensionName<T> name) {
            this.name = name;
        }

        public void bind() {
            if (this.bound == 0) {
                ExtensionManager.this.shared.put(this.name, this);
            }
            ++this.bound;
        }

        public void unbind() {
            --this.bound;
            if (this.bound == 0) {
                ExtensionManager.this.shared.remove(this.name);
            }
        }

        public List<T> get() {
            if (this.extensions == null) {
                this.extensions = Collections.unmodifiableList(ExtensionManager.this.load(this.name));
            }
            return this.extensions;
        }
    }
}

