/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PaintableComponent;
import java.awt.Component;
import java.awt.Graphics;

public abstract class AbstractPaintableComponent
implements PaintableComponent {
    private BackgroundComponent background;
    private Component component;
    private BackgroundPaint paint;
    private boolean backgroundPainted = false;
    private boolean foregroundPainted = false;
    private boolean borderPainted = false;
    private boolean childrenPainted = false;
    private boolean overlayPainted = false;

    public AbstractPaintableComponent(BackgroundComponent background, Component component, BackgroundPaint paint) {
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        this.background = background;
        this.component = component;
        this.paint = paint;
    }

    public Component getComponent() {
        return this.component;
    }

    public void paint(Graphics g) {
        this.backgroundPainted = false;
        this.foregroundPainted = false;
        if (this.paint != null && this.background != null) {
            this.paint.paint(this.background, this, g);
        }
        if (!this.backgroundPainted) {
            this.background(g);
        }
        if (!this.foregroundPainted) {
            this.foreground(g);
        }
        if (!this.borderPainted) {
            this.border(g);
        }
        if (!this.childrenPainted) {
            this.children(g);
        }
        if (!this.overlayPainted) {
            this.overlay(g);
        }
    }

    public void paintBackground(Graphics g) {
        this.backgroundPainted = true;
        if (g != null) {
            this.background(g);
        }
    }

    public void paintForeground(Graphics g) {
        this.foregroundPainted = true;
        if (g != null) {
            this.foreground(g);
        }
    }

    public void paintBorder(Graphics g) {
        this.borderPainted = true;
        if (g != null) {
            this.border(g);
        }
    }

    public void paintChildren(Graphics g) {
        this.childrenPainted = true;
        if (g != null) {
            this.children(g);
        }
    }

    public void paintOverlay(Graphics g) {
        this.overlayPainted = true;
        if (g != null) {
            this.overlay(g);
        }
    }

    protected abstract void background(Graphics var1);

    protected abstract void foreground(Graphics var1);

    protected abstract void border(Graphics var1);

    protected abstract void children(Graphics var1);

    protected abstract void overlay(Graphics var1);
}

