/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTabPane<T extends Tab, M extends TabMenu, I extends LonelyTabPaneComponent>
implements TabPane {
    private PropertyValue<TabLayoutManager> layoutManager = new PropertyValue<TabLayoutManager>(TabPane.LAYOUT_MANAGER){

        @Override
        protected void valueChanged(TabLayoutManager oldValue, TabLayoutManager newValue) {
            if (oldValue != null) {
                oldValue.uninstall(AbstractTabPane.this);
            }
            if (newValue != null) {
                newValue.install(AbstractTabPane.this);
            }
        }
    };
    private DockController controller;
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private Dockable selection;
    private Map<Dockable, T> tabs = new HashMap<Dockable, T>();
    private List<M> menus = new ArrayList<M>();
    private Map<Dockable, M> menuPosition = new HashMap<Dockable, M>();
    private List<TabPaneListener> listeners = new ArrayList<TabPaneListener>();
    private I info;
    private TabPlacement tabPlacement = TabPlacement.TOP_OF_DOCKABLE;

    public void setController(DockController controller) {
        this.controller = controller;
        this.layoutManager.setProperties(controller);
        this.fireControllerChanged();
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    public void setDockTabPlacement(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("tab placement must not be null");
        }
        this.tabPlacement = tabPlacement;
        this.revalidate();
    }

    @Override
    public TabPlacement getDockTabPlacement() {
        return this.tabPlacement;
    }

    public void doLayout() {
        TabLayoutManager layout = this.layoutManager.getValue();
        if (layout != null) {
            layout.layout(this);
        }
    }

    public Dimension getMinimumSize() {
        TabLayoutManager layout = this.layoutManager.getValue();
        if (layout != null) {
            return layout.getMinimumSize(this);
        }
        return new Dimension(1, 1);
    }

    public Dimension getPreferredSize() {
        TabLayoutManager layout = this.layoutManager.getValue();
        if (layout != null) {
            return layout.getPreferredSize(this);
        }
        return new Dimension(1, 1);
    }

    public void revalidate() {
        this.doLayout();
    }

    @Override
    public void addTabPaneListener(TabPaneListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTabPaneListener(TabPaneListener listener) {
        this.listeners.remove(listener);
    }

    protected TabPaneListener[] listeners() {
        return this.listeners.toArray(new TabPaneListener[this.listeners.size()]);
    }

    protected void fireSelectionChanged() {
        for (TabPaneListener listener : this.listeners()) {
            listener.selectionChanged(this);
        }
    }

    protected void fireAdded(Dockable dockable) {
        for (TabPaneListener listener : this.listeners()) {
            listener.added(this, dockable);
        }
    }

    protected void fireRemoved(Dockable dockable) {
        for (TabPaneListener listener : this.listeners()) {
            listener.removed(this, dockable);
        }
    }

    protected void fireInfoComponentChanged(I oldInfo, I newInfo) {
        for (TabPaneListener listener : this.listeners()) {
            listener.infoComponentChanged(this, (LonelyTabPaneComponent)oldInfo, (LonelyTabPaneComponent)newInfo);
        }
    }

    protected void fireControllerChanged() {
        for (TabPaneListener listener : this.listeners()) {
            listener.controllerChanged(this, this.controller);
        }
    }

    public TabLayoutManager getLayoutManager() {
        return this.layoutManager.getValue();
    }

    public void setLayoutManager(TabLayoutManager layoutManager) {
        this.layoutManager.setValue(layoutManager);
    }

    public void insert(int index, Dockable dockable) {
        int size = this.getDockableCount();
        this.dockables.add(index, dockable);
        this.fireAdded(dockable);
        if (size == 0) {
            this.setSelectedDockable(dockable);
        }
        this.revalidate();
    }

    public void move(int source, int destination) {
        if (destination < 0 || destination >= this.getDockableCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Dockable dockable = this.dockables.remove(source);
        this.cleanOut(dockable);
        this.dockables.add(destination, dockable);
        this.revalidate();
    }

    public void remove(int index) {
        Dockable dockable = this.dockables.remove(index);
        boolean selected = false;
        if (this.selection == dockable) {
            selected = true;
            this.setSelectedDockable(null);
        }
        this.cleanOut(dockable);
        this.fireRemoved(dockable);
        if (selected) {
            if (index >= this.getDockableCount()) {
                index = this.getDockableCount() - 1;
            }
            if (index >= 0) {
                this.setSelectedDockable(this.getDockable(index));
            }
        }
        this.revalidate();
    }

    public void removeAll() {
        for (Tab tab : this.tabs.values()) {
            tab.setPaneVisible(false);
            this.tabRemoved(tab);
        }
        this.clearTabs();
        for (Map.Entry entry : this.menuPosition.entrySet()) {
            this.removeFromMenu((TabMenu)entry.getValue(), (Dockable)entry.getKey());
        }
        this.menuPosition.clear();
        for (Dockable dockable : this.dockables) {
            this.fireRemoved(dockable);
        }
        this.setSelectedDockable(null);
        this.dockables.clear();
        this.revalidate();
    }

    public void discardComponentsAndRebuild() {
        for (Tab tab : this.tabs.values()) {
            tab.setPaneVisible(false);
            this.tabRemoved(tab);
        }
        this.clearTabs();
        for (Map.Entry entry : this.menuPosition.entrySet()) {
            this.removeFromMenu((TabMenu)entry.getValue(), (Dockable)entry.getKey());
        }
        this.menuPosition.clear();
        this.doLayout();
    }

    @Override
    public Dockable getSelectedDockable() {
        return this.selection;
    }

    @Override
    public void setSelectedDockable(Dockable dockable) {
        if (this.selection != dockable) {
            this.selection = dockable;
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    @Override
    public Dockable[] getDockables() {
        return this.dockables.toArray(new Dockable[this.dockables.size()]);
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public Dockable getDockable(int index) {
        return this.dockables.get(index);
    }

    public int indexOf(Dockable dockable) {
        return this.dockables.indexOf(dockable);
    }

    @Override
    public Tab[] getTabs() {
        ArrayList<Tab> list = new ArrayList<Tab>();
        for (Tab tab : this.tabs.values()) {
            if (!tab.isPaneVisible()) continue;
            list.add(tab);
        }
        return list.toArray(new Tab[list.size()]);
    }

    public int indexOfVisible(Tab tab) {
        int index = 0;
        int n = this.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Tab check = (Tab)this.tabs.get(this.dockables.get(i));
            if (check == null || !check.isPaneVisible()) continue;
            if (tab == check) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public T getVisibleTab(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index to small");
        }
        int n = this.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Tab check = (Tab)this.tabs.get(this.dockables.get(i));
            if (check == null || !check.isPaneVisible()) continue;
            if (index == 0) {
                return (T)check;
            }
            --index;
        }
        return null;
    }

    public int getVisibleTabCount() {
        int count = 0;
        for (Tab check : this.tabs.values()) {
            if (!check.isPaneVisible()) continue;
            ++count;
        }
        return count;
    }

    public List<T> getTabsList() {
        return new ArrayList<T>(this.tabs.values());
    }

    public T getTab(Dockable dockable) {
        return (T)((Tab)this.tabs.get(dockable));
    }

    public T putOnTab(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (!this.dockables.contains(dockable)) {
            throw new IllegalArgumentException("dockable not child of this pane");
        }
        Tab tab = (Tab)this.tabs.get(dockable);
        if (tab == null) {
            tab = this.newTab(dockable);
            tab.setOrientation(this.getDockTabPlacement());
            this.putTab(dockable, tab);
        }
        tab.setPaneVisible(true);
        TabMenu menu = (TabMenu)this.menuPosition.remove(dockable);
        if (menu != null) {
            this.removeFromMenu(menu, dockable);
        }
        return (T)tab;
    }

    public T getOnTab(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (!this.dockables.contains(dockable)) {
            throw new IllegalArgumentException("dockable not child of this pane");
        }
        Tab tab = (Tab)this.tabs.get(dockable);
        if (tab == null) {
            tab = this.newTab(dockable);
            tab.setOrientation(this.getDockTabPlacement());
            this.putTab(dockable, tab);
        }
        return (T)tab;
    }

    public void setInfoComponent(I info) {
        if (this.info != info) {
            if (this.info != null) {
                this.info.setPaneVisible(false);
            }
            I oldInfo = this.info;
            this.info = info;
            if (this.info != null) {
                this.info.setPaneVisible(true);
            }
            this.fireInfoComponentChanged(oldInfo, info);
        }
    }

    public I getInfoComponent() {
        return this.info;
    }

    public List<M> getMenuList() {
        return new ArrayList<M>(this.menus);
    }

    public TabMenu[] getMenus() {
        return this.menus.toArray(new TabMenu[this.menus.size()]);
    }

    public M getMenu(Dockable dockable) {
        return (M)((TabMenu)this.menuPosition.get(dockable));
    }

    @Override
    public void putInMenu(TabMenu menu, Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockables must not be null");
        }
        if (!this.dockables.contains(dockable)) {
            throw new IllegalArgumentException("not child of this pane: " + dockable);
        }
        if (menu == null) {
            throw new IllegalArgumentException("menu is null");
        }
        if (!this.menus.contains(menu)) {
            throw new IllegalArgumentException("menu not created by this pane");
        }
        TabMenu currentMenu = (TabMenu)this.menuPosition.get(dockable);
        if (currentMenu == menu) {
            return;
        }
        if (currentMenu != null) {
            this.removeFromMenu(currentMenu, dockable);
        }
        this.addToMenu(menu, dockable);
        this.menuPosition.put(dockable, menu);
        Tab tab = (Tab)this.tabs.get(dockable);
        if (tab != null) {
            tab.setPaneVisible(false);
        }
    }

    @Override
    public TabMenu createMenu() {
        M menu = this.newMenu();
        this.menus.add(menu);
        return menu;
    }

    @Override
    public void destroyMenu(TabMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu is null");
        }
        if (!this.menus.remove(menu)) {
            throw new IllegalArgumentException("menu not created by this pane");
        }
        menu.setPaneVisible(false);
        for (Dockable dockable : menu.getDockables()) {
            this.menuPosition.remove(dockable);
        }
        this.menuRemoved(menu);
    }

    protected abstract void addToMenu(M var1, Dockable var2);

    protected abstract void removeFromMenu(M var1, Dockable var2);

    private void cleanOut(Dockable dockable) {
        TabMenu menu;
        T tab = this.removeTab(dockable);
        if (tab != null) {
            tab.setPaneVisible(false);
            this.tabRemoved(tab);
        }
        if ((menu = (TabMenu)this.menuPosition.remove(dockable)) != null) {
            this.removeFromMenu(menu, dockable);
        }
    }

    protected T putTab(Dockable dockable, T tab) {
        return (T)((Tab)this.tabs.put(dockable, tab));
    }

    protected T removeTab(Dockable dockable) {
        return (T)((Tab)this.tabs.remove(dockable));
    }

    protected void clearTabs() {
        this.tabs.clear();
    }

    protected abstract T newTab(Dockable var1);

    public abstract M newMenu();

    protected abstract void tabRemoved(T var1);

    protected abstract void menuRemoved(M var1);
}

