/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;

public class PutInfo {
    private SplitNode node;
    private Put put;
    private Dockable dockable;
    private double divider;
    private int oldSize;
    private Leaf leaf;
    private CombinerSource combinerSource;
    private CombinerTarget combinerTarget;
    private boolean combining;

    public PutInfo(SplitNode node, Put put, Dockable dockable, boolean combining) {
        this.node = node;
        this.put = put;
        this.dockable = dockable;
        this.combining = combining;
    }

    public boolean willHaveNoEffect() {
        SplitNode parent;
        if (this.node instanceof Leaf && (parent = this.node.getParent()) instanceof Node) {
            if (((Node)parent).getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                if (this.put == Put.TOP || this.put == Put.BOTTOM) {
                    parent = null;
                }
            } else if (this.put == Put.LEFT || this.put == Put.RIGHT) {
                parent = null;
            }
            if (parent != null) {
                SplitNode neighbor = null;
                if (this.put == Put.LEFT || this.put == Put.TOP) {
                    neighbor = ((Node)parent).getLeft();
                } else if (this.put == Put.RIGHT || this.put == Put.BOTTOM) {
                    neighbor = ((Node)parent).getRight();
                }
                if (neighbor instanceof Leaf && ((Leaf)neighbor).getDockable() == this.dockable) {
                    return true;
                }
            }
        }
        return false;
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public void setNode(SplitNode node) {
        this.node = node;
    }

    public SplitNode getNode() {
        return this.node;
    }

    public void setPut(Put put) {
        this.put = put;
    }

    public Put getPut() {
        return this.put;
    }

    public boolean isCombining() {
        return this.combining;
    }

    public void setDivider(double divider) {
        this.divider = divider;
    }

    public double getDivider() {
        return this.divider;
    }

    public void setOldSize(int oldSize) {
        this.oldSize = oldSize;
    }

    public int getOldSize() {
        return this.oldSize;
    }

    public void setLeaf(Leaf leaf) {
        this.leaf = leaf;
    }

    public Leaf getLeaf() {
        return this.leaf;
    }

    public void setCombination(CombinerSource source, CombinerTarget target) {
        this.combinerSource = source;
        this.combinerTarget = target;
    }

    public CombinerSource getCombinerSource() {
        return this.combinerSource;
    }

    public CombinerTarget getCombinerTarget() {
        return this.combinerTarget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Put {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM,
        CENTER,
        TITLE;

    }
}

