/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.layer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerPriority
implements Comparable<LayerPriority> {
    public static final LayerPriority FALLBACK = new LayerPriority(0.1f, false);
    public static final LayerPriority OUTSIDE_LOW = new LayerPriority(0.2f, false);
    public static final LayerPriority BASE = new LayerPriority(0.3f, false);
    public static final LayerPriority OVERRIDE_GUESS = new LayerPriority(0.4f, true);
    public static final LayerPriority OVERRIDE_PRECISE = new LayerPriority(0.5f, false);
    public static final LayerPriority OUTSIDE_HIGH = new LayerPriority(0.6f, false);
    public static final LayerPriority FLOAT_ANCHORED = new LayerPriority(0.7f, false);
    public static final LayerPriority FLOAT_FREE = new LayerPriority(0.8f, false);
    private LayerPriority sub;
    private boolean reverse;
    private float priority;

    public LayerPriority(float priority, boolean reverse) {
        this(priority, reverse, null);
    }

    public LayerPriority(float priority, boolean reverse, LayerPriority sub) {
        this.priority = priority;
        this.reverse = reverse;
        this.sub = sub;
    }

    public LayerPriority merge(LayerPriority sub) {
        return new LayerPriority(this.getPriority(), sub.isReverse(), sub);
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public float getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(LayerPriority o) {
        if (o == this) {
            return 0;
        }
        int result = this.compareDirect(o);
        if (result != 0) {
            return result;
        }
        if (this.sub == null && o.sub == null) {
            return 0;
        }
        if (this.sub == null && o.sub != null) {
            return 1;
        }
        if (this.sub != null && o.sub == null) {
            return -1;
        }
        return this.sub.compareTo(o.sub);
    }

    private int compareDirect(LayerPriority o) {
        if (this.getPriority() > o.getPriority()) {
            return -1;
        }
        if (this.getPriority() < o.getPriority()) {
            return 1;
        }
        if (!this.isReverse() && o.isReverse()) {
            return -1;
        }
        if (this.isReverse() && !o.isReverse()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String base = "layer [priority=" + this.getPriority() + ", reverse=" + this.isReverse() + "]";
        if (this.sub != null) {
            base = base + " -> " + this.sub;
        }
        return base;
    }
}

