/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.FocusHistory;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.LinkedList;
import java.util.List;

public class DefaultFocusHistory
implements FocusHistory {
    private DockController controller;
    private List<Dockable> history = new LinkedList<Dockable>();
    private Listener listener = new Listener();

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.getRegister().removeDockRegisterListener(this.listener);
            this.controller.getFocusController().removeDockableFocusListener(this.listener);
        }
        this.history.clear();
        this.controller = controller;
        if (this.controller != null) {
            this.controller.getRegister().addDockRegisterListener(this.listener);
            this.controller.getFocusController().addDockableFocusListener(this.listener);
        }
    }

    public Dockable[] getHistory() {
        Dockable[] result = new Dockable[this.history.size()];
        int index = result.length - 1;
        for (Dockable item : this.history) {
            result[index--] = item;
        }
        return result;
    }

    public Dockable getNewestOn(DockStation ... parents) {
        for (Dockable item : this.history) {
            for (DockStation station : parents) {
                if (!DockUtilities.isAncestor(station, item)) continue;
                return item;
            }
        }
        return null;
    }

    private class Listener
    extends DockRegisterAdapter
    implements DockableFocusListener {
        private Listener() {
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            DefaultFocusHistory.this.history.remove(dockable);
        }

        public void dockableFocused(DockableFocusEvent event) {
            Dockable owner = event.getNewFocusOwner();
            if (owner != null) {
                DefaultFocusHistory.this.history.remove(owner);
                DefaultFocusHistory.this.history.add(0, owner);
            }
        }
    }
}

