/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.popup.handler;

import java.awt.datatransfer.StringSelection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JList;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.ClipboardUtils;

@ParametersAreNonnullByDefault
public class ListPopupHandler
implements ClipboardActionsHandler {
    private final JList<?> listComp;

    public ListPopupHandler(JList<?> listComp) {
        this.listComp = listComp;
    }

    public void performCut() {
        throw new IllegalStateException();
    }

    public void performCopy() {
        StringBuilder builder = new StringBuilder();
        List<?> rows = this.listComp.getSelectedValuesList();
        boolean empty = true;
        for (Object row : rows) {
            builder.append(empty ? row.toString() : System.getProperty("line.separator") + row);
            if (!empty) continue;
            empty = false;
        }
        ClipboardUtils.getClipboard().setContents(new StringSelection(builder.toString()), null);
    }

    public void performPaste() {
        throw new IllegalStateException();
    }

    public void performDelete() {
        throw new IllegalStateException();
    }

    public void performSelectAll() {
        if (this.listComp.getModel().getSize() > 0) {
            this.listComp.setSelectionInterval(0, this.listComp.getModel().getSize() - 1);
        }
    }

    public boolean isSelection() {
        return this.listComp.isEnabled() && !this.listComp.isSelectionEmpty();
    }

    public boolean isEditable() {
        return false;
    }

    public boolean canSelectAll() {
        return this.listComp.isEnabled() && this.listComp.getSelectionMode() != 0 && this.listComp.getModel().getSize() > 0;
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }

    public boolean canPaste() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }
}

