/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.service;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.bined.search.ReplaceParameters;
import org.exbin.framework.bined.search.SearchParameters;

@ParametersAreNonnullByDefault
public interface BinarySearchService {
    public void performFind(SearchParameters var1, SearchStatusListener var2);

    public void setMatchPosition(int var1);

    public void performFindAgain(SearchStatusListener var1);

    public void performReplace(SearchParameters var1, ReplaceParameters var2);

    @Nonnull
    public SearchParameters getLastSearchParameters();

    public void clearMatches();

    public static class FoundMatches {
        private int matchesCount;
        private int matchPosition;

        public FoundMatches() {
            this.matchesCount = 0;
            this.matchPosition = -1;
        }

        public FoundMatches(int matchesCount, int matchPosition) {
            if (matchPosition >= matchesCount) {
                throw new IllegalStateException("Match position is out of range");
            }
            this.matchesCount = matchesCount;
            this.matchPosition = matchPosition;
        }

        public int getMatchesCount() {
            return this.matchesCount;
        }

        public int getMatchPosition() {
            return this.matchPosition;
        }

        public void setMatchesCount(int matchesCount) {
            this.matchesCount = matchesCount;
        }

        public void setMatchPosition(int matchPosition) {
            this.matchPosition = matchPosition;
        }

        public void next() {
            if (this.matchPosition == this.matchesCount - 1) {
                throw new IllegalStateException("Cannot find next on last match");
            }
            ++this.matchPosition;
        }

        public void prev() {
            if (this.matchPosition == 0) {
                throw new IllegalStateException("Cannot find previous on first match");
            }
            --this.matchPosition;
        }
    }

    @ParametersAreNonnullByDefault
    public static interface SearchStatusListener {
        public void setStatus(FoundMatches var1, SearchParameters.MatchMode var2);

        public void clearStatus();
    }
}

