/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.search.ReplaceParameters;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.bined.search.SearchHistoryModel;
import org.exbin.framework.bined.search.SearchParameters;
import org.exbin.framework.bined.search.gui.BinarySearchComboBoxPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class FindBinaryPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(FindBinaryPanel.class);
    public static final String POPUP_MENU_POSTFIX = ".searchFindBinaryPanel";
    private final ExtCodeArea findCodeArea = new ExtCodeArea();
    private BinarySearchComboBoxPanel findComboBoxEditorComponent;
    private ComboBoxEditor findComboBoxEditor;
    private List<SearchCondition> searchHistory = new ArrayList<SearchCondition>();
    private final ExtCodeArea replaceCodeArea = new ExtCodeArea();
    private BinarySearchComboBoxPanel replaceComboBoxEditorComponent;
    private ComboBoxEditor replaceComboBoxEditor;
    private List<SearchCondition> replaceHistory = new ArrayList<SearchCondition>();
    private CodeAreaPopupMenuHandler codeAreaPopupMenuHandler;
    private MultilineEditorListener multilineEditorListener = null;
    private JComboBox<SearchCondition> findComboBox;
    private JLabel findLabel;
    private JButton findMultilineButton;
    private JPanel findPanel;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox multipleMatchesCheckBox;
    private JCheckBox performReplaceCheckBox;
    private JCheckBox replaceAllMatchesCheckBox;
    private JComboBox<SearchCondition> replaceComboBox;
    private JLabel replaceLabel;
    private JButton replaceMultilineButton;
    private JPanel replacePanel;
    private JButton replaceTypeButton;
    private JCheckBox searchBackwardCheckBox;
    private JCheckBox searchFromCursorCheckBox;
    private JButton searchTypeButton;

    public FindBinaryPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        ExtendedCodeAreaLayoutProfile layoutProfile = Objects.requireNonNull(this.findCodeArea.getLayoutProfile());
        layoutProfile.setShowHeader(false);
        layoutProfile.setShowRowPosition(false);
        this.findCodeArea.setLayoutProfile(layoutProfile);
        this.findCodeArea.setRowWrapping(RowWrappingMode.WRAPPING);
        this.findCodeArea.setWrappingBytesGroupSize(0);
        ExtendedCodeAreaThemeProfile themeProfile = this.findCodeArea.getThemeProfile();
        themeProfile.setBackgroundPaintMode(ExtendedBackgroundPaintMode.PLAIN);
        this.findCodeArea.setThemeProfile(themeProfile);
        this.findCodeArea.setVerticalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.findCodeArea.setHorizontalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.findCodeArea.setContentData((BinaryData)new ByteArrayEditableData());
        this.findComboBoxEditorComponent = new BinarySearchComboBoxPanel();
        this.findComboBox.setRenderer(new ListCellRenderer<SearchCondition>(){
            private final JPanel emptyPanel = new JPanel();
            private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

            @Override
            public Component getListCellRendererComponent(JList<? extends SearchCondition> list, SearchCondition value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return this.emptyPanel;
                }
                if (value.getSearchMode() == SearchCondition.SearchMode.TEXT) {
                    return this.listCellRenderer.getListCellRendererComponent(list, value.getSearchText(), index, isSelected, cellHasFocus);
                }
                FindBinaryPanel.this.findCodeArea.setContentData(value.getBinaryData());
                FindBinaryPanel.this.findCodeArea.setPreferredSize(new Dimension(200, 20));
                Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
                FindBinaryPanel.this.findCodeArea.setBackground(backgroundColor);
                return FindBinaryPanel.this.findCodeArea;
            }
        });
        this.findComboBoxEditor = new ComboBoxEditor(){

            @Override
            public Component getEditorComponent() {
                return FindBinaryPanel.this.findComboBoxEditorComponent;
            }

            @Override
            public void setItem(Object item) {
                FindBinaryPanel.this.findComboBoxEditorComponent.setItem((SearchCondition)item);
                FindBinaryPanel.this.updateFindStatus();
            }

            @Override
            public Object getItem() {
                return FindBinaryPanel.this.findComboBoxEditorComponent.getItem();
            }

            @Override
            public void selectAll() {
                FindBinaryPanel.this.findComboBoxEditorComponent.selectAll();
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        };
        this.findComboBox.setEditor(this.findComboBoxEditor);
        this.findComboBox.setModel(new SearchHistoryModel(this.searchHistory));
        layoutProfile = Objects.requireNonNull(this.replaceCodeArea.getLayoutProfile());
        layoutProfile.setShowHeader(false);
        layoutProfile.setShowRowPosition(false);
        this.replaceCodeArea.setLayoutProfile(layoutProfile);
        this.replaceCodeArea.setRowWrapping(RowWrappingMode.WRAPPING);
        this.replaceCodeArea.setWrappingBytesGroupSize(0);
        themeProfile = this.replaceCodeArea.getThemeProfile();
        themeProfile.setBackgroundPaintMode(ExtendedBackgroundPaintMode.PLAIN);
        this.replaceCodeArea.setThemeProfile(themeProfile);
        this.replaceCodeArea.setVerticalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.replaceCodeArea.setHorizontalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.replaceCodeArea.setContentData((BinaryData)new ByteArrayEditableData());
        this.replaceComboBoxEditorComponent = new BinarySearchComboBoxPanel();
        this.replaceComboBox.setRenderer(new ListCellRenderer<SearchCondition>(){
            private final JPanel emptyPanel = new JPanel();
            private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

            @Override
            public Component getListCellRendererComponent(JList<? extends SearchCondition> list, SearchCondition value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return this.emptyPanel;
                }
                if (value.getSearchMode() == SearchCondition.SearchMode.TEXT) {
                    return this.listCellRenderer.getListCellRendererComponent(list, value.getSearchText(), index, isSelected, cellHasFocus);
                }
                FindBinaryPanel.this.replaceCodeArea.setContentData(value.getBinaryData());
                FindBinaryPanel.this.replaceCodeArea.setPreferredSize(new Dimension(200, 20));
                if (isSelected) {
                    Color backgroundColor = list.getSelectionBackground();
                } else {
                    Color backgroundColor = list.getBackground();
                }
                return FindBinaryPanel.this.replaceCodeArea;
            }
        });
        this.replaceComboBoxEditor = new ComboBoxEditor(){

            @Override
            public Component getEditorComponent() {
                return FindBinaryPanel.this.replaceComboBoxEditorComponent;
            }

            @Override
            public void setItem(Object item) {
                FindBinaryPanel.this.replaceComboBoxEditorComponent.setItem((SearchCondition)item);
                FindBinaryPanel.this.updateReplaceStatus();
            }

            @Override
            public Object getItem() {
                return FindBinaryPanel.this.replaceComboBoxEditorComponent.getItem();
            }

            @Override
            public void selectAll() {
                FindBinaryPanel.this.replaceComboBoxEditorComponent.selectAll();
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        };
        this.replaceComboBox.setEditor(this.replaceComboBoxEditor);
        this.replaceComboBox.setModel(new SearchHistoryModel(this.replaceHistory));
    }

    public void setSelected() {
        this.findComboBox.requestFocusInWindow();
        this.findComboBox.getEditor().selectAll();
    }

    private void initComponents() {
        this.findPanel = new JPanel();
        this.findLabel = new JLabel();
        this.searchTypeButton = new JButton();
        this.findComboBox = new JComboBox();
        this.findMultilineButton = new JButton();
        this.searchFromCursorCheckBox = new JCheckBox();
        this.matchCaseCheckBox = new JCheckBox();
        this.multipleMatchesCheckBox = new JCheckBox();
        this.searchBackwardCheckBox = new JCheckBox();
        this.replacePanel = new JPanel();
        this.performReplaceCheckBox = new JCheckBox();
        this.replaceLabel = new JLabel();
        this.replaceTypeButton = new JButton();
        this.replaceComboBox = new JComboBox();
        this.replaceMultilineButton = new JButton();
        this.replaceAllMatchesCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.findPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("findPanel.border.title")));
        this.findLabel.setText(this.resourceBundle.getString("findLabel.text"));
        this.searchTypeButton.setText(this.resourceBundle.getString("searchTypeButton.text"));
        this.searchTypeButton.setToolTipText(this.resourceBundle.getString("searchTypeButton.toolTipText"));
        this.searchTypeButton.setFocusable(false);
        this.searchTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBinaryPanel.this.searchTypeButtonActionPerformed(evt);
            }
        });
        this.findComboBox.setEditable(true);
        this.findComboBox.setMinimumSize(new Dimension(136, 30));
        this.findComboBox.setPreferredSize(new Dimension(136, 30));
        this.findMultilineButton.setText(this.resourceBundle.getString("findMultilineButton.text"));
        this.findMultilineButton.setToolTipText(this.resourceBundle.getString("findMultilineButton.toolTipText"));
        this.findMultilineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBinaryPanel.this.findMultilineButtonActionPerformed(evt);
            }
        });
        this.searchFromCursorCheckBox.setSelected(true);
        this.searchFromCursorCheckBox.setText(this.resourceBundle.getString("searchFromCursorCheckBox.text"));
        this.matchCaseCheckBox.setText(this.resourceBundle.getString("matchCaseCheckBox.text"));
        this.multipleMatchesCheckBox.setSelected(true);
        this.multipleMatchesCheckBox.setText(this.resourceBundle.getString("multipleMatchesCheckBox.text"));
        this.searchBackwardCheckBox.setText(this.resourceBundle.getString("searchBackwardCheckBox.text"));
        GroupLayout findPanelLayout = new GroupLayout(this.findPanel);
        this.findPanel.setLayout(findPanelLayout);
        findPanelLayout.setHorizontalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(findPanelLayout.createSequentialGroup().addContainerGap().addGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchCaseCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.searchFromCursorCheckBox, -1, -1, Short.MAX_VALUE).addGroup(findPanelLayout.createSequentialGroup().addComponent(this.searchTypeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findMultilineButton)).addComponent(this.multipleMatchesCheckBox, -1, 378, Short.MAX_VALUE).addGroup(findPanelLayout.createSequentialGroup().addComponent(this.findLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.searchBackwardCheckBox, -1, 378, Short.MAX_VALUE)).addContainerGap()));
        findPanelLayout.setVerticalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(findPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.findLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findComboBox, -2, -1, -2).addComponent(this.findMultilineButton).addComponent(this.searchTypeButton)).addGap(18, 18, 18).addComponent(this.searchFromCursorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.matchCaseCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multipleMatchesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchBackwardCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.findPanel, "First");
        this.replacePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("replacePanel.border.title")));
        this.performReplaceCheckBox.setText(this.resourceBundle.getString("performReplaceCheckBox.text"));
        this.performReplaceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBinaryPanel.this.performReplaceCheckBoxActionPerformed(evt);
            }
        });
        this.replaceLabel.setText(this.resourceBundle.getString("textToReplaceLabel.text"));
        this.replaceLabel.setEnabled(false);
        this.replaceTypeButton.setText(this.resourceBundle.getString("replaceTypeButton.text"));
        this.replaceTypeButton.setToolTipText(this.resourceBundle.getString("replaceTypeButton.toolTipText"));
        this.replaceTypeButton.setEnabled(false);
        this.replaceTypeButton.setFocusable(false);
        this.replaceTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBinaryPanel.this.replaceTypeButtonActionPerformed(evt);
            }
        });
        this.replaceComboBox.setEditable(true);
        this.replaceComboBox.setEnabled(false);
        this.replaceComboBox.setMinimumSize(new Dimension(136, 30));
        this.replaceComboBox.setPreferredSize(new Dimension(136, 30));
        this.replaceMultilineButton.setText(this.resourceBundle.getString("replaceMultilineButton.text"));
        this.replaceMultilineButton.setToolTipText(this.resourceBundle.getString("replaceMultilineButton.toolTipText"));
        this.replaceMultilineButton.setEnabled(false);
        this.replaceMultilineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindBinaryPanel.this.replaceMultilineButtonActionPerformed(evt);
            }
        });
        this.replaceAllMatchesCheckBox.setText(this.resourceBundle.getString("replaceAllMatchesCheckBox.text"));
        this.replaceAllMatchesCheckBox.setEnabled(false);
        GroupLayout replacePanelLayout = new GroupLayout(this.replacePanel);
        this.replacePanel.setLayout(replacePanelLayout);
        replacePanelLayout.setHorizontalGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(replacePanelLayout.createSequentialGroup().addContainerGap().addGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.performReplaceCheckBox, -1, -1, Short.MAX_VALUE).addGroup(replacePanelLayout.createSequentialGroup().addComponent(this.replaceLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(replacePanelLayout.createSequentialGroup().addComponent(this.replaceTypeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceComboBox, 0, 283, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceMultilineButton)).addComponent(this.replaceAllMatchesCheckBox, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        replacePanelLayout.setVerticalGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(replacePanelLayout.createSequentialGroup().addComponent(this.performReplaceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceComboBox, -2, -1, -2).addComponent(this.replaceMultilineButton).addComponent(this.replaceTypeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceAllMatchesCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.replacePanel, "Center");
    }

    private void findMultilineButtonActionPerformed(ActionEvent evt) {
        SearchCondition condition;
        if (this.multilineEditorListener != null && (condition = this.multilineEditorListener.multilineEdit((SearchCondition)this.findComboBoxEditor.getItem())) != null) {
            this.findComboBoxEditorComponent.setItem(condition);
        }
    }

    private void searchTypeButtonActionPerformed(ActionEvent evt) {
        SearchCondition condition = (SearchCondition)this.findComboBoxEditor.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            condition.setSearchMode(SearchCondition.SearchMode.BINARY);
        } else {
            condition.setSearchMode(SearchCondition.SearchMode.TEXT);
        }
        this.findComboBoxEditor.setItem(condition);
        this.findComboBox.setEditor(this.findComboBoxEditor);
        this.updateFindStatus();
        this.findComboBox.repaint();
    }

    private void performReplaceCheckBoxActionPerformed(ActionEvent evt) {
        this.updateReplaceEnablement();
    }

    private void replaceTypeButtonActionPerformed(ActionEvent evt) {
        SearchCondition condition = (SearchCondition)this.replaceComboBoxEditor.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            condition.setSearchMode(SearchCondition.SearchMode.BINARY);
        } else {
            condition.setSearchMode(SearchCondition.SearchMode.TEXT);
        }
        this.replaceComboBoxEditor.setItem(condition);
        this.replaceComboBox.setEditor(this.replaceComboBoxEditor);
        this.updateReplaceStatus();
        this.replaceComboBox.repaint();
    }

    private void replaceMultilineButtonActionPerformed(ActionEvent evt) {
        SearchCondition condition;
        if (this.multilineEditorListener != null && (condition = this.multilineEditorListener.multilineEdit((SearchCondition)this.replaceComboBoxEditor.getItem())) != null) {
            this.replaceComboBoxEditorComponent.setItem(condition);
        }
    }

    private void updateFindStatus() {
        SearchCondition condition = (SearchCondition)this.findComboBoxEditor.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.searchTypeButton.setText("T");
            this.matchCaseCheckBox.setEnabled(true);
        } else {
            this.searchTypeButton.setText("B");
            this.matchCaseCheckBox.setEnabled(false);
        }
    }

    private void updateReplaceStatus() {
        SearchCondition condition = (SearchCondition)this.replaceComboBoxEditor.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.replaceTypeButton.setText("T");
        } else {
            this.replaceTypeButton.setText("B");
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new FindBinaryPanel());
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getFindText() {
        return (String)this.findComboBox.getEditor().getItem();
    }

    public boolean getShallReplace() {
        return this.performReplaceCheckBox.isSelected();
    }

    @Nonnull
    public SearchParameters getSearchParameters() {
        SearchParameters result = new SearchParameters();
        result.setCondition((SearchCondition)this.findComboBox.getEditor().getItem());
        result.setSearchFromCursor(this.searchFromCursorCheckBox.isSelected());
        result.setMatchCase(this.matchCaseCheckBox.isSelected());
        result.setMatchMode(SearchParameters.MatchMode.fromBoolean(this.multipleMatchesCheckBox.isSelected()));
        result.setSearchDirection(this.searchBackwardCheckBox.isSelected() ? SearchParameters.SearchDirection.BACKWARD : SearchParameters.SearchDirection.FORWARD);
        return result;
    }

    public void setSearchParameters(SearchParameters parameters) {
        this.searchFromCursorCheckBox.setSelected(parameters.isSearchFromCursor());
        this.matchCaseCheckBox.setSelected(parameters.isMatchCase());
        this.multipleMatchesCheckBox.setSelected(parameters.getMatchMode() == SearchParameters.MatchMode.MULTIPLE);
        this.searchBackwardCheckBox.setSelected(parameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD);
        this.findComboBoxEditorComponent.setItem(parameters.getCondition());
        this.findComboBox.setEditor(this.findComboBoxEditor);
        this.findComboBox.repaint();
        this.updateFindStatus();
    }

    @Nonnull
    public ReplaceParameters getReplaceParameters() {
        ReplaceParameters result = new ReplaceParameters();
        result.setCondition((SearchCondition)this.replaceComboBox.getEditor().getItem());
        result.setPerformReplace(this.performReplaceCheckBox.isSelected());
        result.setReplaceAll(this.replaceAllMatchesCheckBox.isSelected());
        return result;
    }

    public void setReplaceParameters(ReplaceParameters parameters) {
        this.performReplaceCheckBox.setSelected(parameters.isPerformReplace());
        this.replaceAllMatchesCheckBox.setSelected(parameters.isReplaceAll());
        this.replaceComboBoxEditorComponent.setItem(parameters.getCondition());
        this.replaceComboBox.setEditor(this.replaceComboBoxEditor);
        this.replaceComboBox.repaint();
        this.updateReplaceStatus();
        this.updateReplaceEnablement();
    }

    public void setSearchHistory(List<SearchCondition> searchHistory) {
        this.searchHistory = searchHistory;
        this.findComboBox.setModel(new SearchHistoryModel(searchHistory));
    }

    public void setReplaceHistory(List<SearchCondition> replaceHistory) {
        this.replaceHistory = replaceHistory;
        this.replaceComboBox.setModel(new SearchHistoryModel(replaceHistory));
    }

    public void setCodeAreaPopupMenuHandler(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler) {
        this.codeAreaPopupMenuHandler = codeAreaPopupMenuHandler;
        this.findComboBoxEditorComponent.setCodeAreaPopupMenuHandler(codeAreaPopupMenuHandler, "FindBinaryPanel");
    }

    public void detachMenu() {
        if (this.codeAreaPopupMenuHandler != null) {
            this.codeAreaPopupMenuHandler.dropPopupMenu(POPUP_MENU_POSTFIX);
        }
    }

    private void updateReplaceEnablement() {
        boolean replaceEnabled = this.performReplaceCheckBox.isSelected();
        this.replaceTypeButton.setEnabled(replaceEnabled);
        this.replaceComboBox.setEnabled(replaceEnabled);
        this.replaceMultilineButton.setEnabled(replaceEnabled);
        this.replaceAllMatchesCheckBox.setEnabled(replaceEnabled);
        this.replaceLabel.setEnabled(replaceEnabled);
    }

    public void setMultilineEditorListener(MultilineEditorListener multilineEditorListener) {
        this.multilineEditorListener = multilineEditorListener;
    }

    @ParametersAreNonnullByDefault
    public static interface MultilineEditorListener {
        @Nullable
        public SearchCondition multilineEdit(SearchCondition var1);
    }
}

