/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.ExtendedCodeAreaPainter;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.search.ReplaceParameters;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.bined.search.SearchHistoryModel;
import org.exbin.framework.bined.search.SearchParameters;
import org.exbin.framework.bined.search.gui.BinarySearchComboBoxPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinarySearchPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinarySearchPanel.class);
    private Control control = null;
    private final ExtCodeArea searchCodeArea = new ExtCodeArea();
    private PanelMode panelMode = PanelMode.REPLACE;
    private ComboBoxEditor findComboBoxEditor;
    private BinarySearchComboBoxPanel findComboBoxEditorComponent;
    private ComboBoxEditor replaceComboBoxEditor;
    private BinarySearchComboBoxPanel replaceComboBoxEditorComponent;
    private XBApplication application;
    private JButton closeButton;
    private JToolBar closeToolBar;
    private JComboBox<SearchCondition> findComboBox;
    private JLabel findLabel;
    private JPanel findPanel;
    private JToolBar findToolBar;
    private JButton findTypeButton;
    private JToolBar findTypeToolBar;
    private JLabel infoLabel;
    private JToggleButton matchCaseToggleButton;
    private JToggleButton multipleMatchesToggleButton;
    private JButton nextMatchButton;
    private JButton optionsButton;
    private JButton prevMatchButton;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JComboBox<SearchCondition> replaceComboBox;
    private JLabel replaceLabel;
    private JPanel replacePanel;
    private JToolBar replaceToolBar;
    private JButton replaceTypeButton;
    private JToolBar replaceTypeToolBar;
    private JToolBar.Separator separator1;
    private JSeparator topSeparator;

    public BinarySearchPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        ExtendedCodeAreaLayoutProfile layoutProfile = Objects.requireNonNull(this.searchCodeArea.getLayoutProfile());
        layoutProfile.setShowHeader(false);
        layoutProfile.setShowRowPosition(false);
        this.searchCodeArea.setLayoutProfile(layoutProfile);
        ExtendedCodeAreaThemeProfile themeProfile = this.searchCodeArea.getThemeProfile();
        themeProfile.setBackgroundPaintMode(ExtendedBackgroundPaintMode.PLAIN);
        this.searchCodeArea.setThemeProfile(themeProfile);
        this.searchCodeArea.setBorder(null);
        this.searchCodeArea.setLayoutProfile(layoutProfile);
        this.searchCodeArea.setRowWrapping(RowWrappingMode.WRAPPING);
        this.searchCodeArea.setWrappingBytesGroupSize(0);
        this.searchCodeArea.setVerticalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.searchCodeArea.setHorizontalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.searchCodeArea.setContentData((BinaryData)new ByteArrayEditableData(new byte[]{1, 2, 3}));
        KeyAdapter editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(@Nonnull KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    BinarySearchPanel.this.control.performEscape();
                }
                if (e.getKeyCode() == 10) {
                    BinarySearchPanel.this.control.performFind();
                }
            }
        };
        this.findComboBoxEditorComponent = new BinarySearchComboBoxPanel();
        this.findComboBox.setRenderer(new ListCellRenderer<SearchCondition>(){
            private final JPanel panel = new JPanel();
            private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

            @Override
            @Nonnull
            public Component getListCellRendererComponent(JList<? extends SearchCondition> list, @Nullable SearchCondition value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return this.panel;
                }
                if (value.getSearchMode() == SearchCondition.SearchMode.TEXT) {
                    return this.listCellRenderer.getListCellRendererComponent(list, value.getSearchText(), index, isSelected, cellHasFocus);
                }
                BinarySearchPanel.this.searchCodeArea.setContentData(value.getBinaryData());
                BinarySearchPanel.this.searchCodeArea.setPreferredSize(new Dimension(200, 20));
                Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
                ExtendedCodeAreaPainter painter = (ExtendedCodeAreaPainter)BinarySearchPanel.this.searchCodeArea.getPainter();
                ExtendedCodeAreaColorProfile colorsProfile = (ExtendedCodeAreaColorProfile)painter.getColorsProfile();
                colorsProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND, backgroundColor);
                return BinarySearchPanel.this.searchCodeArea;
            }
        });
        this.findComboBoxEditor = new ComboBoxEditor(){

            @Override
            public Component getEditorComponent() {
                return BinarySearchPanel.this.findComboBoxEditorComponent;
            }

            @Override
            public void setItem(@Nullable Object item) {
                SearchCondition currentItem;
                SearchCondition condition;
                if (item == null || item instanceof String) {
                    condition = new SearchCondition();
                    condition.setSearchMode(SearchCondition.SearchMode.TEXT);
                    if (item != null) {
                        condition.setSearchText((String)item);
                    }
                } else {
                    condition = (SearchCondition)item;
                }
                if (item != (currentItem = BinarySearchPanel.this.findComboBoxEditorComponent.getItem())) {
                    BinarySearchPanel.this.findComboBoxEditorComponent.setItem(condition);
                    BinarySearchPanel.this.updateFindStatus();
                }
            }

            @Override
            @Nonnull
            public Object getItem() {
                return BinarySearchPanel.this.findComboBoxEditorComponent.getItem();
            }

            @Override
            public void selectAll() {
                BinarySearchPanel.this.findComboBoxEditorComponent.selectAll();
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        };
        this.findComboBox.setEditor(this.findComboBoxEditor);
        this.findComboBoxEditorComponent.setValueChangedListener(this::comboBoxValueChanged);
        this.findComboBoxEditorComponent.addValueKeyListener(editorKeyListener);
        this.replaceComboBoxEditorComponent = new BinarySearchComboBoxPanel();
        this.replaceComboBox.setRenderer(new ListCellRenderer<SearchCondition>(){
            private final JPanel panel = new JPanel();
            private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

            @Override
            @Nonnull
            public Component getListCellRendererComponent(@Nonnull JList<? extends SearchCondition> list, @Nullable SearchCondition value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return this.panel;
                }
                if (value.getSearchMode() == SearchCondition.SearchMode.TEXT) {
                    return this.listCellRenderer.getListCellRendererComponent(list, value.getSearchText(), index, isSelected, cellHasFocus);
                }
                BinarySearchPanel.this.searchCodeArea.setContentData(value.getBinaryData());
                BinarySearchPanel.this.searchCodeArea.setPreferredSize(new Dimension(200, 20));
                Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
                ExtendedCodeAreaPainter painter = (ExtendedCodeAreaPainter)BinarySearchPanel.this.searchCodeArea.getPainter();
                ExtendedCodeAreaColorProfile colorsProfile = (ExtendedCodeAreaColorProfile)painter.getColorsProfile();
                colorsProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND, backgroundColor);
                return BinarySearchPanel.this.searchCodeArea;
            }
        });
        this.replaceComboBoxEditor = new ComboBoxEditor(){

            @Override
            @Nonnull
            public Component getEditorComponent() {
                return BinarySearchPanel.this.replaceComboBoxEditorComponent;
            }

            @Override
            public void setItem(@Nullable Object item) {
                SearchCondition currentItem;
                SearchCondition condition;
                if (item == null || item instanceof String) {
                    condition = new SearchCondition();
                    condition.setSearchMode(SearchCondition.SearchMode.TEXT);
                    if (item != null) {
                        condition.setSearchText((String)item);
                    }
                } else {
                    condition = (SearchCondition)item;
                }
                if (item != (currentItem = BinarySearchPanel.this.replaceComboBoxEditorComponent.getItem())) {
                    BinarySearchPanel.this.replaceComboBoxEditorComponent.setItem(condition);
                    BinarySearchPanel.this.updateReplaceStatus();
                }
            }

            @Override
            @Nonnull
            public Object getItem() {
                return BinarySearchPanel.this.replaceComboBoxEditorComponent.getItem();
            }

            @Override
            public void selectAll() {
                BinarySearchPanel.this.replaceComboBoxEditorComponent.selectAll();
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        };
        this.replaceComboBox.setEditor(this.replaceComboBoxEditor);
        this.replaceComboBoxEditorComponent.addValueKeyListener(editorKeyListener);
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public void setInfoLabel(String text) {
        this.infoLabel.setText(text);
    }

    @Nonnull
    public SearchParameters getSearchParameters() {
        long startPosition;
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setMatchCase(this.matchCaseToggleButton.isSelected());
        searchParameters.setMatchMode(SearchParameters.MatchMode.fromBoolean(this.multipleMatchesToggleButton.isSelected()));
        SearchParameters.SearchDirection searchDirection = this.control.getSearchDirection();
        searchParameters.setSearchDirection(searchDirection);
        if (searchParameters.isSearchFromCursor()) {
            startPosition = this.searchCodeArea.getCaretPosition().getDataPosition();
        } else {
            switch (searchDirection) {
                case FORWARD: {
                    startPosition = 0L;
                    break;
                }
                case BACKWARD: {
                    startPosition = this.searchCodeArea.getDataSize() - 1L;
                    break;
                }
                default: {
                    throw CodeAreaUtils.getInvalidTypeException((Enum)searchDirection);
                }
            }
        }
        searchParameters.setStartPosition(startPosition);
        searchParameters.setCondition(new SearchCondition(this.findComboBoxEditorComponent.getItem()));
        return searchParameters;
    }

    @Nonnull
    public ReplaceParameters getReplaceParameters() {
        ReplaceParameters replaceParameters = new ReplaceParameters();
        replaceParameters.setCondition(new SearchCondition(this.replaceComboBoxEditorComponent.getItem()));
        return replaceParameters;
    }

    public void updateMatchStatus(boolean hasMatches, boolean prevMatchAvailable, boolean nextMatchAvailable) {
        this.prevMatchButton.setEnabled(prevMatchAvailable);
        this.nextMatchButton.setEnabled(nextMatchAvailable);
        this.replaceButton.setEnabled(hasMatches);
        this.replaceAllButton.setEnabled(hasMatches);
    }

    public void setSearchHistory(List<SearchCondition> history) {
        this.findComboBox.setModel(new SearchHistoryModel(history));
    }

    public void setReplaceHistory(List<SearchCondition> history) {
        this.replaceComboBox.setModel(new SearchHistoryModel(history));
    }

    public void switchPanelMode(PanelMode panelMode) {
        if (this.panelMode != panelMode) {
            this.panelMode = panelMode;
            if (panelMode == PanelMode.REPLACE) {
                this.add((Component)this.replacePanel, "South");
            } else {
                this.remove(this.replacePanel);
            }
            this.revalidate();
        }
    }

    private void initComponents() {
        this.topSeparator = new JSeparator();
        this.findPanel = new JPanel();
        this.findLabel = new JLabel();
        this.findTypeToolBar = new JToolBar();
        this.findTypeButton = new JButton();
        this.findComboBox = new JComboBox();
        this.findToolBar = new JToolBar();
        this.prevMatchButton = new JButton();
        this.nextMatchButton = new JButton();
        this.matchCaseToggleButton = new JToggleButton();
        this.multipleMatchesToggleButton = new JToggleButton();
        this.separator1 = new JToolBar.Separator();
        this.optionsButton = new JButton();
        this.infoLabel = new JLabel();
        this.closeToolBar = new JToolBar();
        this.closeButton = new JButton();
        this.replacePanel = new JPanel();
        this.replaceLabel = new JLabel();
        this.replaceTypeToolBar = new JToolBar();
        this.replaceTypeButton = new JButton();
        this.replaceComboBox = new JComboBox();
        this.replaceToolBar = new JToolBar();
        this.replaceButton = new JButton();
        this.replaceAllButton = new JButton();
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.topSeparator.setName("topSeparator");
        this.add((Component)this.topSeparator, "North");
        this.findPanel.setName("findPanel");
        this.findLabel.setText(this.resourceBundle.getString("findLabel.text"));
        this.findLabel.setName("findLabel");
        this.findTypeToolBar.setBorder(null);
        this.findTypeToolBar.setRollover(true);
        this.findTypeToolBar.setFocusable(false);
        this.findTypeToolBar.setName("findTypeToolBar");
        this.findTypeButton.setText(this.resourceBundle.getString("inputType.text"));
        this.findTypeButton.setToolTipText(this.resourceBundle.getString("findTypeButton.toolTipText"));
        this.findTypeButton.setFocusable(false);
        this.findTypeButton.setMaximumSize(new Dimension(27, 27));
        this.findTypeButton.setMinimumSize(new Dimension(27, 27));
        this.findTypeButton.setName("findTypeButton");
        this.findTypeButton.setPreferredSize(new Dimension(27, 27));
        this.findTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.findTypeButtonActionPerformed(evt);
            }
        });
        this.findTypeToolBar.add(this.findTypeButton);
        this.findComboBox.setEditable(true);
        this.findComboBox.setName("findComboBox");
        this.findToolBar.setBorder(null);
        this.findToolBar.setRollover(true);
        this.findToolBar.setFocusable(false);
        this.findToolBar.setName("findToolBar");
        this.prevMatchButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/bined/search/resources/icons/open_icon_library/icons/png/16x16/actions/arrow-left.png")));
        this.prevMatchButton.setToolTipText(this.resourceBundle.getString("prevMatchButton.toolTipText"));
        this.prevMatchButton.setEnabled(false);
        this.prevMatchButton.setFocusable(false);
        this.prevMatchButton.setHorizontalTextPosition(0);
        this.prevMatchButton.setName("prevMatchButton");
        this.prevMatchButton.setVerticalTextPosition(3);
        this.prevMatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.prevMatchButtonActionPerformed(evt);
            }
        });
        this.findToolBar.add(this.prevMatchButton);
        this.nextMatchButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/bined/search/resources/icons/open_icon_library/icons/png/16x16/actions/arrow-right.png")));
        this.nextMatchButton.setToolTipText(this.resourceBundle.getString("nextMatchButton.toolTipText"));
        this.nextMatchButton.setEnabled(false);
        this.nextMatchButton.setFocusable(false);
        this.nextMatchButton.setHorizontalTextPosition(0);
        this.nextMatchButton.setName("nextMatchButton");
        this.nextMatchButton.setVerticalTextPosition(3);
        this.nextMatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.nextMatchButtonActionPerformed(evt);
            }
        });
        this.findToolBar.add(this.nextMatchButton);
        this.matchCaseToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/bined/search/resources/icons/case_sensitive.gif")));
        this.matchCaseToggleButton.setToolTipText(this.resourceBundle.getString("matchCaseToggleButton.toolTipText"));
        this.matchCaseToggleButton.setFocusable(false);
        this.matchCaseToggleButton.setHorizontalTextPosition(0);
        this.matchCaseToggleButton.setName("matchCaseToggleButton");
        this.matchCaseToggleButton.setVerticalTextPosition(3);
        this.matchCaseToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.matchCaseToggleButtonActionPerformed(evt);
            }
        });
        this.findToolBar.add(this.matchCaseToggleButton);
        this.multipleMatchesToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/bined/search/resources/icons/mark_occurrences.png")));
        this.multipleMatchesToggleButton.setSelected(true);
        this.multipleMatchesToggleButton.setToolTipText(this.resourceBundle.getString("multipleMatchesToggleButton.toolTipText"));
        this.multipleMatchesToggleButton.setFocusable(false);
        this.multipleMatchesToggleButton.setHorizontalTextPosition(0);
        this.multipleMatchesToggleButton.setName("multipleMatchesToggleButton");
        this.multipleMatchesToggleButton.setVerticalTextPosition(3);
        this.multipleMatchesToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.multipleMatchesToggleButtonActionPerformed(evt);
            }
        });
        this.findToolBar.add(this.multipleMatchesToggleButton);
        this.separator1.setName("separator1");
        this.findToolBar.add(this.separator1);
        this.optionsButton.setText(this.resourceBundle.getString("optionsButton.text"));
        this.optionsButton.setFocusable(false);
        this.optionsButton.setHorizontalTextPosition(0);
        this.optionsButton.setName("optionsButton");
        this.optionsButton.setVerticalTextPosition(3);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.optionsButtonActionPerformed(evt);
            }
        });
        this.findToolBar.add(this.optionsButton);
        this.infoLabel.setEnabled(false);
        this.infoLabel.setName("infoLabel");
        this.closeToolBar.setBorder(null);
        this.closeToolBar.setRollover(true);
        this.closeToolBar.setName("closeToolBar");
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/bined/search/resources/icons/open_icon_library/icons/png/16x16/actions/dialog-cancel-3.png")));
        this.closeButton.setToolTipText(this.resourceBundle.getString("closeButton.toolTipText"));
        this.closeButton.setFocusable(false);
        this.closeButton.setHorizontalTextPosition(0);
        this.closeButton.setName("closeButton");
        this.closeButton.setVerticalTextPosition(3);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.closeButtonActionPerformed(evt);
            }
        });
        this.closeToolBar.add(this.closeButton);
        GroupLayout findPanelLayout = new GroupLayout(this.findPanel);
        this.findPanel.setLayout(findPanelLayout);
        findPanelLayout.setHorizontalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, findPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.findLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findTypeToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findComboBox, 0, 519, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeToolBar, -2, -1, -2)));
        findPanelLayout.setVerticalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.infoLabel, -1, -1, Short.MAX_VALUE).addComponent(this.findToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.findTypeToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.findLabel, -1, -1, Short.MAX_VALUE).addComponent(this.findComboBox));
        this.add((Component)this.findPanel, "Center");
        this.replacePanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.replacePanel.setName("replacePanel");
        this.replacePanel.setPreferredSize(new Dimension(1015, 28));
        this.replaceLabel.setText(this.resourceBundle.getString("replaceLabel.text"));
        this.replaceLabel.setName("replaceLabel");
        this.replaceTypeToolBar.setBorder(null);
        this.replaceTypeToolBar.setRollover(true);
        this.replaceTypeToolBar.setFocusable(false);
        this.replaceTypeToolBar.setName("replaceTypeToolBar");
        this.replaceTypeButton.setText(this.resourceBundle.getString("inputType.text"));
        this.replaceTypeButton.setToolTipText(this.resourceBundle.getString("replaceTypeButton.toolTipText"));
        this.replaceTypeButton.setDefaultCapable(false);
        this.replaceTypeButton.setFocusable(false);
        this.replaceTypeButton.setHorizontalTextPosition(0);
        this.replaceTypeButton.setMaximumSize(new Dimension(27, 27));
        this.replaceTypeButton.setMinimumSize(new Dimension(27, 27));
        this.replaceTypeButton.setName("replaceTypeButton");
        this.replaceTypeButton.setPreferredSize(new Dimension(27, 27));
        this.replaceTypeButton.setVerticalTextPosition(3);
        this.replaceTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.replaceTypeButtonActionPerformed(evt);
            }
        });
        this.replaceTypeToolBar.add(this.replaceTypeButton);
        this.replaceComboBox.setEditable(true);
        this.replaceComboBox.setName("replaceComboBox");
        this.replaceToolBar.setBorder(null);
        this.replaceToolBar.setRollover(true);
        this.replaceToolBar.setFocusable(false);
        this.replaceToolBar.setName("replaceToolBar");
        this.replaceButton.setText(this.resourceBundle.getString("replaceButton.text"));
        this.replaceButton.setEnabled(false);
        this.replaceButton.setFocusable(false);
        this.replaceButton.setHorizontalTextPosition(0);
        this.replaceButton.setName("replaceButton");
        this.replaceButton.setVerticalTextPosition(3);
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.replaceButtonActionPerformed(evt);
            }
        });
        this.replaceToolBar.add(this.replaceButton);
        this.replaceAllButton.setText(this.resourceBundle.getString("replaceAllButton.text"));
        this.replaceAllButton.setEnabled(false);
        this.replaceAllButton.setFocusable(false);
        this.replaceAllButton.setHorizontalTextPosition(0);
        this.replaceAllButton.setName("replaceAllButton");
        this.replaceAllButton.setVerticalTextPosition(3);
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinarySearchPanel.this.replaceAllButtonActionPerformed(evt);
            }
        });
        this.replaceToolBar.add(this.replaceAllButton);
        GroupLayout replacePanelLayout = new GroupLayout(this.replacePanel);
        this.replacePanel.setLayout(replacePanelLayout);
        replacePanelLayout.setHorizontalGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(replacePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.replaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceTypeToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceComboBox, 0, 734, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.replaceToolBar, -2, -1, -2).addContainerGap()));
        replacePanelLayout.setVerticalGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.replaceTypeToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.replaceComboBox).addComponent(this.replaceLabel, -1, -1, Short.MAX_VALUE).addComponent(this.replaceToolBar, -1, -1, Short.MAX_VALUE));
        this.add((Component)this.replacePanel, "South");
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        this.control.searchOptions();
    }

    private void prevMatchButtonActionPerformed(ActionEvent evt) {
        this.control.prevMatch();
    }

    private void nextMatchButtonActionPerformed(ActionEvent evt) {
        this.control.nextMatch();
    }

    private void multipleMatchesToggleButtonActionPerformed(ActionEvent evt) {
        this.control.notifySearchChanged();
    }

    private void matchCaseToggleButtonActionPerformed(ActionEvent evt) {
        this.control.notifySearchChanged();
    }

    private void findTypeButtonActionPerformed(ActionEvent evt) {
        SearchCondition condition = this.findComboBoxEditorComponent.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            condition.setSearchMode(SearchCondition.SearchMode.BINARY);
        } else {
            condition.setSearchMode(SearchCondition.SearchMode.TEXT);
        }
        this.findComboBoxEditorComponent.setItem(condition);
        this.findComboBox.setEditor(this.findComboBoxEditor);
        this.findComboBox.invalidate();
        this.findComboBox.repaint();
        this.updateFindStatus();
        this.control.notifySearchChanged();
    }

    public void updateFindStatus() {
        SearchCondition condition = this.findComboBoxEditorComponent.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.findTypeButton.setText(this.resourceBundle.getString("inputType.text"));
            this.matchCaseToggleButton.setEnabled(true);
        } else {
            this.findTypeButton.setText(this.resourceBundle.getString("inputType.binary"));
            this.matchCaseToggleButton.setEnabled(false);
        }
    }

    private void updateReplaceStatus() {
        SearchCondition condition = this.replaceComboBoxEditorComponent.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.replaceTypeButton.setText(this.resourceBundle.getString("inputType.text"));
        } else {
            this.replaceTypeButton.setText(this.resourceBundle.getString("inputType.binary"));
        }
    }

    public void clearSearch() {
        this.findComboBoxEditorComponent.clear();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.control.close();
    }

    private void replaceTypeButtonActionPerformed(ActionEvent evt) {
        SearchCondition condition = this.replaceComboBoxEditorComponent.getItem();
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            condition.setSearchMode(SearchCondition.SearchMode.BINARY);
        } else {
            condition.setSearchMode(SearchCondition.SearchMode.TEXT);
        }
        this.replaceComboBoxEditorComponent.setItem(condition);
        this.replaceComboBox.setEditor(this.replaceComboBoxEditor);
        this.replaceComboBox.invalidate();
        this.replaceComboBox.repaint();
        this.updateReplaceStatus();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        this.control.performReplace();
    }

    private void replaceAllButtonActionPerformed(ActionEvent evt) {
        this.control.performReplaceAll();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinarySearchPanel());
    }

    private void comboBoxValueChanged() {
        this.control.notifySearchChanging();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void requestSearchFocus() {
        this.findComboBox.requestFocus();
        this.findComboBoxEditorComponent.requestFocus();
    }

    public void setCodeAreaPopupMenuHandler(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler) {
        this.findComboBoxEditorComponent.setCodeAreaPopupMenuHandler(codeAreaPopupMenuHandler, "");
    }

    public void updateSearchHistory(SearchCondition condition) {
        this.findComboBoxEditorComponent.exclusiveUpdate(() -> ((SearchHistoryModel)this.findComboBox.getModel()).addSearchCondition(condition));
    }

    public static enum PanelMode {
        FIND,
        REPLACE;

    }

    public static interface Control {
        public void prevMatch();

        public void nextMatch();

        public void performEscape();

        public void performFind();

        public void performReplace();

        public void performReplaceAll();

        public void notifySearchChanged();

        public void notifySearchChanging();

        @Nonnull
        public SearchParameters.SearchDirection getSearchDirection();

        public void searchOptions();

        public void close();
    }
}

