/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.search.BinEdComponentSearch;
import org.exbin.framework.bined.search.gui.BinarySearchPanel;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class FindReplaceActions
implements FileDependentAction {
    public static final String EDIT_FIND_ACTION_ID = "editFindAction";
    public static final String EDIT_FIND_AGAIN_ACTION_ID = "editFindAgainAction";
    public static final String EDIT_REPLACE_ACTION_ID = "editReplaceAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action editFindAction;
    private Action editFindAgainAction;
    private Action editReplaceAction;
    private final List<FindAgainListener> findAgainListeners = new ArrayList<FindAgainListener>();

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    public void updateForActiveFile() {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (this.editFindAction != null) {
            this.editFindAction.setEnabled(activeFile.isPresent());
        }
        if (this.editFindAgainAction != null) {
            this.editFindAgainAction.setEnabled(activeFile.isPresent());
        }
        if (this.editReplaceAction != null) {
            this.editReplaceAction.setEnabled(activeFile.isPresent());
        }
    }

    @Nonnull
    public Action getEditFindAction() {
        if (this.editFindAction == null) {
            this.editFindAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = FindReplaceActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    BinEdComponentPanel activePanel = ((BinEdFileHandler)activeFile.get()).getComponent();
                    BinEdComponentSearch componentExtension = (BinEdComponentSearch)activePanel.getComponentExtension(BinEdComponentSearch.class);
                    componentExtension.showSearchPanel(BinarySearchPanel.PanelMode.FIND);
                }
            };
            ActionUtils.setupAction((Action)this.editFindAction, (ResourceBundle)this.resourceBundle, (String)EDIT_FIND_ACTION_ID);
            this.editFindAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, ActionUtils.getMetaMask()));
            this.editFindAction.putValue("dialogMode", true);
            this.editFindAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

                public boolean shouldCreate(String menuId) {
                    BinedModule binedModule = (BinedModule)FindReplaceActions.this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
                    BinedModule.PopupMenuVariant menuVariant = binedModule.getPopupMenuVariant();
                    BasicCodeAreaZone positionZone = binedModule.getPopupMenuPositionZone();
                    return menuVariant == BinedModule.PopupMenuVariant.EDITOR && positionZone != BasicCodeAreaZone.TOP_LEFT_CORNER && positionZone != BasicCodeAreaZone.HEADER && positionZone != BasicCodeAreaZone.ROW_POSITIONS;
                }

                public void onCreate(JMenuItem menuItem, String menuId) {
                }
            });
        }
        return this.editFindAction;
    }

    @Nonnull
    public Action getEditFindAgainAction() {
        if (this.editFindAgainAction == null) {
            this.editFindAgainAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = FindReplaceActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    BinEdComponentPanel activePanel = ((BinEdFileHandler)activeFile.get()).getComponent();
                    BinEdComponentSearch componentExtension = (BinEdComponentSearch)activePanel.getComponentExtension(BinEdComponentSearch.class);
                    componentExtension.performFindAgain();
                    for (FindAgainListener findAgainListener : FindReplaceActions.this.findAgainListeners) {
                        findAgainListener.performed();
                    }
                }
            };
            ActionUtils.setupAction((Action)this.editFindAgainAction, (ResourceBundle)this.resourceBundle, (String)EDIT_FIND_AGAIN_ACTION_ID);
            this.editFindAgainAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
            this.editFindAgainAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

                public boolean shouldCreate(String menuId) {
                    BinedModule binedModule = (BinedModule)FindReplaceActions.this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
                    BinedModule.PopupMenuVariant menuVariant = binedModule.getPopupMenuVariant();
                    BasicCodeAreaZone positionZone = binedModule.getPopupMenuPositionZone();
                    return menuVariant == BinedModule.PopupMenuVariant.EDITOR && positionZone != BasicCodeAreaZone.TOP_LEFT_CORNER && positionZone != BasicCodeAreaZone.HEADER && positionZone != BasicCodeAreaZone.ROW_POSITIONS;
                }

                public void onCreate(JMenuItem menuItem, String menuId) {
                }
            });
        }
        return this.editFindAgainAction;
    }

    @Nonnull
    public Action getEditReplaceAction() {
        if (this.editReplaceAction == null) {
            this.editReplaceAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = FindReplaceActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    BinEdComponentPanel activePanel = ((BinEdFileHandler)activeFile.get()).getComponent();
                    BinEdComponentSearch componentExtension = (BinEdComponentSearch)activePanel.getComponentExtension(BinEdComponentSearch.class);
                    componentExtension.showSearchPanel(BinarySearchPanel.PanelMode.REPLACE);
                }
            };
            ActionUtils.setupAction((Action)this.editReplaceAction, (ResourceBundle)this.resourceBundle, (String)EDIT_REPLACE_ACTION_ID);
            this.editReplaceAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, ActionUtils.getMetaMask()));
            this.editReplaceAction.putValue("dialogMode", true);
            this.editReplaceAction.putValue("menu_creation", new ActionUtils.MenuCreation(){

                public boolean shouldCreate(String menuId) {
                    BinedModule binedModule = (BinedModule)FindReplaceActions.this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
                    BinedModule.PopupMenuVariant menuVariant = binedModule.getPopupMenuVariant();
                    BasicCodeAreaZone positionZone = binedModule.getPopupMenuPositionZone();
                    return menuVariant == BinedModule.PopupMenuVariant.EDITOR && positionZone != BasicCodeAreaZone.TOP_LEFT_CORNER && positionZone != BasicCodeAreaZone.HEADER && positionZone != BasicCodeAreaZone.ROW_POSITIONS;
                }

                public void onCreate(JMenuItem menuItem, String menuId) {
                }
            });
        }
        return this.editReplaceAction;
    }

    public void addFindAgainListener(FindAgainListener findAgainListener) {
        this.findAgainListeners.add(findAgainListener);
    }

    public void removeFindAgainListener(FindAgainListener findAgainListener) {
        this.findAgainListeners.remove(findAgainListener);
    }

    public static interface FindAgainListener {
        public void performed();
    }
}

