/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.plugin;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventProducer;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.serial.sequence.XBStringListConsistSerializable;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.type.XBString;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.plugin.XBModule;
import org.exbin.xbup.plugin.XBModuleRecord;

@ParametersAreNonnullByDefault
public class XBModuleInfo
implements XBPSequenceSerializable,
XBModuleRecord {
    static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 3L, 1L, 2L, 0L, 0L};
    private String moduleId;
    private XBModule module;
    private ClassLoader classLoader;
    private String name;
    private String description;
    private final List<String> optionalModuleIds = new ArrayList<String>();
    private final List<String> dependencyModuleIds = new ArrayList<String>();

    public XBModuleInfo() {
    }

    private XBModuleInfo(String moduleId) {
        this.moduleId = moduleId;
    }

    public XBModuleInfo(String moduleId, XBModule module, ClassLoader classLoader) {
        this.moduleId = moduleId;
        this.module = module;
        this.classLoader = classLoader;
    }

    public static void main(String[] params) {
        XBModuleInfo module = new XBModuleInfo("org.exbin.framework.gui.help.GuiHelpModule");
        module.setName("XBUP Help Support Module");
        module.setDescription("Module supporting basic help support");
        String[] depedency = new String[]{};
        module.addDependencyModuleIds(Arrays.asList(depedency));
        try {
            XBEventWriter eventWriter = new XBEventWriter((OutputStream)new FileOutputStream("module.xb"));
            XBPListenerSerialHandler serial = new XBPListenerSerialHandler((XBInput)new XBTToXBEventTypeRemover((XBEventListener)eventWriter));
            serial.process((XBSerializable)module);
        }
        catch (IOException ex) {
            Logger.getLogger(XBModuleInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    @Nullable
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    @Nonnull
    public XBModule getModule() {
        if (this.module == null) {
            throw new IllegalStateException("Attempt to use uninitialized module: " + this.moduleId);
        }
        return this.module;
    }

    public void setModule(XBModule module) {
        this.module = module;
    }

    @Nonnull
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("Attempt to use uninitialized module: " + this.moduleId);
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Nonnull
    public List<String> getOptionalModuleIds() {
        return this.optionalModuleIds;
    }

    public void addOptionalModuleIds(List<String> optionalModuleIds) {
        this.optionalModuleIds.addAll(optionalModuleIds);
    }

    @Override
    @Nonnull
    public List<String> getDependencyModuleIds() {
        return this.dependencyModuleIds;
    }

    public void addDependencyModuleIds(List<String> dependencyModuleIds) {
        this.dependencyModuleIds.addAll(dependencyModuleIds);
    }

    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType();
        XBStringListConsistSerializable dependencies = new XBStringListConsistSerializable(this.dependencyModuleIds);
        XBStringListConsistSerializable optionals = new XBStringListConsistSerializable(this.optionalModuleIds);
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            if (serial.pullIfEmptyBlock()) {
                this.moduleId = null;
            } else {
                XBString moduleIdString = new XBString();
                serial.consist((XBSerializable)moduleIdString);
                this.moduleId = moduleIdString.getValue();
            }
            if (serial.pullIfEmptyBlock()) {
                this.name = null;
            } else {
                XBString nameString = new XBString();
                serial.consist((XBSerializable)nameString);
                this.name = nameString.getValue();
            }
            if (serial.pullIfEmptyBlock()) {
                this.description = null;
            } else {
                XBString descriptionString = new XBString();
                serial.consist((XBSerializable)descriptionString);
                this.description = descriptionString.getValue();
            }
        } else {
            serial.consist((XBSerializable)new XBString(this.moduleId));
            serial.consist((XBSerializable)new XBString(this.name));
            serial.consist((XBSerializable)new XBString(this.description));
        }
        serial.listConsist((XBSerializable)dependencies);
        serial.listConsist((XBSerializable)optionals);
        serial.end();
    }

    @ParametersAreNonnullByDefault
    private static class XBTToXBEventTypeRemover
    implements XBTEventListener,
    XBEventProducer {
        private XBEventListener eventListener;
        private boolean blockIdSent = false;

        public XBTToXBEventTypeRemover(XBEventListener eventListener) {
            this.eventListener = eventListener;
        }

        public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
            switch (token.getTokenType()) {
                case BEGIN: {
                    this.eventListener.putXBToken((XBToken)XBBeginToken.create((XBBlockTerminationMode)((XBTBeginToken)token).getTerminationMode()));
                    this.blockIdSent = false;
                    break;
                }
                case TYPE: {
                    this.eventListener.putXBToken((XBToken)XBAttributeToken.create((XBAttribute)new UBNat32()));
                    break;
                }
                case ATTRIBUTE: {
                    if (!this.blockIdSent) {
                        this.eventListener.putXBToken((XBToken)XBAttributeToken.create((XBAttribute)new UBNat32()));
                        this.blockIdSent = true;
                    }
                    this.eventListener.putXBToken((XBToken)XBAttributeToken.create((XBAttribute)((XBTAttributeToken)token).getAttribute()));
                    break;
                }
                case DATA: {
                    this.eventListener.putXBToken((XBToken)XBDataToken.create((InputStream)((XBTDataToken)token).getData()));
                    break;
                }
                case END: {
                    this.eventListener.putXBToken((XBToken)XBEndToken.create());
                }
            }
        }

        public void attachXBEventListener(XBEventListener eventListener) {
            this.eventListener = eventListener;
        }
    }
}

