/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.frame;

import com.formdev.flatlaf.extras.FlatDesktop;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.ApplicationExitHandler;
import org.exbin.framework.frame.StatusBarHandler;
import org.exbin.framework.frame.XBApplicationFrame;
import org.exbin.framework.frame.action.FrameActions;
import org.exbin.framework.frame.api.ApplicationExitListener;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowPosition;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.handler.OkCancelService;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class FrameModule
implements FrameModuleApi {
    public static final String FILE_EXIT_GROUP_ID = MODULE_ID + ".exit";
    public static final String VIEW_BARS_GROUP_ID = MODULE_ID + ".view";
    public static final String PREFERENCES_FRAME_PREFIX = "mainFrame.";
    public static final String RESOURCES_DIALOG_TITLE = "dialog.title";
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private XBApplicationFrame frame;
    private ApplicationExitHandler exitHandler = null;
    private StatusBarHandler statusBarHandler = null;
    private FrameActions frameActions;

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(FrameModule.class);
        }
        return this.resourceBundle;
    }

    private void ensureSetup() {
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    public void createMainMenu() {
        this.ensureSetup();
        this.initMainMenu();
        this.initMainToolBar();
    }

    private void initMainMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(MAIN_MENU_ID, MODULE_ID);
        actionModule.registerMenu(FILE_MENU_ID, MODULE_ID);
        actionModule.registerMenu(EDIT_MENU_ID, MODULE_ID);
        actionModule.registerMenu(VIEW_MENU_ID, MODULE_ID);
        actionModule.registerMenu(TOOLS_MENU_ID, MODULE_ID);
        actionModule.registerMenu(OPTIONS_MENU_ID, MODULE_ID);
        actionModule.registerMenu(HELP_MENU_ID, MODULE_ID);
        actionModule.registerMenuItem(MAIN_MENU_ID, MODULE_ID, FILE_MENU_ID, this.resourceBundle.getString("fileMenu.text"), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(MAIN_MENU_ID, MODULE_ID, EDIT_MENU_ID, this.resourceBundle.getString("editMenu.text"), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(MAIN_MENU_ID, MODULE_ID, VIEW_MENU_ID, this.resourceBundle.getString("viewMenu.text"), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(MAIN_MENU_ID, MODULE_ID, TOOLS_MENU_ID, this.resourceBundle.getString("toolsMenu.text"), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(MAIN_MENU_ID, MODULE_ID, OPTIONS_MENU_ID, this.resourceBundle.getString("optionsMenu.text"), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(MAIN_MENU_ID, MODULE_ID, HELP_MENU_ID, this.resourceBundle.getString("helpMenu.text"), new MenuPosition(PositionMode.TOP));
    }

    private void initMainToolBar() {
        ActionModuleApi menuModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        menuModule.registerToolBar(MAIN_TOOL_BAR_ID, MODULE_ID);
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public Frame getFrame() {
        return this.getFrameHandler().getFrame();
    }

    public void notifyFrameUpdated() {
        if (this.frameActions != null) {
            this.frameActions.notifyFrameUpdated();
        }
    }

    public void loadFramePosition() {
        this.getFrameHandler();
        WindowPosition framePosition = new WindowPosition();
        if (framePosition.preferencesExists(this.application.getAppPreferences(), PREFERENCES_FRAME_PREFIX)) {
            framePosition.loadFromPreferences(this.application.getAppPreferences(), PREFERENCES_FRAME_PREFIX);
            WindowUtils.setWindowPosition((Window)this.frame, (WindowPosition)framePosition);
        }
    }

    public void saveFramePosition() {
        WindowPosition windowPosition = WindowUtils.getWindowPosition((Window)this.frame);
        windowPosition.saveToPreferences(this.application.getAppPreferences(), PREFERENCES_FRAME_PREFIX);
    }

    @Nonnull
    public Action getExitAction() {
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameModule.this.exitHandler != null) {
                    FrameModule.this.exitHandler.executeExit(FrameModule.this.getFrameHandler());
                } else {
                    System.exit(0);
                }
            }
        };
        ActionUtils.setupAction((Action)exitAction, (ResourceBundle)this.resourceBundle, (String)"exitAction");
        exitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 512));
        return exitAction;
    }

    public void registerExitAction() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        String appClosingActionsGroup = "ApplicationClosingActionsGroup";
        boolean exitActionRegistered = false;
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            FlatDesktop.setQuitHandler(response -> {
                if (this.exitHandler != null) {
                    boolean canExit = this.exitHandler.canExit(this.getFrameHandler());
                    if (canExit) {
                        response.performQuit();
                    } else {
                        response.cancelQuit();
                    }
                } else {
                    response.performQuit();
                }
            });
            exitActionRegistered = true;
        }
        actionModule.registerMenuGroup(FrameModuleApi.FILE_MENU_ID, new MenuGroup(appClosingActionsGroup, new MenuPosition(PositionMode.BOTTOM_LAST), exitActionRegistered ? SeparationMode.NONE : SeparationMode.ABOVE));
        if (!exitActionRegistered) {
            actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, this.getExitAction(), new MenuPosition(appClosingActionsGroup));
        }
    }

    @Nonnull
    public ApplicationFrameHandler getFrameHandler() {
        if (this.frame == null) {
            this.frame = new XBApplicationFrame();
            this.frame.setApplication(this.application);
            this.frame.loadMainMenu(this.application);
            this.frame.loadMainToolBar(this.application);
            this.frame.setApplicationExitHandler(this.exitHandler);
            if (this.frameActions != null) {
                this.frameActions.setApplicationFrame(this.frame);
            }
        }
        return this.frame;
    }

    public void addExitListener(ApplicationExitListener listener) {
        this.getExitHandler().addListener(listener);
    }

    public void removeExitListener(ApplicationExitListener listener) {
        this.getExitHandler().removeListener(listener);
    }

    @Nonnull
    private ApplicationExitHandler getExitHandler() {
        if (this.exitHandler == null) {
            this.exitHandler = new ApplicationExitHandler();
            if (this.frame != null) {
                this.frame.setApplicationExitHandler(this.exitHandler);
            }
        }
        return this.exitHandler;
    }

    @Nonnull
    private StatusBarHandler getStatusBarHandler() {
        this.getFrameHandler();
        if (this.statusBarHandler == null) {
            this.statusBarHandler = new StatusBarHandler(this.frame);
        }
        return this.statusBarHandler;
    }

    public void registerStatusBar(String moduleId, String statusBarId, JPanel panel) {
        this.getStatusBarHandler().registerStatusBar(moduleId, statusBarId, panel);
    }

    public void switchStatusBar(String statusBarId) {
        this.getStatusBarHandler().switchStatusBar(statusBarId);
    }

    @Nonnull
    public FrameActions getFrameActions() {
        if (this.frameActions == null) {
            this.frameActions = new FrameActions();
            this.ensureSetup();
            this.frameActions.setup(this.application, this.resourceBundle);
            if (this.frame != null) {
                this.frameActions.setApplicationFrame(this.frame);
            }
        }
        return this.frameActions;
    }

    public void registerBarsVisibilityActions() {
        this.registerToolBarVisibilityActions();
        this.registerStatusBarVisibilityActions();
    }

    public void registerToolBarVisibilityActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        this.getFrameActions();
        this.createViewBarsMenuGroup();
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, this.frameActions.getViewToolBarAction(), new MenuPosition(VIEW_BARS_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, this.frameActions.getViewToolBarCaptionsAction(), new MenuPosition(VIEW_BARS_GROUP_ID));
    }

    public void registerStatusBarVisibilityActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        this.getFrameActions();
        this.createViewBarsMenuGroup();
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, this.frameActions.getViewStatusBarAction(), new MenuPosition(VIEW_BARS_GROUP_ID));
    }

    private void createViewBarsMenuGroup() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        if (!actionModule.menuGroupExists(FrameModuleApi.VIEW_MENU_ID, VIEW_BARS_GROUP_ID)) {
            actionModule.registerMenuGroup(FrameModuleApi.VIEW_MENU_ID, new MenuGroup(VIEW_BARS_GROUP_ID, new MenuPosition(PositionMode.TOP), SeparationMode.BELOW));
        }
    }

    @Nonnull
    public WindowUtils.DialogWrapper createDialog() {
        return this.createDialog(null, null);
    }

    @Nonnull
    public WindowUtils.DialogWrapper createDialog(@Nullable JComponent component) {
        return this.createDialog(this.getFrame(), Dialog.ModalityType.APPLICATION_MODAL, component, null);
    }

    @Nonnull
    public WindowUtils.DialogWrapper createDialog(@Nullable JComponent component, @Nullable JPanel controlPanel) {
        return this.createDialog(this.getFrame(), Dialog.ModalityType.APPLICATION_MODAL, component, controlPanel);
    }

    @Nonnull
    public WindowUtils.DialogWrapper createDialog(Component parentComponent, Dialog.ModalityType modalityType, @Nullable JComponent component) {
        return this.createDialog(parentComponent, modalityType, component, null);
    }

    @Nonnull
    public WindowUtils.DialogWrapper createDialog(Component parentComponent, Dialog.ModalityType modalityType, @Nullable JComponent component, @Nullable JPanel controlPanel) {
        JRootPane rootPane;
        JButton defaultButton;
        JComponent dialogComponent = controlPanel != null ? WindowUtils.createDialogPanel((JComponent)component, (JPanel)controlPanel) : component;
        WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogComponent, (Component)parentComponent, (String)"", (Dialog.ModalityType)modalityType);
        Optional applicationIcon = this.application.getApplicationIcon();
        if (applicationIcon.isPresent()) {
            ((JDialog)dialog.getWindow()).setIconImage((Image)applicationIcon.get());
        }
        if (controlPanel instanceof OkCancelService && (defaultButton = ((OkCancelService)controlPanel).getDefaultButton()) != null && (rootPane = SwingUtilities.getRootPane(dialog.getWindow())) != null) {
            rootPane.setDefaultButton(defaultButton);
        }
        return dialog;
    }

    public void setDialogTitle(WindowUtils.DialogWrapper dialog, ResourceBundle resourceBundle) {
        ((JDialog)dialog.getWindow()).setTitle(resourceBundle.getString(RESOURCES_DIALOG_TITLE));
    }
}

