/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.demo.slrub1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LRUB1
implements Serializable {
    static final long serialVersionUID = 1L;

    public String codeFromNumber(long value) {
        StringBuilder result = new StringBuilder();
        this.codeFromNumber(result, value);
        return result.toString();
    }

    public void codeFromNumber(StringBuilder result, long value) {
        LengthCode lengthCode = new LengthCode();
        long decrementor = 2L;
        long length = 1L;
        while (value >= decrementor) {
            long nextLength = lengthCode.nextLength();
            value -= decrementor;
            if (nextLength <= length) continue;
            length = nextLength;
            decrementor *= 4L;
        }
        lengthCode.getCode(result);
        result.append(this.numberToBinary(value, (int)length));
    }

    public long numberFromCode(String source) {
        LengthCode lengthCode = new LengthCode();
        long incrementor = 2L;
        long length = 1L;
        int sourcePos = 0;
        int depth = 0;
        long value = 0L;
        while ("1".equals(String.valueOf(source.charAt(sourcePos)))) {
            ++sourcePos;
            ++depth;
            while (lengthCode.getDepth() < depth) {
                long nextLength = lengthCode.nextLength();
                value += incrementor;
                if (nextLength <= length) continue;
                length = nextLength;
                incrementor *= 4L;
            }
        }
        ++sourcePos;
        while (depth > 0) {
            DepthValue status = lengthCode.getDepthValue(--depth);
            long subValue = this.binaryToNumber(source.substring(sourcePos, sourcePos + status.getLength()));
            sourcePos += status.getLength();
            while (lengthCode.getDepthValue(depth).getValue() < subValue) {
                long nextLength = lengthCode.nextLength();
                value += incrementor;
                if (nextLength <= length) continue;
                length = nextLength;
                incrementor *= 4L;
            }
        }
        return value += this.binaryToNumber(source.substring(sourcePos, sourcePos + (int)length));
    }

    public String numberToBinary(long value, int length) {
        String result = Long.toBinaryString(value);
        if (result.length() < length) {
            result = this.repeat("0", length - result.length()) + result;
        }
        return result;
    }

    public long binaryToNumber(String value) {
        return Long.parseLong(value, 2);
    }

    private String repeat(String string, int repetitions) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * repetitions);
        for (int i = 0; i < repetitions; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public class LengthCode {
        private final List<DepthValue> statuses = new ArrayList<DepthValue>();
        private int length = 0;

        public long nextLength() {
            if (this.statuses.isEmpty()) {
                this.statuses.add(new DepthValue(0L, 1, 1L));
                this.length = 1;
                return this.length;
            }
            int depth = 0;
            DepthValue value = this.statuses.get(depth);
            if (value.getValue() < value.getLimit()) {
                value.setValue(value.getValue() + 1L);
                this.length += 2;
            } else {
                while (depth < this.statuses.size()) {
                    DepthValue next;
                    value = this.statuses.get(depth);
                    if (value.getValue() < value.getLimit()) {
                        value.setValue(value.getValue() + 1L);
                        break;
                    }
                    value.setValue(0L);
                    if (depth == this.statuses.size() - 1) {
                        this.statuses.add(new DepthValue(0L, 1, 1L));
                        break;
                    }
                    if ((next = this.statuses.get(++depth)).getValue() >= next.getLimit()) continue;
                    value.setLimit(value.getLimit() * 2L + 1L);
                    value.setLength(value.getLength() + 2);
                }
            }
            return this.length;
        }

        private void getCode(StringBuilder result) {
            result.append(LRUB1.this.repeat("1", this.statuses.size()));
            result.append("0");
            for (int i = this.statuses.size() - 1; i >= 0; --i) {
                DepthValue depthValue = this.statuses.get(i);
                result.append(LRUB1.this.numberToBinary(depthValue.getValue(), depthValue.getLength()));
            }
        }

        private int getDepth() {
            return this.statuses.size();
        }

        private DepthValue getDepthValue(int index) {
            return this.statuses.get(index);
        }
    }

    private static class DepthValue {
        private long value;
        private long limit;
        private int length;

        public DepthValue(long value, int length, long limit) {
            this.value = value;
            this.length = length;
            this.limit = limit;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getLimit() {
            return this.limit;
        }

        public void setLimit(long limit) {
            this.limit = limit;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }
}

