/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.FontMetrics;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BasicCodeAreaMetrics {
    @Nullable
    private FontMetrics fontMetrics;
    private int rowHeight;
    private int characterWidth;
    private int fontHeight;
    private int maxBytesPerChar;
    private int subFontSpace = 0;

    public void recomputeMetrics(@Nullable FontMetrics fontMetrics, Charset charset) {
        this.fontMetrics = fontMetrics;
        if (fontMetrics == null) {
            this.characterWidth = 0;
            this.fontHeight = 0;
        } else {
            this.rowHeight = this.fontHeight = fontMetrics.getHeight();
            this.characterWidth = fontMetrics.charWidth('m');
            int fontSize = fontMetrics.getFont().getSize();
            this.subFontSpace = this.rowHeight - fontSize;
        }
        try {
            CharsetEncoder encoder = charset.newEncoder();
            this.maxBytesPerChar = (int)encoder.maxBytesPerChar();
        }
        catch (UnsupportedOperationException ex) {
            this.maxBytesPerChar = 8;
        }
    }

    public boolean isInitialized() {
        return this.rowHeight != 0 && this.characterWidth != 0;
    }

    @Nullable
    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public int getCharWidth(char value) {
        return this.fontMetrics.charWidth(value);
    }

    public int getCharsWidth(char[] data, int offset, int length) {
        return this.fontMetrics.charsWidth(data, offset, length);
    }

    public boolean hasUniformLineMetrics() {
        return this.fontMetrics.hasUniformLineMetrics();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getCharacterWidth() {
        return this.characterWidth;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getSubFontSpace() {
        return this.subFontSpace;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }
}

