/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XBDocumentPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBDocumentPanel.class);
    private XBPluginRepository pluginRepository;
    private XBTBlock block;
    private List<BlockViewer> blockViewers = new ArrayList<BlockViewer>();
    private List<ViewerChangedListener> viewerChangedListeners = new ArrayList<ViewerChangedListener>();
    private int activeViewerIndex = -1;
    private BlockViewer activeViewer = null;
    private JTextField addressTextField;
    private JPanel bottomPanel;
    private JPanel headerPanel;
    private JButton nextButton;
    private JButton previousButton;
    private ButtonGroup viewerButtonGroup;

    public XBDocumentPanel() {
        this.initComponents();
    }

    public void addBlockViewer(BlockViewer blockViewer) {
        int blockViewerIndex = this.blockViewers.size();
        this.blockViewers.add(blockViewer);
        ImageIcon icon = blockViewer.getIcon().orElse(null);
        JToggleButton toggleButton = new JToggleButton(blockViewer.getName(), icon);
        this.viewerButtonGroup.add(toggleButton);
        toggleButton.addActionListener(event -> this.viewerChanged(blockViewerIndex));
        this.bottomPanel.add(toggleButton);
        if (blockViewerIndex == 0) {
            toggleButton.setSelected(true);
            this.viewerChanged(0);
        }
    }

    private void viewerChanged(int blockViewerIndex) {
        if (blockViewerIndex >= 0) {
            BlockViewer blockViewer = this.blockViewers.get(blockViewerIndex);
            if (blockViewer == this.activeViewer) {
                return;
            }
            blockViewer.setBlock(this.block);
            if (this.activeViewer != null) {
                this.remove(this.activeViewer.getComponent());
            }
            this.activeViewer = blockViewer;
            this.add((Component)this.activeViewer.getComponent(), "Center");
            this.revalidate();
            this.repaint();
            this.activeViewerIndex = blockViewerIndex;
        }
        for (ViewerChangedListener listener : this.viewerChangedListeners) {
            listener.viewerChanged();
        }
    }

    @Nonnull
    public Optional<BlockViewer> getActiveViewer() {
        return Optional.ofNullable(this.activeViewer);
    }

    public void setBlock(@Nullable XBTBlock block) {
        this.block = block;
        if (this.activeViewer != null) {
            this.activeViewer.setBlock(block);
        }
    }

    public void setAddressText(String addressText) {
        this.addressTextField.setText(addressText);
    }

    private void initComponents() {
        this.viewerButtonGroup = new ButtonGroup();
        this.headerPanel = new JPanel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.addressTextField = new JTextField();
        this.bottomPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/arrow-left.png")));
        this.previousButton.setEnabled(false);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/arrow-right.png")));
        this.nextButton.setEnabled(false);
        this.addressTextField.setEditable(false);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.previousButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressTextField, -1, 476, Short.MAX_VALUE).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.previousButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.nextButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.addressTextField, -2, 0, Short.MAX_VALUE)).addGap(2, 2, 2)));
        this.add((Component)this.headerPanel, "North");
        this.bottomPanel.setLayout(new FlowLayout(0));
        this.add((Component)this.bottomPanel, "South");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBDocumentPanel());
    }

    @Nonnull
    public XBPluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void addTabChangedListener(ViewerChangedListener listener) {
        this.viewerChangedListeners.add(listener);
    }

    public void removeTabChangedListener(ViewerChangedListener listener) {
        this.viewerChangedListeners.remove(listener);
    }

    public static interface ViewerChangedListener {
        public void viewerChanged();
    }
}

