/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.editor.xbup.viewer.gui.XBBlockNameTableCellRenderer;
import org.exbin.framework.editor.xbup.viewer.gui.XBBlockTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTBlock;

@ParametersAreNonnullByDefault
public class XBBlockTablePanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBBlockTablePanel.class);
    private List<DocumentItemSelectionListener> itemSelectionListeners = new ArrayList<DocumentItemSelectionListener>();
    private XBBlockTableModel blockTableModel = new XBBlockTableModel();
    private XBBlockNameTableCellRenderer blockNameTableCellRenderer = new XBBlockNameTableCellRenderer();
    private JTable table;
    private JScrollPane tableScrollPane;

    public XBBlockTablePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.table.setModel(this.blockTableModel);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
        nameColumn.setCellRenderer(this.blockNameTableCellRenderer);
        this.table.getSelectionModel().addListSelectionListener(e -> this.notifyItemSelectionChanged(this.getSelectedItem().orElse(null)));
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.blockTableModel.setTreeDocument(treeDocument);
        this.blockNameTableCellRenderer.setTreeDocument(treeDocument);
    }

    public void setBlock(@Nullable XBTBlock block) {
        this.blockTableModel.setBlock(block);
        this.blockTableModel.fireTableDataChanged();
        if (block != null) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.table.setComponentPopupMenu(popupMenu);
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.setLayout(new BorderLayout());
        this.tableScrollPane.setViewportView(this.table);
        this.add((Component)this.tableScrollPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBBlockTablePanel());
    }

    @Nonnull
    public Optional<XBTBlock> getSelectedItem() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.blockTableModel.getRowAt(selectedRow));
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.add(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.remove(listener);
    }

    private void notifyItemSelectionChanged(@Nullable XBTBlock item) {
        for (DocumentItemSelectionListener listener : this.itemSelectionListeners) {
            listener.itemSelected(item);
        }
    }
}

