/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.viewer.XbupDocument;
import org.exbin.framework.file.api.FileType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.local.XBLBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.OperationEvent;
import org.exbin.xbup.operation.OperationListener;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.undo.XBTLinearUndo;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XbupTreeDocument
implements XbupDocument,
OperationListener {
    private final XBTTreeDocument treeDocument = new XBTTreeDocument();
    private XBUndoHandler undoHandler;
    private XBApplication application;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private final Map<Long, String> captionCache = new HashMap<Long, String>();
    private final Map<Long, ImageIcon> iconCache = new HashMap<Long, ImageIcon>();

    public XbupTreeDocument() {
        this.undoHandler = new XBTLinearUndo(this.treeDocument);
    }

    @Override
    @Nonnull
    public XBACatalog getCatalog() {
        return Objects.requireNonNull(this.catalog);
    }

    @Override
    @Nonnull
    public XBApplication getApplication() {
        return Objects.requireNonNull(this.application);
    }

    @Override
    @Nonnull
    public XBPluginRepository getPluginRepository() {
        return Objects.requireNonNull(this.pluginRepository);
    }

    @Nonnull
    public XBUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.treeDocument.setCatalog((XBCatalog)catalog);
        this.treeDocument.processSpec();
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void notifyChange(OperationEvent event) {
        Operation operation = event.getOperation();
        if (operation instanceof XBTDocOperation) {
            // empty if block
        }
    }

    @Nullable
    public XBTTreeNode getRoot() {
        return this.treeDocument.getRoot();
    }

    @Nonnull
    public Optional<XBTBlock> getRootBlock() {
        return this.treeDocument.getRootBlock();
    }

    public void loadFromResourcePath(Class<?> classInstance, String resourcePath) throws IOException {
        this.treeDocument.fromStreamUB(classInstance.getResourceAsStream(resourcePath));
        this.treeDocument.processSpec();
        this.undoHandler.clear();
    }

    public void newFile() {
        this.treeDocument.clear();
        this.undoHandler.clear();
    }

    public void loadFromFile(URI fileUri, FileType fileType) throws FileNotFoundException, IOException {
        File file = new File(fileUri);
        FileInputStream fileStream = new FileInputStream(file);
        this.treeDocument.fromStreamUB((InputStream)fileStream);
        this.treeDocument.processSpec();
        this.undoHandler.clear();
    }

    public void saveToFile(URI fileUri, FileType fileType) throws IOException {
        File file = new File(fileUri);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.treeDocument.toStreamUB((OutputStream)fileOutputStream);
        this.treeDocument.setModified(false);
        this.undoHandler.setSyncPoint();
    }

    public boolean wasModified() {
        return this.treeDocument.wasModified();
    }

    @Nonnull
    public XBTTreeDocument getDocument() {
        return this.treeDocument;
    }

    public void notifyItemModified(XBTTreeNode block) {
        this.treeDocument.setModified(true);
        this.treeDocument.processSpec();
    }

    @Nullable
    public String getBlockCaption(XBBlockDecl blockDecl) {
        if (blockDecl instanceof XBCBlockDecl) {
            XBCBlockSpec blockSpec = ((XBCBlockDecl)blockDecl).getBlockSpecRev().getParent();
            if (this.captionCache.containsKey(blockSpec.getId())) {
                return this.captionCache.get(blockSpec.getId());
            }
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            String caption = nameService.getDefaultText((XBCItem)blockSpec);
            this.captionCache.put(blockSpec.getId(), caption);
            return caption;
        }
        if (blockDecl instanceof XBLBlockDecl) {
            // empty if block
        }
        return null;
    }

    @Nullable
    public ImageIcon getBlockIcon(XBBlockDecl blockDecl) {
        if (blockDecl instanceof XBCBlockDecl) {
            XBCBlockSpec blockSpec = ((XBCBlockDecl)blockDecl).getBlockSpecRev().getParent();
            if (this.iconCache.containsKey(blockSpec.getId())) {
                return this.iconCache.get(blockSpec.getId());
            }
            XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
            ImageIcon icon = iconService.getDefaultImageIcon((XBCItem)blockSpec);
            if (icon == null) {
                this.iconCache.put(blockSpec.getId(), icon);
                return null;
            }
            if (icon.getImage() == null) {
                return null;
            }
            icon = new ImageIcon(icon.getImage().getScaledInstance(16, 16, 4));
            this.iconCache.put(blockSpec.getId(), icon);
            return icon;
        }
        if (blockDecl instanceof XBDeclBlockType) {
            // empty if block
        }
        return null;
    }
}

