/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.data.gui.cell.ComponentPropertyTableCellPanel;
import org.exbin.framework.editor.xbup.BlockEditor;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;
import org.exbin.xbup.parser_tree.XBATreeParamExtractor;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.parser_tree.XBTTreeReader;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XBPropertyTableCellPanel
extends ComponentPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private final XBPluginRepository pluginRepository;
    private XBTTreeNode node;
    private final int row;

    public XBPropertyTableCellPanel(JComponent cellComponent, XBACatalog catalog, XBPluginRepository pluginRepository, XBTTreeNode node, int row) {
        super(cellComponent);
        this.catalog = catalog;
        this.pluginRepository = pluginRepository;
        this.node = node;
        this.row = row;
        this.init();
    }

    public XBPropertyTableCellPanel(XBACatalog catalog, XBPluginRepository pluginRepository, XBTTreeNode node, int row) {
        this.catalog = catalog;
        this.pluginRepository = pluginRepository;
        this.node = node;
        this.row = row;
        this.init();
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void performEditorAction() {
        XBATreeParamExtractor paramExtractor = new XBATreeParamExtractor((XBTBlock)this.node, this.catalog);
        paramExtractor.setParameterIndex(this.row);
        XBTTreeNode paramNode = new XBTTreeNode();
        XBTTreeReader reader = new XBTTreeReader((XBTEditableBlock)paramNode);
        int depth = 0;
        try {
            do {
                XBTToken token = paramExtractor.pullXBTToken();
                switch (token.getTokenType()) {
                    case BEGIN: {
                        ++depth;
                        break;
                    }
                    case END: {
                        --depth;
                    }
                }
                XBTListenerToToken.tokenToListener((XBTToken)token, (XBTListener)reader);
            } while (depth > 0);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPropertyTableCellPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        BlockEditor blockEditor = new BlockEditor();
        blockEditor.setApplication(this.application);
        blockEditor.setCatalog(this.catalog);
        blockEditor.setPluginRepository(this.pluginRepository);
        blockEditor.setBlock(paramNode);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog(blockEditor.getPanel(), (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), XBPropertyTableCellPanel.class, (ResourceBundle)blockEditor.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                XBTTreeNode xBTTreeNode = blockEditor.getBlock();
            }
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)((Object)this));
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public XBTTreeNode getNode() {
        return this.node;
    }

    public void setNode(XBTTreeNode node) {
        this.node = node;
    }
}

