/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.XBPropertyTablePanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class BlockDefinitionPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBPropertyTablePanel propertiesPanel;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlockDefinitionPanel.class);
    private JLabel descLabel;
    private JTextField descTextField;
    private JPanel itemInfoHeaderPanel;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator7;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel panel;
    private JMenuItem popupCopyMenuItem;
    private JMenuItem popupCutMenuItem;
    private JMenuItem popupDeleteMenuItem;
    private JMenuItem popupItemAddMenuItem;
    private JMenuItem popupItemModifyMenuItem;
    private JMenuItem popupItemOpenMenuItem;
    private JMenuItem popupItemPropertiesMenuItem;
    private JMenuItem popupPasteMenuItem;
    private JMenuItem popupRedoMenuItem;
    private JMenuItem popupSelectAllMenuItem;
    private JMenuItem popupUndoMenuItem;
    private JPopupMenu propertyPopupMenu;

    public BlockDefinitionPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.propertiesPanel = new XBPropertyTablePanel();
        this.panel.add((Component)this.propertiesPanel, "Center");
        this.panel.revalidate();
    }

    private void initComponents() {
        this.propertyPopupMenu = new JPopupMenu();
        this.popupItemOpenMenuItem = new JMenuItem();
        this.popupItemAddMenuItem = new JMenuItem();
        this.popupItemModifyMenuItem = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.popupUndoMenuItem = new JMenuItem();
        this.popupRedoMenuItem = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.popupCutMenuItem = new JMenuItem();
        this.popupCopyMenuItem = new JMenuItem();
        this.popupPasteMenuItem = new JMenuItem();
        this.popupDeleteMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.popupSelectAllMenuItem = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.popupItemPropertiesMenuItem = new JMenuItem();
        this.panel = new JPanel();
        this.itemInfoHeaderPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.descLabel = new JLabel();
        this.descTextField = new JTextField();
        this.nameTextField = new JTextField();
        this.propertyPopupMenu.setName("propertyPopupMenu");
        this.popupItemOpenMenuItem.setText(this.resourceBundle.getString("popupItemOpenMenuItem.text"));
        this.popupItemOpenMenuItem.setName("popupItemOpenMenuItem");
        this.propertyPopupMenu.add(this.popupItemOpenMenuItem);
        this.popupItemAddMenuItem.setText(this.resourceBundle.getString("popupItemAddMenuItem.text"));
        this.popupItemAddMenuItem.setToolTipText(this.resourceBundle.getString("popupItemAddMenuItem.toolTipText"));
        this.popupItemAddMenuItem.setName("popupItemAddMenuItem");
        this.propertyPopupMenu.add(this.popupItemAddMenuItem);
        this.popupItemModifyMenuItem.setText(this.resourceBundle.getString("popupItemModifyMenuItem.text"));
        this.popupItemModifyMenuItem.setToolTipText(this.resourceBundle.getString("popupItemModifyMenuItem.toolTipText"));
        this.popupItemModifyMenuItem.setName("popupItemModifyMenuItem");
        this.propertyPopupMenu.add(this.popupItemModifyMenuItem);
        this.jSeparator14.setName("jSeparator14");
        this.propertyPopupMenu.add(this.jSeparator14);
        this.popupUndoMenuItem.setText(this.resourceBundle.getString("popupUndoMenuItem.text"));
        this.popupUndoMenuItem.setToolTipText(this.resourceBundle.getString("popupUndoMenuItem.toolTipText"));
        this.popupUndoMenuItem.setName("popupUndoMenuItem");
        this.propertyPopupMenu.add(this.popupUndoMenuItem);
        this.popupRedoMenuItem.setText(this.resourceBundle.getString("popupRedoMenuItem.text"));
        this.popupRedoMenuItem.setToolTipText(this.resourceBundle.getString("popupRedoMenuItem.toolTipText"));
        this.popupRedoMenuItem.setName("popupRedoMenuItem");
        this.propertyPopupMenu.add(this.popupRedoMenuItem);
        this.jSeparator10.setName("jSeparator10");
        this.propertyPopupMenu.add(this.jSeparator10);
        this.popupCutMenuItem.setText("Cut");
        this.popupCutMenuItem.setName("popupCutMenuItem");
        this.propertyPopupMenu.add(this.popupCutMenuItem);
        this.popupCopyMenuItem.setText("Copy");
        this.popupCopyMenuItem.setName("popupCopyMenuItem");
        this.propertyPopupMenu.add(this.popupCopyMenuItem);
        this.popupPasteMenuItem.setText("Paste");
        this.popupPasteMenuItem.setName("popupPasteMenuItem");
        this.propertyPopupMenu.add(this.popupPasteMenuItem);
        this.popupDeleteMenuItem.setText("Delete");
        this.popupDeleteMenuItem.setName("popupDeleteMenuItem");
        this.propertyPopupMenu.add(this.popupDeleteMenuItem);
        this.jSeparator7.setName("jSeparator7");
        this.propertyPopupMenu.add(this.jSeparator7);
        this.popupSelectAllMenuItem.setText("Select All");
        this.popupSelectAllMenuItem.setName("popupSelectAllMenuItem");
        this.propertyPopupMenu.add(this.popupSelectAllMenuItem);
        this.jSeparator16.setName("jSeparator16");
        this.propertyPopupMenu.add(this.jSeparator16);
        this.popupItemPropertiesMenuItem.setText(this.resourceBundle.getString("popupItemPropertiesMenuItem.text"));
        this.popupItemPropertiesMenuItem.setName("popupItemPropertiesMenuItem");
        this.propertyPopupMenu.add(this.popupItemPropertiesMenuItem);
        this.setName("Form");
        this.panel.setName("panel");
        this.panel.setLayout(new BorderLayout());
        this.itemInfoHeaderPanel.setName("itemInfoHeaderPanel");
        this.nameLabel.setText(this.resourceBundle.getString("nameLabel.text"));
        this.descLabel.setText(this.resourceBundle.getString("descLabel.text"));
        this.descLabel.setName("descLabel");
        this.descTextField.setEditable(false);
        this.descTextField.setName("descTextField");
        this.nameTextField.setEditable(false);
        this.nameTextField.setName("nameTextField");
        GroupLayout itemInfoHeaderPanelLayout = new GroupLayout(this.itemInfoHeaderPanel);
        this.itemInfoHeaderPanel.setLayout(itemInfoHeaderPanelLayout);
        itemInfoHeaderPanelLayout.setHorizontalGroup(itemInfoHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(itemInfoHeaderPanelLayout.createSequentialGroup().addGroup(itemInfoHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(itemInfoHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descTextField, -1, 208, Short.MAX_VALUE).addComponent(this.nameTextField)).addContainerGap()));
        itemInfoHeaderPanelLayout.setVerticalGroup(itemInfoHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(itemInfoHeaderPanelLayout.createSequentialGroup().addGroup(itemInfoHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(itemInfoHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descLabel).addComponent(this.descTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.panel.add((Component)this.itemInfoHeaderPanel, "North");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, 297, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, 327, Short.MAX_VALUE).addContainerGap()));
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.propertiesPanel.setApplication(application);
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.propertiesPanel.setCatalog(catalog);
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.propertiesPanel.setPluginRepository(pluginRepository);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BlockDefinitionPanel());
    }

    public void setBlock(XBTBlock block) {
        this.propertiesPanel.setBlock(block);
        this.nameTextField.setText(this.getCaption((XBTTreeNode)block));
        this.descTextField.setText(this.getDescription((XBTTreeNode)block));
    }

    private String getCaption(XBTTreeNode node) {
        if (node != null) {
            if (node.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
                return "Data Block";
            }
            XBBlockType blockType = node.getBlockType();
            XBCBlockDecl blockDecl = (XBCBlockDecl)node.getBlockDecl();
            if (blockDecl instanceof XBCBlockDecl) {
                XBCBlockSpec blockSpec = blockDecl.getBlockSpecRev().getParent();
                if (this.catalog != null) {
                    XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
                    return nameService.getDefaultText((XBCItem)blockSpec);
                }
            }
            if (blockType == null) {
                return "Unknown";
            }
            return "Unknown (" + Integer.toString(((XBFBlockType)blockType).getGroupID().getInt()) + ", " + Integer.toString(((XBFBlockType)blockType).getBlockID().getInt()) + ")";
        }
        return "";
    }

    @Nonnull
    private String getDescription(XBTTreeNode node) {
        if (node != null) {
            XBBlockDecl decl = node.getBlockDecl();
            if (this.catalog != null && decl instanceof XBCBlockDecl) {
                XBCBlockSpec spec = ((XBCBlockDecl)decl).getBlockSpecRev().getParent();
                XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
                XBCXDesc desc = descService.getDefaultItemDesc((XBCItem)spec);
                return desc == null ? "" : desc.getText();
            }
        }
        return "";
    }
}

