/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.editor.xbup.def.gui.BlocksPanel;
import org.exbin.framework.editor.xbup.def.model.BlocksTableModel;
import org.exbin.framework.editor.xbup.gui.BlocksTableCellEditor;
import org.exbin.framework.editor.xbup.gui.BlocksTableCellRenderer;
import org.exbin.framework.editor.xbup.gui.BlocksTableItem;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.parser_tree.XBATreeParamExtractor;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBCatalogPlugin;
import org.exbin.xbup.plugin.XBPluginRepository;
import org.exbin.xbup.plugin.XBRowEditor;
import org.exbin.xbup.plugin.XBRowEditorCatalogPlugin;

@ParametersAreNonnullByDefault
public class BlocksEditor {
    private BlocksPanel editorPanel = new BlocksPanel();
    private final BlocksTableModel blocksTableModel = new BlocksTableModel();
    private final DefaultEditItemActions editActions;
    private XBApplication application;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private JPopupMenu popupMenu;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlocksEditor.class);

    public BlocksEditor() {
        this.editActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.editActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void performEditItem() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void performDeleteItem() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                return true;
            }

            public boolean canDeleteItem() {
                return BlocksEditor.this.editorPanel.getSelectedRow() != null;
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                BlocksEditor.this.editorPanel.addSelectionListener(updateListener);
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem addAttributeMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getAddItemAction());
        this.popupMenu.add(addAttributeMenuItem);
        JMenuItem editAttributeMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getEditItemAction());
        this.popupMenu.add(editAttributeMenuItem);
        this.editorPanel.addActions((ActionsProvider)this.editActions);
        this.editorPanel.setPanelPopup(this.popupMenu);
        this.editorPanel.setBlocksTableModel(this.blocksTableModel);
    }

    @Nonnull
    public BlocksPanel getEditorPanel() {
        return this.editorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.editorPanel.setApplication(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.editorPanel.setCatalog(catalog);
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setBlock(XBTTreeNode block) {
        TableColumnModel columnModel = this.editorPanel.getBlocksTable().getColumnModel();
        TableColumn column = columnModel.getColumn(3);
        BlocksTableCellEditor blocksTableCellEditor = new BlocksTableCellEditor(this.catalog, this.pluginRepository, block);
        blocksTableCellEditor.setApplication(this.application);
        column.setCellEditor(blocksTableCellEditor);
        BlocksTableCellRenderer blocksTableCellRenderer = new BlocksTableCellRenderer(this.catalog, this.pluginRepository, block);
        blocksTableCellRenderer.setApplication(this.application);
        column.setCellRenderer(blocksTableCellRenderer);
        this.blocksTableModel.clear();
        if (block == null) {
            this.blocksTableModel.fireTableDataChanged();
            return;
        }
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        long childCount = block.getChildrenCount();
        int childIndex = 0;
        while ((long)childIndex < childCount) {
            XBTTreeNode childBlock = block.getChildAt(childIndex);
            XBBlockDecl decl = childBlock.getBlockDecl();
            XBCBlockSpec spec = null;
            XBCBlockRev blockRev = null;
            if (decl instanceof XBCBlockDecl) {
                blockRev = ((XBCBlockDecl)decl).getBlockSpecRev();
                spec = blockRev.getParent();
            }
            String specName = "";
            String itemType = childBlock.getDataMode() == XBBlockDataMode.DATA_BLOCK ? "Data" : "Node";
            XBRowEditor lineEditor = null;
            if (spec != null) {
                XBCXName specNameItem = nameService.getDefaultItemName((XBCItem)spec);
                if (specNameItem != null) {
                    specName = specNameItem.getText();
                }
                try {
                    lineEditor = this.getCustomEditor(blockRev, uiService);
                    if (lineEditor != null) {
                        XBATreeParamExtractor paramExtractor = new XBATreeParamExtractor((XBTBlock)childBlock, this.catalog);
                        paramExtractor.setParameterIndex(childIndex);
                        XBPSerialReader serialReader = new XBPSerialReader((XBTPullProvider)paramExtractor);
                        serialReader.read((XBSerializable)lineEditor);
                        lineEditor.attachChangeListener((XBRowEditor.ChangeListener)new ComponentEditorChangeListener(lineEditor, paramExtractor, childIndex));
                    }
                }
                catch (IOException | XBProcessingException ex) {
                    Logger.getLogger(BlocksEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            BlocksTableItem itemRecord = new BlocksTableItem(specName, itemType, lineEditor);
            this.blocksTableModel.addRow(itemRecord);
            ++childIndex;
        }
        this.blocksTableModel.fireTableDataChanged();
    }

    @Nullable
    private XBRowEditor getCustomEditor(XBCBlockRev rev, XBCXUiService uiService) {
        if (rev == null || this.catalog == null) {
            return null;
        }
        XBCXBlockUi blockUi = uiService.findUiByPR(rev, XBPlugUiType.ROW_EDITOR, 0L);
        if (blockUi == null) {
            return null;
        }
        XBCXPlugUi plugUi = blockUi.getUi();
        if (plugUi == null) {
            return null;
        }
        XBCXPlugin plugin = plugUi.getPlugin();
        XBCatalogPlugin pluginHandler = this.pluginRepository.getPluginHandler(plugin);
        if (pluginHandler == null) {
            return null;
        }
        return ((XBRowEditorCatalogPlugin)pluginHandler).getRowEditor(plugUi.getMethodIndex());
    }

    @ParametersAreNonnullByDefault
    private class ComponentEditorChangeListener
    implements XBRowEditor.ChangeListener {
        private final XBATreeParamExtractor paramExtractor;
        private final int parameterIndex;
        private final XBRowEditor lineEditor;

        private ComponentEditorChangeListener(XBRowEditor lineEditor, XBATreeParamExtractor paramExtractor, int parameterIndex) {
            this.lineEditor = lineEditor;
            this.paramExtractor = paramExtractor;
            this.parameterIndex = parameterIndex;
        }

        public void valueChanged() {
            this.paramExtractor.setParameterIndex(this.parameterIndex);
            XBPSerialWriter serialWriter = new XBPSerialWriter((XBTEventListener)this.paramExtractor);
            serialWriter.write((XBSerializable)this.lineEditor);
        }
    }
}

