/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.BlockPropertiesPanel;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class ItemPropertiesAction
extends AbstractAction {
    public static final String ACTION_ID = "itemPropertiesAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ItemPropertiesAction.class);
    private XbupEditorProvider viewerProvider;
    private boolean devMode = false;

    public void setup(XbupEditorProvider viewerProvider) {
        this.viewerProvider = viewerProvider;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
        this.setEnabled(false);
        viewerProvider.addItemSelectionListener(item -> this.setEnabled(item != null));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XBApplication application = this.viewerProvider.getApplication();
        XBACatalog catalog = this.viewerProvider.getCatalog();
        FrameModuleApi frameModule = (FrameModuleApi)application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        BlockPropertiesPanel panel = new BlockPropertiesPanel();
        panel.setApplication(application);
        panel.setCatalog(catalog);
        panel.setDevMode(this.devMode);
        XbupFileHandler xbupFile = (XbupFileHandler)this.viewerProvider.getActiveFile().get();
        panel.setBlock(xbupFile.getSelectedItem().get());
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)this.viewerProvider.getEditorComponent());
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }
}

