/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.editor.xbup.gui.AddBlockPanel;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.MultiStepControlPanel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.basic.command.XBTAddBlockCommand;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class AddItemAction
extends AbstractAction {
    public static final String ACTION_ID = "addItemAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AddItemAction.class);
    private XbupEditorProvider editorProvider;
    private AddBlockPanel addItemPanel = null;

    public void setup(XbupEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
        if (editorProvider instanceof MultiEditorProvider) {
            this.setEnabled(editorProvider.getActiveFile().isPresent());
            ((MultiEditorProvider)editorProvider).addActiveFileChangeListener(fileHandler -> this.setEnabled(fileHandler != null));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XBApplication application = this.editorProvider.getApplication();
        XBACatalog catalog = this.editorProvider.getCatalog();
        XbupFileHandler xbupFile = (XbupFileHandler)this.editorProvider.getActiveFile().get();
        XBUndoHandler undoHandler = xbupFile.getUndoHandler();
        FrameModuleApi frameModule = (FrameModuleApi)application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        XBTBlock block = xbupFile.getSelectedItem().orElse(null);
        if (!(block instanceof XBTTreeNode) && block != null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        XBTTreeNode node = (XBTTreeNode)block;
        this.addItemPanel = new AddBlockPanel();
        this.addItemPanel.setApplication(application);
        this.addItemPanel.setCatalog(catalog);
        this.addItemPanel.setParentNode(node);
        MultiStepControlPanel controlPanel = new MultiStepControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)this.addItemPanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), AddBlockPanel.class, (ResourceBundle)this.addItemPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case FINISH: {
                    XBTTreeNode newNode = this.addItemPanel.getWorkNode();
                    try {
                        XBTTreeDocument mainDoc = xbupFile.getDocument();
                        long parentPosition = node == null ? -1L : (long)node.getBlockIndex();
                        int childIndex = node == null ? 0 : node.getChildCount();
                        XBTAddBlockCommand step = new XBTAddBlockCommand((XBTEditableDocument)mainDoc, parentPosition, childIndex, (XBTEditableBlock)newNode);
                        undoHandler.execute((Command)step);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AddItemAction.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    xbupFile.notifyItemModified(newNode);
                    dialog.close();
                    dialog.dispose();
                    break;
                }
                case CANCEL: {
                    dialog.close();
                    dialog.dispose();
                    break;
                }
                case NEXT: {
                    break;
                }
            }
        });
        dialog.showCentered((Component)this.editorProvider.getEditorComponent());
    }
}

