/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.PositionCodeType;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.gui.RelativePositionMode;

@ParametersAreNonnullByDefault
public class GoToPositionPreferences {
    public static final String PREFERENCES_GO_TO_BINARY_POSITION_MODE = "goToBinaryPositionMode";
    public static final String PREFERENCES_GO_TO_BINARY_POSITION_VALUE_TYPE = "goToBinaryPositionValueType";
    private final Preferences preferences;

    public GoToPositionPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public RelativePositionMode getPositionMode() {
        RelativePositionMode defaultMode = RelativePositionMode.FROM_START;
        try {
            return RelativePositionMode.valueOf(this.preferences.get(PREFERENCES_GO_TO_BINARY_POSITION_MODE, defaultMode.name()));
        }
        catch (Exception ex) {
            Logger.getLogger(GoToPositionPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultMode;
        }
    }

    public void setPositionMode(RelativePositionMode positionMode) {
        this.preferences.put(PREFERENCES_GO_TO_BINARY_POSITION_MODE, positionMode.name());
    }

    @Nonnull
    public PositionCodeType getGoToBinaryPositionValueType() {
        PositionCodeType defaultCodeType = PositionCodeType.DECIMAL;
        try {
            return PositionCodeType.valueOf((String)this.preferences.get(PREFERENCES_GO_TO_BINARY_POSITION_VALUE_TYPE, defaultCodeType.name()));
        }
        catch (Exception ex) {
            Logger.getLogger(GoToPositionPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultCodeType;
        }
    }

    public void setGoToBinaryPositionValueType(PositionCodeType goToBinaryPositionValueType) {
        this.preferences.put(PREFERENCES_GO_TO_BINARY_POSITION_VALUE_TYPE, goToBinaryPositionValueType.name());
    }
}

