/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.impl;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.bined.StatusCursorPositionFormat;
import org.exbin.framework.bined.StatusDocumentSizeFormat;
import org.exbin.framework.bined.options.StatusOptions;
import org.exbin.framework.bined.preferences.StatusPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class StatusOptionsImpl
implements OptionsData,
StatusOptions {
    public static int DEFAULT_OCTAL_SPACE_GROUP_SIZE = 4;
    public static int DEFAULT_DECIMAL_SPACE_GROUP_SIZE = 3;
    public static int DEFAULT_HEXADECIMAL_SPACE_GROUP_SIZE = 4;
    private StatusCursorPositionFormat cursorPositionFormat = new StatusCursorPositionFormat();
    private StatusDocumentSizeFormat documentSizeFormat = new StatusDocumentSizeFormat();
    private int octalSpaceGroupSize = DEFAULT_OCTAL_SPACE_GROUP_SIZE;
    private int decimalSpaceGroupSize = DEFAULT_DECIMAL_SPACE_GROUP_SIZE;
    private int hexadecimalSpaceGroupSize = DEFAULT_HEXADECIMAL_SPACE_GROUP_SIZE;

    @Override
    @Nonnull
    public StatusCursorPositionFormat getCursorPositionFormat() {
        return this.cursorPositionFormat;
    }

    @Override
    public void setCursorPositionFormat(StatusCursorPositionFormat cursorPositionFormat) {
        this.cursorPositionFormat = cursorPositionFormat;
    }

    @Override
    @Nonnull
    public StatusDocumentSizeFormat getDocumentSizeFormat() {
        return this.documentSizeFormat;
    }

    @Override
    public void setDocumentSizeFormat(StatusDocumentSizeFormat documentSizeFormat) {
        this.documentSizeFormat = documentSizeFormat;
    }

    @Override
    public int getOctalSpaceGroupSize() {
        return this.octalSpaceGroupSize;
    }

    @Override
    public void setOctalSpaceGroupSize(int octalSpaceGroupSize) {
        this.octalSpaceGroupSize = octalSpaceGroupSize;
    }

    @Override
    public int getDecimalSpaceGroupSize() {
        return this.decimalSpaceGroupSize;
    }

    @Override
    public void setDecimalSpaceGroupSize(int decimalSpaceGroupSize) {
        this.decimalSpaceGroupSize = decimalSpaceGroupSize;
    }

    @Override
    public int getHexadecimalSpaceGroupSize() {
        return this.hexadecimalSpaceGroupSize;
    }

    @Override
    public void setHexadecimalSpaceGroupSize(int hexadecimalSpaceGroupSize) {
        this.hexadecimalSpaceGroupSize = hexadecimalSpaceGroupSize;
    }

    public void loadFromPreferences(StatusPreferences preferences) {
        this.cursorPositionFormat.setCodeType(preferences.getCursorPositionCodeType());
        this.cursorPositionFormat.setShowOffset(preferences.isCursorShowOffset());
        this.documentSizeFormat.setCodeType(preferences.getDocumentSizeCodeType());
        this.documentSizeFormat.setShowRelative(preferences.isDocumentSizeShowRelative());
        this.octalSpaceGroupSize = preferences.getOctalSpaceGroupSize();
        this.decimalSpaceGroupSize = preferences.getDecimalSpaceGroupSize();
        this.hexadecimalSpaceGroupSize = preferences.getHexadecimalSpaceGroupSize();
    }

    public void saveToPreferences(StatusPreferences preferences) {
        preferences.setCursorPositionCodeType(this.cursorPositionFormat.getCodeType());
        preferences.setCursorShowOffset(this.cursorPositionFormat.isShowOffset());
        preferences.setDocumentSizeCodeType(this.documentSizeFormat.getCodeType());
        preferences.setDocumentSizeShowRelative(this.documentSizeFormat.isShowRelative());
        preferences.setOctalSpaceGroupSize(this.octalSpaceGroupSize);
        preferences.setDecimalSpaceGroupSize(this.decimalSpaceGroupSize);
        preferences.setHexadecimalSpaceGroupSize(this.hexadecimalSpaceGroupSize);
    }

    public void setOptions(StatusOptionsImpl statusOptions) {
        this.cursorPositionFormat = statusOptions.cursorPositionFormat;
        this.documentSizeFormat = statusOptions.documentSizeFormat;
        this.octalSpaceGroupSize = statusOptions.octalSpaceGroupSize;
        this.decimalSpaceGroupSize = statusOptions.decimalSpaceGroupSize;
        this.hexadecimalSpaceGroupSize = statusOptions.hexadecimalSpaceGroupSize;
    }
}

