/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.exbin.bined.swing.extended.layout.DefaultExtendedCodeAreaLayoutProfile;
import org.exbin.framework.bined.options.CodeAreaLayoutOptions;
import org.exbin.framework.bined.preferences.CodeAreaLayoutPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class CodeAreaLayoutOptionsImpl
implements OptionsData,
CodeAreaLayoutOptions {
    private CodeAreaLayoutPreferences preferences;
    private final List<ProfileRecord> profileRecords = new ArrayList<ProfileRecord>();
    private int selectedProfile = -1;

    @Nonnull
    public List<String> getProfileNames() {
        ArrayList<String> profilesNames = new ArrayList<String>();
        this.profileRecords.forEach(profile -> profilesNames.add(profile.getName()));
        return profilesNames;
    }

    @Override
    @Nonnull
    public DefaultExtendedCodeAreaLayoutProfile getLayoutProfile(int index) {
        ProfileRecord record = this.profileRecords.get(index);
        if (record.profile == null) {
            record = new ProfileRecord(record.name, this.preferences.getLayoutProfile(index));
            this.profileRecords.set(index, record);
        }
        return record.profile;
    }

    @Override
    public void setLayoutProfile(int index, DefaultExtendedCodeAreaLayoutProfile layoutProfile) {
        ProfileRecord record = this.profileRecords.get(index);
        record = new ProfileRecord(record.name, layoutProfile);
        this.profileRecords.set(index, record);
    }

    @Override
    public void removeLayoutProfile(int index) {
        for (int i = index + 1; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            if (record.profile != null) continue;
            record = new ProfileRecord(record.name, this.preferences.getLayoutProfile(i));
            this.profileRecords.set(i, record);
        }
        if (this.selectedProfile == index) {
            this.selectedProfile = -1;
        } else if (this.selectedProfile > index) {
            --this.selectedProfile;
        }
        this.profileRecords.remove(index);
    }

    public void fullyLoad() {
        for (int i = 0; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            if (record.profile != null) continue;
            record = new ProfileRecord(record.name, this.preferences.getLayoutProfile(i));
            this.profileRecords.set(i, record);
        }
    }

    @Override
    public int getSelectedProfile() {
        return this.selectedProfile;
    }

    @Override
    public void setSelectedProfile(int profileIndex) {
        this.selectedProfile = profileIndex;
    }

    public void clearProfiles() {
        this.profileRecords.clear();
    }

    public void addProfile(String profileName, DefaultExtendedCodeAreaLayoutProfile layoutProfile) {
        this.profileRecords.add(new ProfileRecord(profileName, layoutProfile));
    }

    public void loadFromPreferences(CodeAreaLayoutPreferences preferences) {
        this.preferences = preferences;
        this.profileRecords.clear();
        List<String> layoutProfilesList = preferences.getLayoutProfilesList();
        layoutProfilesList.forEach(name -> this.profileRecords.add(new ProfileRecord((String)name, null)));
        this.selectedProfile = preferences.getSelectedProfile();
    }

    public void saveToPreferences(CodeAreaLayoutPreferences preferences) {
        preferences.setSelectedProfile(this.selectedProfile);
        preferences.setLayoutProfilesList(this.getProfileNames());
        for (int i = 0; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            DefaultExtendedCodeAreaLayoutProfile profile = record.profile;
            if (profile == null) continue;
            preferences.setLayoutProfile(i, record.profile);
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static class ProfileRecord {
        private final String name;
        private final DefaultExtendedCodeAreaLayoutProfile profile;

        public ProfileRecord(String name, DefaultExtendedCodeAreaLayoutProfile profile) {
            this.name = name;
            this.profile = profile;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public DefaultExtendedCodeAreaLayoutProfile getProfile() {
            return this.profile;
        }
    }
}

