/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.bined.options.gui.LayoutTemplatePanel;
import org.exbin.framework.bined.options.gui.PreviewPanel;
import org.exbin.framework.bined.options.gui.ProfileListPanel;
import org.exbin.framework.bined.options.impl.CodeAreaThemeOptionsImpl;
import org.exbin.framework.bined.preferences.CodeAreaThemePreferences;
import org.exbin.framework.preferences.PreferencesWrapper;
import org.exbin.framework.preferences.StreamPreferences;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ThemeTemplatePanel
extends JPanel
implements ProfileListPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ThemeTemplatePanel.class);
    private PreviewPanel previewPanel;
    private JScrollPane profilesListScrollPane;
    private JList<ThemeProfile> templatesList;

    public ThemeTemplatePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.templatesList.setModel(new ProfilesListModel());
        this.templatesList.setCellRenderer(new ProfileCellRenderer());
        this.templatesList.addListSelectionListener(e -> this.updateStates());
        this.loadFromOptions();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void updateStates() {
        ThemeProfile themeProfile = this.getSelectedTemplate();
        if (themeProfile != null) {
            this.previewPanel.getCodeArea().setThemeProfile(themeProfile.getThemeProfile());
        }
    }

    @Nullable
    public ThemeProfile getSelectedTemplate() {
        int selectedIndex = this.templatesList.getSelectedIndex();
        return selectedIndex < 0 ? null : this.getProfilesListModel().getElementAt(selectedIndex);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.templatesList.addListSelectionListener(listener);
    }

    @Override
    @Nonnull
    public List<String> getProfileNames() {
        ArrayList<String> profileNames = new ArrayList<String>();
        this.getProfilesListModel().profiles.forEach(profile -> profileNames.add(((ThemeProfile)profile).profileName));
        return profileNames;
    }

    @Nonnull
    private ProfilesListModel getProfilesListModel() {
        return (ProfilesListModel)this.templatesList.getModel();
    }

    @Override
    public void addProfileListPanelListener(ListDataListener listener) {
        this.getProfilesListModel().addListDataListener(listener);
    }

    public ExtendedCodeAreaThemeProfile getProfile(int profileIndex) {
        return this.getProfilesListModel().getElementAt(profileIndex).themeProfile;
    }

    private void initComponents() {
        this.profilesListScrollPane = new JScrollPane();
        this.templatesList = new JList();
        this.previewPanel = new PreviewPanel();
        this.profilesListScrollPane.setViewportView(this.templatesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.profilesListScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, 553, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewPanel, -1, 520, Short.MAX_VALUE).addComponent(this.profilesListScrollPane)).addContainerGap()));
    }

    public void addProfilesListListener(ListDataListener listener) {
        this.getProfilesListModel().addListDataListener(listener);
    }

    private void loadFromOptions() {
        CodeAreaThemeOptionsImpl options = new CodeAreaThemeOptionsImpl();
        try (InputStream stream = this.getClass().getResourceAsStream("/org/exbin/framework/bined/resources/templates/themeTemplates.xml");){
            StreamPreferences filePreferences = new StreamPreferences(stream);
            options.loadFromPreferences(new CodeAreaThemePreferences((org.exbin.framework.api.Preferences)new PreferencesWrapper((Preferences)filePreferences)));
            ArrayList<ThemeProfile> profiles = new ArrayList<ThemeProfile>();
            List<String> profileNames = options.getProfileNames();
            for (int index = 0; index < profileNames.size(); ++index) {
                ThemeProfile profile = new ThemeProfile(profileNames.get(index), options.getThemeProfile(index));
                profiles.add(profile);
            }
            ProfilesListModel model = this.getProfilesListModel();
            model.setProfiles(profiles);
        }
        catch (IOException ex) {
            Logger.getLogger(LayoutTemplatePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ThemeTemplatePanel());
    }

    @ParametersAreNonnullByDefault
    private static final class ProfileCellRenderer
    implements ListCellRenderer<ThemeProfile> {
        private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();

        private ProfileCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ThemeProfile> list, ThemeProfile value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value.profileName, index, isSelected, cellHasFocus);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ProfilesListModel
    extends AbstractListModel<ThemeProfile> {
        private final List<ThemeProfile> profiles = new ArrayList<ThemeProfile>();

        @Override
        public int getSize() {
            if (this.profiles == null) {
                return 0;
            }
            return this.profiles.size();
        }

        public boolean isEmpty() {
            return this.profiles == null || this.profiles.isEmpty();
        }

        @Override
        @Nullable
        public ThemeProfile getElementAt(int index) {
            return this.profiles.get(index);
        }

        @Nonnull
        public List<ThemeProfile> getProfiles() {
            return this.profiles;
        }

        public void setProfiles(List<ThemeProfile> profiles) {
            int profilesSize;
            int size = this.profiles.size();
            if (size > 0) {
                this.profiles.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
            if ((profilesSize = profiles.size()) > 0) {
                this.profiles.addAll(profiles);
                this.fireIntervalAdded(this, 0, profilesSize - 1);
            }
        }

        public void addAll(List<ThemeProfile> list, int index) {
            if (index >= 0) {
                this.profiles.addAll(index, list);
                this.fireIntervalAdded(this, index, list.size() + index);
            } else {
                this.profiles.addAll(list);
                this.fireIntervalAdded(this, this.profiles.size() - list.size(), this.profiles.size());
            }
        }

        public void removeIndices(int[] indices) {
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.profiles.remove(indices[i]);
                this.fireIntervalRemoved(this, indices[i], indices[i]);
            }
        }

        public void remove(int index) {
            this.profiles.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void add(int index, ThemeProfile item) {
            this.profiles.add(index, item);
            this.fireIntervalAdded(this, index, index);
        }

        public void add(ThemeProfile item) {
            this.profiles.add(item);
            int index = this.profiles.size() - 1;
            this.fireIntervalAdded(this, index, index);
        }

        public void notifyProfileModified(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }

    @ParametersAreNonnullByDefault
    public static final class ThemeProfile {
        private String profileName;
        private ExtendedCodeAreaThemeProfile themeProfile;

        public ThemeProfile(String profileName, ExtendedCodeAreaThemeProfile themeProfile) {
            this.profileName = profileName;
            this.themeProfile = themeProfile;
        }

        @Nonnull
        public String getProfileName() {
            return this.profileName;
        }

        @Nonnull
        public ExtendedCodeAreaThemeProfile getThemeProfile() {
            return this.themeProfile;
        }
    }
}

