/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.SelectionRange;
import org.exbin.framework.bined.gui.BaseSwitchableSpinnerPanel;
import org.exbin.framework.bined.gui.RelativePositionMode;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class EditSelectionPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(EditSelectionPanel.class);
    private long cursorPosition;
    private long maxPosition;
    private RelativePositionMode startPosMode = RelativePositionMode.FROM_START;
    private RelativePositionMode endPosMode = RelativePositionMode.FROM_START;
    private volatile boolean activeUpdate = false;
    private JLabel currentPositionLabel;
    private JTextField currentPositionTextField;
    private BaseSwitchableSpinnerPanel endPositionBaseSwitchableSpinnerPanel;
    private JLabel endPositionLabel;
    private JPanel endPositionPanel;
    private JTextField endPositionTextField;
    private ButtonGroup endPositionTypeButtonGroup;
    private JRadioButton fromCursorRadioButton;
    private JRadioButton fromCursorRadioButton1;
    private JRadioButton fromEndRadioButton;
    private JRadioButton fromEndRadioButton1;
    private JRadioButton fromStartRadioButton;
    private JRadioButton fromStartRadioButton1;
    private BaseSwitchableSpinnerPanel lengthBaseSwitchableSpinnerPanel;
    private JLabel positionLabel;
    private JLabel positionLabel1;
    private JPanel selectionLengthPanel;
    private BaseSwitchableSpinnerPanel startPositionBaseSwitchableSpinnerPanel;
    private JLabel startPositionLabel;
    private JPanel startPositionPanel;
    private JTextField startPositionTextField;
    private ButtonGroup startPositionTypeButtonGroup;

    public EditSelectionPanel() {
        this.initComponents();
        this.startPositionBaseSwitchableSpinnerPanel.setMinimum(0L);
        this.startPositionBaseSwitchableSpinnerPanel.addChangeListener(evt -> {
            if (!this.activeUpdate) {
                try {
                    this.activeUpdate = true;
                    long startPosition = this.getStartPositionValue();
                    long maxLength = this.maxPosition - startPosition;
                    this.lengthBaseSwitchableSpinnerPanel.setMaximum(maxLength);
                    long length = this.getEndPositionValue() - startPosition;
                    this.lengthBaseSwitchableSpinnerPanel.setValue(length);
                }
                finally {
                    this.activeUpdate = false;
                }
            }
            this.updateStartTargetPosition();
            this.updateEndTargetPosition();
        });
        this.endPositionBaseSwitchableSpinnerPanel.setMinimum(0L);
        this.endPositionBaseSwitchableSpinnerPanel.addChangeListener(evt -> {
            if (!this.activeUpdate) {
                try {
                    this.activeUpdate = true;
                    long startPosition = this.getStartPositionValue();
                    long length = this.getEndPositionValue() - startPosition;
                    this.lengthBaseSwitchableSpinnerPanel.setValue(length);
                }
                finally {
                    this.activeUpdate = false;
                }
            }
            this.updateStartTargetPosition();
            this.updateEndTargetPosition();
        });
        this.lengthBaseSwitchableSpinnerPanel.setMinimum(0L);
        this.lengthBaseSwitchableSpinnerPanel.addChangeListener(evt -> {
            if (!this.activeUpdate) {
                try {
                    this.activeUpdate = true;
                    long endPosition = this.getStartPositionValue() + this.getSelectionLengthValue();
                    this.endPositionBaseSwitchableSpinnerPanel.setValue(endPosition);
                }
                finally {
                    this.activeUpdate = false;
                }
            }
            this.updateStartTargetPosition();
            this.updateEndTargetPosition();
        });
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.startPositionTypeButtonGroup = new ButtonGroup();
        this.endPositionTypeButtonGroup = new ButtonGroup();
        this.currentPositionLabel = new JLabel();
        this.currentPositionTextField = new JTextField();
        this.startPositionPanel = new JPanel();
        this.fromStartRadioButton = new JRadioButton();
        this.fromEndRadioButton = new JRadioButton();
        this.fromCursorRadioButton = new JRadioButton();
        this.positionLabel = new JLabel();
        this.startPositionBaseSwitchableSpinnerPanel = new BaseSwitchableSpinnerPanel();
        this.endPositionPanel = new JPanel();
        this.fromStartRadioButton1 = new JRadioButton();
        this.fromEndRadioButton1 = new JRadioButton();
        this.fromCursorRadioButton1 = new JRadioButton();
        this.positionLabel1 = new JLabel();
        this.endPositionBaseSwitchableSpinnerPanel = new BaseSwitchableSpinnerPanel();
        this.selectionLengthPanel = new JPanel();
        this.lengthBaseSwitchableSpinnerPanel = new BaseSwitchableSpinnerPanel();
        this.startPositionLabel = new JLabel();
        this.startPositionTextField = new JTextField();
        this.endPositionLabel = new JLabel();
        this.endPositionTextField = new JTextField();
        this.currentPositionLabel.setText(this.resourceBundle.getString("currentPositionLabel.text"));
        this.currentPositionTextField.setEditable(false);
        this.currentPositionTextField.setText("0");
        this.startPositionPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("startPositionPanel.border.title")));
        this.startPositionTypeButtonGroup.add(this.fromStartRadioButton);
        this.fromStartRadioButton.setSelected(true);
        this.fromStartRadioButton.setText(this.resourceBundle.getString("fromStartRadioButton.text"));
        this.fromStartRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditSelectionPanel.this.fromStartRadioButtonItemStateChanged(evt);
            }
        });
        this.startPositionTypeButtonGroup.add(this.fromEndRadioButton);
        this.fromEndRadioButton.setText(this.resourceBundle.getString("fromEndRadioButton.text"));
        this.fromEndRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditSelectionPanel.this.fromEndRadioButtonItemStateChanged(evt);
            }
        });
        this.startPositionTypeButtonGroup.add(this.fromCursorRadioButton);
        this.fromCursorRadioButton.setText(this.resourceBundle.getString("fromCursorRadioButton.text"));
        this.fromCursorRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditSelectionPanel.this.fromCursorRadioButtonItemStateChanged(evt);
            }
        });
        this.positionLabel.setText(this.resourceBundle.getString("positionLabel.text"));
        GroupLayout startPositionPanelLayout = new GroupLayout(this.startPositionPanel);
        this.startPositionPanel.setLayout(startPositionPanelLayout);
        startPositionPanelLayout.setHorizontalGroup(startPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, startPositionPanelLayout.createSequentialGroup().addContainerGap().addGroup(startPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fromCursorRadioButton, -1, -1, Short.MAX_VALUE).addComponent(this.fromEndRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fromStartRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.startPositionBaseSwitchableSpinnerPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, startPositionPanelLayout.createSequentialGroup().addComponent(this.positionLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        startPositionPanelLayout.setVerticalGroup(startPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startPositionPanelLayout.createSequentialGroup().addComponent(this.fromStartRadioButton, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromEndRadioButton, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromCursorRadioButton, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.positionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startPositionBaseSwitchableSpinnerPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.endPositionPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("endPositionPanel.border.title")));
        this.endPositionTypeButtonGroup.add(this.fromStartRadioButton1);
        this.fromStartRadioButton1.setSelected(true);
        this.fromStartRadioButton1.setText(this.resourceBundle.getString("fromStartRadioButton.text"));
        this.fromStartRadioButton1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditSelectionPanel.this.fromStartRadioButton1ItemStateChanged(evt);
            }
        });
        this.endPositionTypeButtonGroup.add(this.fromEndRadioButton1);
        this.fromEndRadioButton1.setText(this.resourceBundle.getString("fromEndRadioButton.text"));
        this.fromEndRadioButton1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditSelectionPanel.this.fromEndRadioButton1ItemStateChanged(evt);
            }
        });
        this.endPositionTypeButtonGroup.add(this.fromCursorRadioButton1);
        this.fromCursorRadioButton1.setText(this.resourceBundle.getString("fromCursorRadioButton.text"));
        this.fromCursorRadioButton1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditSelectionPanel.this.fromCursorRadioButton1ItemStateChanged(evt);
            }
        });
        this.positionLabel1.setText(this.resourceBundle.getString("positionLabel.text"));
        GroupLayout endPositionPanelLayout = new GroupLayout(this.endPositionPanel);
        this.endPositionPanel.setLayout(endPositionPanelLayout);
        endPositionPanelLayout.setHorizontalGroup(endPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, endPositionPanelLayout.createSequentialGroup().addContainerGap().addGroup(endPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fromCursorRadioButton1, -1, -1, Short.MAX_VALUE).addComponent(this.fromEndRadioButton1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fromStartRadioButton1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.endPositionBaseSwitchableSpinnerPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, endPositionPanelLayout.createSequentialGroup().addComponent(this.positionLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        endPositionPanelLayout.setVerticalGroup(endPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(endPositionPanelLayout.createSequentialGroup().addComponent(this.fromStartRadioButton1, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromEndRadioButton1, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromCursorRadioButton1, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.positionLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endPositionBaseSwitchableSpinnerPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.selectionLengthPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("selectionLengthPanel.border.title")));
        GroupLayout selectionLengthPanelLayout = new GroupLayout(this.selectionLengthPanel);
        this.selectionLengthPanel.setLayout(selectionLengthPanelLayout);
        selectionLengthPanelLayout.setHorizontalGroup(selectionLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionLengthPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lengthBaseSwitchableSpinnerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        selectionLengthPanelLayout.setVerticalGroup(selectionLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionLengthPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lengthBaseSwitchableSpinnerPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.startPositionLabel.setText(this.resourceBundle.getString("startPositionLabel.text"));
        this.startPositionTextField.setEditable(false);
        this.startPositionTextField.setText("0");
        this.endPositionLabel.setText(this.resourceBundle.getString("endPositionLabel.text"));
        this.endPositionTextField.setEditable(false);
        this.endPositionTextField.setText("0");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startPositionTextField).addComponent(this.endPositionTextField).addComponent(this.selectionLengthPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.currentPositionTextField).addComponent(this.startPositionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.endPositionPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.currentPositionLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startPositionLabel).addComponent(this.endPositionLabel)).addGap(330, 330, 330))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.currentPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentPositionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startPositionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endPositionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionLengthPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startPositionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endPositionTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void fromStartRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.fromStartRadioButton.isSelected()) {
            this.switchStartPosMode(RelativePositionMode.FROM_START);
        }
    }

    private void fromEndRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.fromEndRadioButton.isSelected()) {
            this.switchStartPosMode(RelativePositionMode.FROM_END);
        }
    }

    private void fromCursorRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.fromCursorRadioButton.isSelected()) {
            this.switchStartPosMode(RelativePositionMode.FROM_CURSOR);
        }
    }

    private void fromStartRadioButton1ItemStateChanged(ItemEvent evt) {
        if (this.fromStartRadioButton1.isSelected()) {
            this.switchEndPosMode(RelativePositionMode.FROM_START);
        }
    }

    private void fromEndRadioButton1ItemStateChanged(ItemEvent evt) {
        if (this.fromEndRadioButton1.isSelected()) {
            this.switchEndPosMode(RelativePositionMode.FROM_END);
        }
    }

    private void fromCursorRadioButton1ItemStateChanged(ItemEvent evt) {
        if (this.fromCursorRadioButton1.isSelected()) {
            this.switchEndPosMode(RelativePositionMode.FROM_CURSOR);
        }
    }

    private void updateStartTargetPosition() {
        this.startPositionTextField.setText(String.valueOf(this.getStartTargetPosition()));
    }

    private void updateEndTargetPosition() {
        this.endPositionTextField.setText(String.valueOf(this.getEndTargetPosition()));
    }

    public void initFocus() {
        this.startPositionBaseSwitchableSpinnerPanel.initFocus();
    }

    public long getStartTargetPosition() {
        long absolutePosition;
        long position = this.getStartPositionValue();
        switch (this.startPosMode) {
            case FROM_START: {
                absolutePosition = position;
                break;
            }
            case FROM_END: {
                absolutePosition = this.maxPosition - position;
                break;
            }
            case FROM_CURSOR: {
                absolutePosition = this.cursorPosition + position;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.startPosMode);
            }
        }
        if (absolutePosition < 0L) {
            absolutePosition = 0L;
        } else if (absolutePosition > this.maxPosition) {
            absolutePosition = this.maxPosition;
        }
        return absolutePosition;
    }

    public long getEndTargetPosition() {
        long absolutePosition;
        long position = this.getEndPositionValue();
        switch (this.endPosMode) {
            case FROM_START: {
                absolutePosition = position;
                break;
            }
            case FROM_END: {
                absolutePosition = this.maxPosition - position;
                break;
            }
            case FROM_CURSOR: {
                absolutePosition = this.cursorPosition + position;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.endPosMode);
            }
        }
        if (absolutePosition < 0L) {
            absolutePosition = 0L;
        } else if (absolutePosition > this.maxPosition) {
            absolutePosition = this.maxPosition;
        }
        return absolutePosition;
    }

    public void setStartTargetPosition(long absolutePosition) {
        if (absolutePosition < 0L) {
            absolutePosition = 0L;
        } else if (absolutePosition > this.maxPosition) {
            absolutePosition = this.maxPosition;
        }
        switch (this.startPosMode) {
            case FROM_START: {
                this.setStartPositionValue(absolutePosition);
                break;
            }
            case FROM_END: {
                this.setStartPositionValue(this.maxPosition - absolutePosition);
                break;
            }
            case FROM_CURSOR: {
                this.setStartPositionValue(absolutePosition - this.cursorPosition);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.startPosMode);
            }
        }
        this.updateStartTargetPosition();
    }

    public void setEndTargetPosition(long absolutePosition) {
        if (absolutePosition < 0L) {
            absolutePosition = 0L;
        } else if (absolutePosition > this.maxPosition) {
            absolutePosition = this.maxPosition;
        }
        switch (this.endPosMode) {
            case FROM_START: {
                this.setEndPositionValue(absolutePosition);
                break;
            }
            case FROM_END: {
                this.setEndPositionValue(this.maxPosition - absolutePosition);
                break;
            }
            case FROM_CURSOR: {
                this.setEndPositionValue(absolutePosition - this.cursorPosition);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.endPosMode);
            }
        }
        this.updateEndTargetPosition();
    }

    public long getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(long cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public void setMaxPosition(long maxPosition) {
        this.maxPosition = maxPosition;
        this.startPositionBaseSwitchableSpinnerPanel.setMaximum(maxPosition);
        this.endPositionBaseSwitchableSpinnerPanel.setMaximum(maxPosition);
        this.lengthBaseSwitchableSpinnerPanel.setMaximum(maxPosition);
        this.updateStartTargetPosition();
    }

    @Nonnull
    public Optional<SelectionRange> getSelectionRange() {
        return Optional.of(new SelectionRange(this.getStartTargetPosition(), this.getEndTargetPosition()));
    }

    public void setSelectionRange(@Nullable SelectionRange selection) {
        if (selection == null) {
            this.setStartTargetPosition(0L);
            this.setEndTargetPosition(0L);
        } else {
            this.setStartTargetPosition(selection.getStart());
            this.setEndTargetPosition(selection.getEnd());
        }
    }

    public void setSelected() {
        this.startPositionBaseSwitchableSpinnerPanel.requestFocusInWindow();
    }

    private void switchStartPosMode(RelativePositionMode positionMode) {
        if (this.startPosMode == positionMode) {
            return;
        }
        long absolutePosition = this.getStartTargetPosition();
        this.startPosMode = positionMode;
        switch (positionMode) {
            case FROM_START: 
            case FROM_END: {
                this.setStartPositionValue(0L);
                this.startPositionBaseSwitchableSpinnerPanel.setMinimum(0L);
                this.startPositionBaseSwitchableSpinnerPanel.setMaximum(this.maxPosition);
                this.startPositionBaseSwitchableSpinnerPanel.revalidateSpinner();
                break;
            }
            case FROM_CURSOR: {
                this.setStartPositionValue(0L);
                this.startPositionBaseSwitchableSpinnerPanel.setMinimum(-this.cursorPosition);
                this.startPositionBaseSwitchableSpinnerPanel.setMaximum(this.maxPosition - this.cursorPosition);
                this.startPositionBaseSwitchableSpinnerPanel.revalidateSpinner();
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)positionMode);
            }
        }
        this.setStartTargetPosition(absolutePosition);
    }

    private void switchEndPosMode(RelativePositionMode positionMode) {
        if (this.endPosMode == positionMode) {
            return;
        }
        long absolutePosition = this.getEndTargetPosition();
        this.endPosMode = positionMode;
        switch (positionMode) {
            case FROM_START: 
            case FROM_END: {
                this.setEndPositionValue(0L);
                this.startPositionBaseSwitchableSpinnerPanel.setMinimum(0L);
                this.startPositionBaseSwitchableSpinnerPanel.setMaximum(this.maxPosition);
                this.startPositionBaseSwitchableSpinnerPanel.revalidateSpinner();
                break;
            }
            case FROM_CURSOR: {
                this.setEndPositionValue(0L);
                this.startPositionBaseSwitchableSpinnerPanel.setMinimum(-this.cursorPosition);
                this.startPositionBaseSwitchableSpinnerPanel.setMaximum(this.maxPosition - this.cursorPosition);
                this.startPositionBaseSwitchableSpinnerPanel.revalidateSpinner();
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)positionMode);
            }
        }
        this.setEndTargetPosition(absolutePosition);
    }

    private long getStartPositionValue() {
        return this.startPositionBaseSwitchableSpinnerPanel.getValue();
    }

    private long getEndPositionValue() {
        return this.endPositionBaseSwitchableSpinnerPanel.getValue();
    }

    private long getSelectionLengthValue() {
        return this.lengthBaseSwitchableSpinnerPanel.getValue();
    }

    private void setStartPositionValue(long value) {
        this.startPositionBaseSwitchableSpinnerPanel.setValue(value);
        this.lengthBaseSwitchableSpinnerPanel.setValue(this.getEndPositionValue() - value);
        this.updateStartTargetPosition();
    }

    private void setEndPositionValue(long value) {
        this.endPositionBaseSwitchableSpinnerPanel.setValue(value);
        this.lengthBaseSwitchableSpinnerPanel.setValue(value - this.getStartPositionValue());
        this.updateEndTargetPosition();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new EditSelectionPanel());
    }

    public void acceptInput() {
        this.startPositionBaseSwitchableSpinnerPanel.acceptInput();
        this.endPositionBaseSwitchableSpinnerPanel.acceptInput();
        this.lengthBaseSwitchableSpinnerPanel.acceptInput();
    }
}

