/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.operation.swing.CodeAreaOperationCommandHandler;
import org.exbin.bined.operation.swing.CodeAreaUndoHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.operation.undo.EmptyBinaryDataUndoHandler;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdCodeAreaPainter;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinEdComponentPanel
extends JPanel {
    private ExtCodeArea codeArea;
    private BinaryDataUndoHandler undoHandler;
    private final List<BinEdComponentExtension> componentExtensions = new ArrayList<BinEdComponentExtension>();

    public BinEdComponentPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.codeArea = new ExtCodeArea();
        this.codeArea.setPainter((CodeAreaPainter)new BinEdCodeAreaPainter((CodeAreaCore)this.codeArea));
        this.codeArea.setCodeFont(new Font("Monospaced", 0, 12));
        this.codeArea.setFocusTraversalKeysEnabled(false);
        CodeAreaOperationCommandHandler commandHandler = new CodeAreaOperationCommandHandler((CodeAreaCore)this.codeArea, (BinaryDataUndoHandler)new EmptyBinaryDataUndoHandler());
        this.codeArea.setCommandHandler((CodeAreaCommandHandler)commandHandler);
        this.add((Component)this.codeArea);
    }

    @Nonnull
    public ExtCodeArea getCodeArea() {
        return this.codeArea;
    }

    public void notifyDataChanged() {
        for (BinEdComponentExtension extension : this.componentExtensions) {
            extension.onDataChange();
        }
    }

    public void onInitFromPreferences(BinaryEditorPreferences preferences) {
        for (BinEdComponentExtension extension : this.componentExtensions) {
            extension.onInitFromPreferences(preferences);
        }
    }

    public void addComponentExtension(BinEdComponentExtension extension) {
        this.componentExtensions.add(extension);
        if (this.undoHandler != null) {
            extension.onUndoHandlerChange();
        }
    }

    @Nonnull
    public List<BinEdComponentExtension> getComponentExtensions() {
        return this.componentExtensions;
    }

    @Nonnull
    public <T extends BinEdComponentExtension> T getComponentExtension(Class<T> clazz) {
        for (BinEdComponentExtension extension : this.componentExtensions) {
            if (!clazz.isInstance(extension)) continue;
            return (T)extension;
        }
        throw new IllegalStateException();
    }

    private void initComponents() {
        this.setName("Form");
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinEdComponentPanel());
    }

    @Nonnull
    public Optional<BinaryDataUndoHandler> getUndoHandler() {
        return Optional.ofNullable(this.undoHandler);
    }

    public void setUndoHandler(BinaryDataUndoHandler undoHandler) {
        this.undoHandler = undoHandler;
        CodeAreaOperationCommandHandler commandHandler = new CodeAreaOperationCommandHandler((CodeAreaCore)this.codeArea, (BinaryDataUndoHandler)(undoHandler == null ? new CodeAreaUndoHandler((CodeAreaCore)this.codeArea) : undoHandler));
        this.codeArea.setCommandHandler((CodeAreaCommandHandler)commandHandler);
        for (BinEdComponentExtension extension : this.componentExtensions) {
            extension.onUndoHandlerChange();
        }
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.codeArea.setComponentPopupMenu(menu);
    }

    @Nonnull
    public BinaryData getContentData() {
        return this.codeArea.getContentData();
    }

    public void setContentData(BinaryData data) {
        this.codeArea.setContentData(data);
    }

    public void addBinaryAreaFocusListener(FocusListener focusListener) {
        this.codeArea.addFocusListener(focusListener);
    }

    public void removeBinaryAreaFocusListener(FocusListener focusListener) {
        this.codeArea.removeFocusListener(focusListener);
    }

    @ParametersAreNonnullByDefault
    public static interface BinEdComponentExtension {
        public void setApplication(XBApplication var1);

        public void onCreate(BinEdComponentPanel var1);

        public void onInitFromPreferences(BinaryEditorPreferences var1);

        public void onDataChange();

        public void onClose();

        public void onUndoHandlerChange();
    }
}

