/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeType;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class CodeTypeActions
implements CodeAreaAction {
    public static final String BINARY_CODE_TYPE_ACTION_ID = "binaryCodeTypeAction";
    public static final String OCTAL_CODE_TYPE_ACTION_ID = "octalCodeTypeAction";
    public static final String DECIMAL_CODE_TYPE_ACTION_ID = "decimalCodeTypeAction";
    public static final String HEXADECIMAL_CODE_TYPE_ACTION_ID = "hexadecimalCodeTypeAction";
    public static final String CYCLE_CODE_TYPES_ACTION_ID = "cycleCodeTypesAction";
    public static final String CODE_TYPE_RADIO_GROUP_ID = "codeTypeRadioGroup";
    private CodeAreaCore codeArea;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action binaryCodeTypeAction;
    private Action octalCodeTypeAction;
    private Action decimalCodeTypeAction;
    private Action hexadecimalCodeTypeAction;
    private Action cycleCodeTypesAction;
    private CodeType codeType = CodeType.HEXADECIMAL;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        CodeType activeCodeType;
        this.codeArea = codeArea;
        CodeType codeType = activeCodeType = codeArea != null ? ((CodeTypeCapable)codeArea).getCodeType() : null;
        if (activeCodeType != null) {
            this.setCodeType(activeCodeType);
        }
        if (this.binaryCodeTypeAction != null) {
            this.binaryCodeTypeAction.setEnabled(codeArea != null);
        }
        if (this.octalCodeTypeAction != null) {
            this.octalCodeTypeAction.setEnabled(codeArea != null);
        }
        if (this.decimalCodeTypeAction != null) {
            this.decimalCodeTypeAction.setEnabled(codeArea != null);
        }
        if (this.hexadecimalCodeTypeAction != null) {
            this.hexadecimalCodeTypeAction.setEnabled(codeArea != null);
        }
        if (this.cycleCodeTypesAction != null) {
            this.cycleCodeTypesAction.setEnabled(codeArea != null);
        }
    }

    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
        switch (codeType) {
            case BINARY: {
                this.binaryCodeTypeAction.putValue("SwingSelectedKey", Boolean.TRUE);
                break;
            }
            case OCTAL: {
                this.octalCodeTypeAction.putValue("SwingSelectedKey", Boolean.TRUE);
                break;
            }
            case DECIMAL: {
                this.decimalCodeTypeAction.putValue("SwingSelectedKey", Boolean.TRUE);
                break;
            }
            case HEXADECIMAL: {
                this.hexadecimalCodeTypeAction.putValue("SwingSelectedKey", Boolean.TRUE);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)codeType);
            }
        }
        ((CodeTypeCapable)this.codeArea).setCodeType(codeType);
        this.updateCycleButtonName();
    }

    private void updateCycleButtonName() {
        if (this.cycleCodeTypesAction != null) {
            this.cycleCodeTypesAction.putValue("Name", this.codeType.name().substring(0, 3));
        }
    }

    @Nonnull
    public Action getBinaryCodeTypeAction() {
        if (this.binaryCodeTypeAction == null) {
            this.binaryCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeTypeActions.this.setCodeType(CodeType.BINARY);
                }
            };
            ActionUtils.setupAction((Action)this.binaryCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)BINARY_CODE_TYPE_ACTION_ID);
            this.binaryCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.binaryCodeTypeAction.putValue("radioGroup", CODE_TYPE_RADIO_GROUP_ID);
            this.binaryCodeTypeAction.putValue("SwingSelectedKey", this.codeType == CodeType.BINARY);
        }
        return this.binaryCodeTypeAction;
    }

    @Nonnull
    public Action getOctalCodeTypeAction() {
        if (this.octalCodeTypeAction == null) {
            this.octalCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeTypeActions.this.setCodeType(CodeType.OCTAL);
                }
            };
            ActionUtils.setupAction((Action)this.octalCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)OCTAL_CODE_TYPE_ACTION_ID);
            this.octalCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.octalCodeTypeAction.putValue("radioGroup", CODE_TYPE_RADIO_GROUP_ID);
            this.octalCodeTypeAction.putValue("SwingSelectedKey", this.codeType == CodeType.OCTAL);
        }
        return this.octalCodeTypeAction;
    }

    @Nonnull
    public Action getDecimalCodeTypeAction() {
        if (this.decimalCodeTypeAction == null) {
            this.decimalCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeTypeActions.this.setCodeType(CodeType.DECIMAL);
                }
            };
            ActionUtils.setupAction((Action)this.decimalCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)DECIMAL_CODE_TYPE_ACTION_ID);
            this.decimalCodeTypeAction.putValue("radioGroup", CODE_TYPE_RADIO_GROUP_ID);
            this.decimalCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.decimalCodeTypeAction.putValue("SwingSelectedKey", this.codeType == CodeType.DECIMAL);
        }
        return this.decimalCodeTypeAction;
    }

    @Nonnull
    public Action getHexadecimalCodeTypeAction() {
        if (this.hexadecimalCodeTypeAction == null) {
            this.hexadecimalCodeTypeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeTypeActions.this.setCodeType(CodeType.HEXADECIMAL);
                }
            };
            ActionUtils.setupAction((Action)this.hexadecimalCodeTypeAction, (ResourceBundle)this.resourceBundle, (String)HEXADECIMAL_CODE_TYPE_ACTION_ID);
            this.hexadecimalCodeTypeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.hexadecimalCodeTypeAction.putValue("radioGroup", CODE_TYPE_RADIO_GROUP_ID);
            this.hexadecimalCodeTypeAction.putValue("SwingSelectedKey", this.codeType == CodeType.HEXADECIMAL);
        }
        return this.hexadecimalCodeTypeAction;
    }

    @Nonnull
    public Action getCycleCodeTypesAction() {
        if (this.cycleCodeTypesAction == null) {
            this.cycleCodeTypesAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeType[] values;
                    int codeTypePos = CodeTypeActions.this.codeType.ordinal();
                    CodeType next = codeTypePos + 1 >= (values = CodeType.values()).length ? values[0] : values[codeTypePos + 1];
                    CodeTypeActions.this.setCodeType(next);
                }
            };
            ActionUtils.setupAction((Action)this.cycleCodeTypesAction, (ResourceBundle)this.resourceBundle, (String)CYCLE_CODE_TYPES_ACTION_ID);
            this.cycleCodeTypesAction.putValue("type", ActionUtils.ActionType.CYCLE);
            ButtonGroup cycleButtonGroup = new ButtonGroup();
            HashMap<String, ButtonGroup> buttonGroups = new HashMap<String, ButtonGroup>();
            buttonGroups.put(CODE_TYPE_RADIO_GROUP_ID, cycleButtonGroup);
            JPopupMenu cycleCodeTypesPopupMenu = new JPopupMenu();
            cycleCodeTypesPopupMenu.add(ActionUtils.actionToMenuItem((Action)this.getBinaryCodeTypeAction(), buttonGroups));
            cycleCodeTypesPopupMenu.add(ActionUtils.actionToMenuItem((Action)this.getOctalCodeTypeAction(), buttonGroups));
            cycleCodeTypesPopupMenu.add(ActionUtils.actionToMenuItem((Action)this.getDecimalCodeTypeAction(), buttonGroups));
            cycleCodeTypesPopupMenu.add(ActionUtils.actionToMenuItem((Action)this.getHexadecimalCodeTypeAction(), buttonGroups));
            this.cycleCodeTypesAction.putValue("cyclePopupMenu", cycleCodeTypesPopupMenu);
            this.updateCycleButtonName();
        }
        return this.cycleCodeTypesAction;
    }
}

