/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.exbin.bined.basic.EnterKeyHandlingMode;
import org.exbin.bined.basic.TabKeyHandlingMode;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightNonAsciiCodeAreaPainter;
import org.exbin.bined.operation.swing.CodeAreaOperationCommandHandler;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.bined.swing.extended.layout.DefaultExtendedCodeAreaLayoutProfile;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdEditorProvider;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinEdFileManager;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.action.CodeTypeActions;
import org.exbin.framework.bined.action.HexCharactersCaseActions;
import org.exbin.framework.bined.action.PositionCodeTypeActions;
import org.exbin.framework.bined.action.ShowUnprintablesActions;
import org.exbin.framework.bined.action.ViewModeHandlerActions;
import org.exbin.framework.bined.options.gui.BinaryAppearanceOptionsPanel;
import org.exbin.framework.bined.options.gui.CodeAreaOptionsPanel;
import org.exbin.framework.bined.options.gui.ColorProfilePanel;
import org.exbin.framework.bined.options.gui.ColorProfilesOptionsPanel;
import org.exbin.framework.bined.options.gui.ColorProfilesPanel;
import org.exbin.framework.bined.options.gui.ColorTemplatePanel;
import org.exbin.framework.bined.options.gui.EditorOptionsPanel;
import org.exbin.framework.bined.options.gui.LayoutProfilePanel;
import org.exbin.framework.bined.options.gui.LayoutProfilesOptionsPanel;
import org.exbin.framework.bined.options.gui.LayoutProfilesPanel;
import org.exbin.framework.bined.options.gui.LayoutTemplatePanel;
import org.exbin.framework.bined.options.gui.NamedProfilePanel;
import org.exbin.framework.bined.options.gui.StatusOptionsPanel;
import org.exbin.framework.bined.options.gui.ThemeProfilePanel;
import org.exbin.framework.bined.options.gui.ThemeProfilesOptionsPanel;
import org.exbin.framework.bined.options.gui.ThemeProfilesPanel;
import org.exbin.framework.bined.options.gui.ThemeTemplatePanel;
import org.exbin.framework.bined.options.impl.BinaryAppearanceOptionsImpl;
import org.exbin.framework.bined.options.impl.CodeAreaColorOptionsImpl;
import org.exbin.framework.bined.options.impl.CodeAreaLayoutOptionsImpl;
import org.exbin.framework.bined.options.impl.CodeAreaOptionsImpl;
import org.exbin.framework.bined.options.impl.CodeAreaThemeOptionsImpl;
import org.exbin.framework.bined.options.impl.EditorOptionsImpl;
import org.exbin.framework.bined.options.impl.StatusOptionsImpl;
import org.exbin.framework.bined.preferences.BinaryAppearancePreferences;
import org.exbin.framework.bined.preferences.CodeAreaColorPreferences;
import org.exbin.framework.bined.preferences.CodeAreaLayoutPreferences;
import org.exbin.framework.bined.preferences.CodeAreaPreferences;
import org.exbin.framework.bined.preferences.CodeAreaThemePreferences;
import org.exbin.framework.bined.preferences.EditorPreferences;
import org.exbin.framework.bined.preferences.StatusPreferences;
import org.exbin.framework.bined.service.BinaryAppearanceService;
import org.exbin.framework.bined.service.EditorOptionsService;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.EncodingsHandler;
import org.exbin.framework.editor.text.gui.AddEncodingPanel;
import org.exbin.framework.editor.text.gui.TextFontPanel;
import org.exbin.framework.editor.text.options.gui.TextEncodingOptionsPanel;
import org.exbin.framework.editor.text.options.gui.TextFontOptionsPanel;
import org.exbin.framework.editor.text.options.impl.TextEncodingOptionsImpl;
import org.exbin.framework.editor.text.options.impl.TextFontOptionsImpl;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.editor.text.preferences.TextFontPreferences;
import org.exbin.framework.editor.text.service.TextFontService;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class BinedOptionsManager {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinedOptionsManager.class);
    private XBApplication application;
    private EditorProvider editorProvider;
    private DefaultOptionsPage<TextEncodingOptionsImpl> textEncodingOptionsPage;
    private DefaultOptionsPage<TextFontOptionsImpl> textFontOptionsPage;
    private DefaultOptionsPage<BinaryAppearanceOptionsImpl> binaryAppearanceOptionsPage;
    private DefaultOptionsPage<EditorOptionsImpl> editorOptionsPage;
    private DefaultOptionsPage<CodeAreaOptionsImpl> codeAreaOptionsPage;
    private DefaultOptionsPage<StatusOptionsImpl> statusOptionsPage;
    private DefaultOptionsPage<CodeAreaThemeOptionsImpl> themeProfilesOptionsPage;
    private DefaultOptionsPage<CodeAreaLayoutOptionsImpl> layoutProfilesOptionsPage;
    private DefaultOptionsPage<CodeAreaColorOptionsImpl> colorProfilesOptionsPage;

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setEditorProvider(EditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    public void registerOptionsPanels(final EncodingsHandler encodingsHandler, final BinEdFileManager fileManager, final BinaryAppearanceService binaryAppearanceService, final CodeTypeActions codeTypeActions, final ShowUnprintablesActions showUnprintablesActions, final HexCharactersCaseActions hexCharactersCaseActions, final PositionCodeTypeActions positionCodeTypeActions, final ViewModeHandlerActions viewModeActions) {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        this.binaryAppearanceOptionsPage = new DefaultOptionsPage<BinaryAppearanceOptionsImpl>(){
            private BinaryAppearanceOptionsPanel panel;

            @Nonnull
            public OptionsComponent<BinaryAppearanceOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new BinaryAppearanceOptionsPanel();
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(BinaryAppearanceOptionsPanel.class);
            }

            @Nonnull
            public BinaryAppearanceOptionsImpl createOptions() {
                return new BinaryAppearanceOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, BinaryAppearanceOptionsImpl options) {
                options.loadFromPreferences(new BinaryAppearancePreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, BinaryAppearanceOptionsImpl options) {
                options.saveToPreferences(new BinaryAppearancePreferences(preferences));
            }

            public void applyPreferencesChanges(BinaryAppearanceOptionsImpl options) {
                binaryAppearanceService.setWordWrapMode(options.isLineWrapping());
            }
        };
        optionsModule.extendAppearanceOptionsPage(this.binaryAppearanceOptionsPage);
        this.textEncodingOptionsPage = new DefaultOptionsPage<TextEncodingOptionsImpl>(){
            private TextEncodingOptionsPanel panel;

            public OptionsComponent<TextEncodingOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new TextEncodingOptionsPanel();
                    this.panel.setTextEncodingService(encodingsHandler.getTextEncodingService());
                    this.panel.setAddEncodingsOperation(usedEncodings -> {
                        ArrayList result = new ArrayList();
                        FrameModuleApi frameModule = (FrameModuleApi)BinedOptionsManager.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                        AddEncodingPanel addEncodingPanel = new AddEncodingPanel();
                        addEncodingPanel.setUsedEncodings(usedEncodings);
                        DefaultControlPanel controlPanel = new DefaultControlPanel(addEncodingPanel.getResourceBundle());
                        WindowUtils.DialogWrapper addEncodingDialog = frameModule.createDialog((JComponent)addEncodingPanel, (JPanel)controlPanel);
                        controlPanel.setHandler(actionType -> {
                            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                                result.addAll(addEncodingPanel.getEncodings());
                            }
                            addEncodingDialog.close();
                            addEncodingDialog.dispose();
                        });
                        WindowUtils.addHeaderPanel((Window)addEncodingDialog.getWindow(), addEncodingPanel.getClass(), (ResourceBundle)addEncodingPanel.getResourceBundle());
                        frameModule.setDialogTitle(addEncodingDialog, addEncodingPanel.getResourceBundle());
                        addEncodingDialog.showCentered((Component)this.panel);
                        return result;
                    });
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(TextEncodingOptionsPanel.class);
            }

            public TextEncodingOptionsImpl createOptions() {
                return new TextEncodingOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, TextEncodingOptionsImpl options) {
                options.loadFromPreferences(new TextEncodingPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, TextEncodingOptionsImpl options) {
                options.saveToPreferences(new TextEncodingPreferences(preferences));
            }

            public void applyPreferencesChanges(TextEncodingOptionsImpl options) {
                encodingsHandler.setSelectedEncoding(options.getSelectedEncoding());
                encodingsHandler.setEncodings(options.getEncodings());
            }
        };
        optionsModule.addOptionsPage(this.textEncodingOptionsPage);
        final TextFontService textFontService = new TextFontService(){

            public Font getCurrentFont() {
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    return ((BinEdFileHandler)activeFile.get()).getCurrentFont();
                }
                return new JLabel().getFont();
            }

            public Font getDefaultFont() {
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    return ((BinEdFileHandler)activeFile.get()).getDefaultFont();
                }
                return new JLabel().getFont();
            }

            public void setCurrentFont(Font font) {
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    ((BinEdFileHandler)activeFile.get()).setCurrentFont(font);
                }
            }
        };
        this.textFontOptionsPage = new DefaultOptionsPage<TextFontOptionsImpl>(){
            private TextFontOptionsPanel panel;

            public OptionsComponent<TextFontOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new TextFontOptionsPanel();
                    this.panel.setTextFontService(textFontService);
                    this.panel.setFontChangeAction(new TextFontOptionsPanel.FontChangeAction(){

                        public Font changeFont(Font currentFont) {
                            FontResult result = new FontResult();
                            FrameModuleApi frameModule = (FrameModuleApi)BinedOptionsManager.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                            TextFontPanel fontPanel = new TextFontPanel();
                            fontPanel.setStoredFont(currentFont);
                            DefaultControlPanel controlPanel = new DefaultControlPanel();
                            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)fontPanel, (JPanel)controlPanel);
                            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), fontPanel.getClass(), (ResourceBundle)fontPanel.getResourceBundle());
                            frameModule.setDialogTitle(dialog, fontPanel.getResourceBundle());
                            controlPanel.setHandler(actionType -> {
                                if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                                    if (actionType == DefaultControlHandler.ControlActionType.OK) {
                                        TextFontPreferences parameters = new TextFontPreferences(BinedOptionsManager.this.application.getAppPreferences());
                                        parameters.setUseDefaultFont(false);
                                        parameters.setFont(fontPanel.getStoredFont());
                                    }
                                    result.font = fontPanel.getStoredFont();
                                }
                                dialog.close();
                                dialog.dispose();
                            });
                            dialog.showCentered((Component)panel);
                            return result.font;
                        }

                        class FontResult {
                            Font font;

                            FontResult() {
                            }
                        }
                    });
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(TextFontOptionsPanel.class);
            }

            @Nonnull
            public TextFontOptionsImpl createOptions() {
                return new TextFontOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, TextFontOptionsImpl options) {
                options.loadFromPreferences(new TextFontPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, TextFontOptionsImpl options) {
                options.saveToPreferences(new TextFontPreferences(preferences));
            }

            public void applyPreferencesChanges(TextFontOptionsImpl options) {
                textFontService.setCurrentFont(options.isUseDefaultFont() ? textFontService.getDefaultFont() : options.getFont(textFontService.getDefaultFont()));
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                    codeArea.setCodeFont(options.isUseDefaultFont() ? CodeAreaPreferences.DEFAULT_FONT : options.getFont(CodeAreaPreferences.DEFAULT_FONT));
                }
            }
        };
        optionsModule.addOptionsPage(this.textFontOptionsPage);
        final EditorOptionsService editorOptionsService = new EditorOptionsService(){

            @Override
            public void setFileHandlingMode(FileHandlingMode fileHandlingMode) {
                BinEdFileHandler fileHandler;
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent() && (!(fileHandler = (BinEdFileHandler)activeFile.get()).isModified() || BinedOptionsManager.this.editorProvider.releaseFile((FileHandler)fileHandler))) {
                    fileHandler.switchFileHandlingMode(fileHandlingMode);
                    ((BinEdEditorProvider)BinedOptionsManager.this.editorProvider).updateStatus();
                }
            }

            @Override
            public void setEnterKeyHandlingMode(EnterKeyHandlingMode enterKeyHandlingMode) {
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                    CodeAreaCommandHandler commandHandler = codeArea.getCommandHandler();
                    ((CodeAreaOperationCommandHandler)commandHandler).setEnterKeyHandlingMode(enterKeyHandlingMode);
                }
            }

            @Override
            public void setTabKeyHandlingMode(TabKeyHandlingMode tabKeyHandlingMode) {
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (activeFile.isPresent()) {
                    ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                    CodeAreaCommandHandler commandHandler = codeArea.getCommandHandler();
                    ((CodeAreaOperationCommandHandler)commandHandler).setTabKeyHandlingMode(tabKeyHandlingMode);
                }
            }
        };
        this.editorOptionsPage = new DefaultOptionsPage<EditorOptionsImpl>(){
            private EditorOptionsPanel panel;

            @Nonnull
            public OptionsComponent<EditorOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new EditorOptionsPanel();
                    ArrayList<String> fileHandlingModes = new ArrayList<String>();
                    fileHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("fileHandlingMode.memory"));
                    fileHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("fileHandlingMode.delta"));
                    this.panel.setFileHandlingModes(fileHandlingModes);
                    ArrayList<String> enderKeyHandlingModes = new ArrayList<String>();
                    enderKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("enterKeyHandlingMode.platformSpecific"));
                    enderKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("enterKeyHandlingMode.cr"));
                    enderKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("enterKeyHandlingMode.lf"));
                    enderKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("enterKeyHandlingMode.crlf"));
                    enderKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("enterKeyHandlingMode.ignore"));
                    this.panel.setEnterKeyHandlingModes(enderKeyHandlingModes);
                    ArrayList<String> tabKeyHandlingModes = new ArrayList<String>();
                    tabKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("tabKeyHandlingMode.platformSpecific"));
                    tabKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("tabKeyHandlingMode.insertTab"));
                    tabKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("tabKeyHandlingMode.insertSpaces"));
                    tabKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("tabKeyHandlingMode.cycleToNextSection"));
                    tabKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("tabKeyHandlingMode.cycleToPreviousSection"));
                    tabKeyHandlingModes.add(BinedOptionsManager.this.resourceBundle.getString("tabKeyHandlingMode.ignore"));
                    this.panel.setTabKeyHandlingModes(tabKeyHandlingModes);
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(EditorOptionsPanel.class);
            }

            @Nonnull
            public EditorOptionsImpl createOptions() {
                return new EditorOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, EditorOptionsImpl options) {
                options.loadFromPreferences(new EditorPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, EditorOptionsImpl options) {
                options.saveToPreferences(new EditorPreferences(preferences));
            }

            public void applyPreferencesChanges(EditorOptionsImpl options) {
                editorOptionsService.setEnterKeyHandlingMode(options.getEnterKeyHandlingMode());
                editorOptionsService.setTabKeyHandlingMode(options.getTabKeyHandlingMode());
            }
        };
        optionsModule.addOptionsPage(this.editorOptionsPage);
        this.codeAreaOptionsPage = new DefaultOptionsPage<CodeAreaOptionsImpl>(){

            @Nonnull
            public OptionsComponent<CodeAreaOptionsImpl> createPanel() {
                CodeAreaOptionsPanel panel = new CodeAreaOptionsPanel();
                ArrayList<String> viewModes = new ArrayList<String>();
                viewModes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaViewMode.dual"));
                viewModes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaViewMode.codeMatrix"));
                viewModes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaViewMode.textPreview"));
                panel.setViewModes(viewModes);
                ArrayList<String> codeTypes = new ArrayList<String>();
                codeTypes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaCodeType.binary"));
                codeTypes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaCodeType.octal"));
                codeTypes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaCodeType.decimal"));
                codeTypes.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaCodeType.hexadecimal"));
                panel.setCodeTypes(codeTypes);
                ArrayList<String> positionCodeTypes = new ArrayList<String>();
                positionCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("positionCodeAreaCodeType.octal"));
                positionCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("positionCodeAreaCodeType.decimal"));
                positionCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("positionCodeAreaCodeType.hexadecimal"));
                panel.setPositionCodeTypes(positionCodeTypes);
                ArrayList<String> charactersCases = new ArrayList<String>();
                charactersCases.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaCharactersCase.lower"));
                charactersCases.add(BinedOptionsManager.this.resourceBundle.getString("codeAreaCharactersCase.higher"));
                panel.setCharactersCases(charactersCases);
                return panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(CodeAreaOptionsPanel.class);
            }

            @Nonnull
            public CodeAreaOptionsImpl createOptions() {
                return new CodeAreaOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, CodeAreaOptionsImpl options) {
                options.loadFromPreferences(new CodeAreaPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, CodeAreaOptionsImpl options) {
                options.saveToPreferences(new CodeAreaPreferences(preferences));
            }

            public void applyPreferencesChanges(CodeAreaOptionsImpl options) {
                codeTypeActions.setCodeType(options.getCodeType());
                showUnprintablesActions.setShowUnprintables(options.isShowUnprintables());
                hexCharactersCaseActions.setHexCharactersCase(options.getCodeCharactersCase());
                positionCodeTypeActions.setCodeType(options.getPositionCodeType());
                viewModeActions.setViewMode(options.getViewMode());
                Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    return;
                }
                ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                ((ExtendedHighlightNonAsciiCodeAreaPainter)codeArea.getPainter()).setNonAsciiHighlightingEnabled(options.isCodeColorization());
                codeArea.setMaxBytesPerRow(options.getMaxBytesPerRow());
                codeArea.setMinRowPositionLength(options.getMinRowPositionLength());
                codeArea.setMaxRowPositionLength(options.getMaxRowPositionLength());
                CodeAreaOptionsImpl.applyToCodeArea(options, codeArea);
            }
        };
        optionsModule.addOptionsPage(this.codeAreaOptionsPage);
        this.statusOptionsPage = new DefaultOptionsPage<StatusOptionsImpl>(){
            private StatusOptionsPanel panel;

            @Nonnull
            public OptionsComponent<StatusOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new StatusOptionsPanel();
                    ArrayList<String> cursorPositionCodeTypes = new ArrayList<String>();
                    cursorPositionCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("cursorPositionCodeType.octal"));
                    cursorPositionCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("cursorPositionCodeType.decimal"));
                    cursorPositionCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("cursorPositionCodeType.hexadecimal"));
                    this.panel.setCursorPositionCodeTypes(cursorPositionCodeTypes);
                    ArrayList<String> documentSizeCodeTypes = new ArrayList<String>();
                    documentSizeCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("documentSizeCodeType.octal"));
                    documentSizeCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("documentSizeCodeType.decimal"));
                    documentSizeCodeTypes.add(BinedOptionsManager.this.resourceBundle.getString("documentSizeCodeType.hexadecimal"));
                    this.panel.setDocumentSizeCodeTypes(documentSizeCodeTypes);
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(StatusOptionsPanel.class);
            }

            @Nonnull
            public StatusOptionsImpl createOptions() {
                return new StatusOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, StatusOptionsImpl options) {
                options.loadFromPreferences(new StatusPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, StatusOptionsImpl options) {
                options.saveToPreferences(new StatusPreferences(preferences));
            }

            public void applyPreferencesChanges(StatusOptionsImpl options) {
                fileManager.applyPreferencesChanges(options);
            }
        };
        optionsModule.addOptionsPage(this.statusOptionsPage);
        this.themeProfilesOptionsPage = new DefaultOptionsPage<CodeAreaThemeOptionsImpl>(){

            @Nonnull
            public OptionsComponent<CodeAreaThemeOptionsImpl> createPanel() {
                ThemeProfilesOptionsPanel panel = new ThemeProfilesOptionsPanel();
                panel.setAddProfileOperation((parentComponent, profileName) -> {
                    ThemeProfilePanel themeProfilePanel = BinedOptionsManager.this.createThemeProfilePanel();
                    themeProfilePanel.setThemeProfile(new ExtendedCodeAreaThemeProfile());
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(themeProfilePanel);
                    namedProfilePanel.setProfileName(profileName);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ThemeProfileResult result = new ThemeProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Add Theme Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), themeProfilePanel.getClass(), (ResourceBundle)themeProfilePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new ThemeProfilesPanel.ThemeProfile(namedProfilePanel.getProfileName(), themeProfilePanel.getThemeProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setEditProfileOperation((parentComponent, profileRecord) -> {
                    ThemeProfilePanel themeProfilePanel = BinedOptionsManager.this.createThemeProfilePanel();
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(themeProfilePanel);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ThemeProfileResult result = new ThemeProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Edit Theme Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), themeProfilePanel.getClass(), (ResourceBundle)themeProfilePanel.getResourceBundle());
                    namedProfilePanel.setProfileName(profileRecord.getProfileName());
                    themeProfilePanel.setThemeProfile(profileRecord.getThemeProfile());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new ThemeProfilesPanel.ThemeProfile(namedProfilePanel.getProfileName(), themeProfilePanel.getThemeProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setCopyProfileOperation((parentComponent, profileRecord) -> {
                    ThemeProfilePanel themeProfilePanel = BinedOptionsManager.this.createThemeProfilePanel();
                    themeProfilePanel.setThemeProfile(new ExtendedCodeAreaThemeProfile());
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(themeProfilePanel);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ThemeProfileResult result = new ThemeProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Copy Theme Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), themeProfilePanel.getClass(), (ResourceBundle)themeProfilePanel.getResourceBundle());
                    namedProfilePanel.setProfileName(profileRecord.getProfileName() + " #copy");
                    themeProfilePanel.setThemeProfile(profileRecord.getThemeProfile());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new ThemeProfilesPanel.ThemeProfile(namedProfilePanel.getProfileName(), themeProfilePanel.getThemeProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setTemplateProfileOperation(parentComponent -> {
                    ThemeTemplatePanel themeTemplatePanel = new ThemeTemplatePanel();
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(themeTemplatePanel);
                    namedProfilePanel.setProfileName("");
                    themeTemplatePanel.addListSelectionListener(e -> {
                        ThemeTemplatePanel.ThemeProfile selectedTemplate = themeTemplatePanel.getSelectedTemplate();
                        namedProfilePanel.setProfileName(selectedTemplate != null ? selectedTemplate.getProfileName() : "");
                    });
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ThemeProfileResult result = new ThemeProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Add Theme Template", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), themeTemplatePanel.getClass(), (ResourceBundle)themeTemplatePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Template Error", 0);
                                return;
                            }
                            ThemeTemplatePanel.ThemeProfile selectedTemplate = themeTemplatePanel.getSelectedTemplate();
                            if (selectedTemplate == null) {
                                JOptionPane.showMessageDialog(parentComponent, "No template selected", "Profile Template Error", 0);
                                return;
                            }
                            result.profile = new ThemeProfilesPanel.ThemeProfile(namedProfilePanel.getProfileName(), selectedTemplate.getThemeProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                return panel;
            }

            private boolean isValidProfileName(@Nullable String profileName) {
                return profileName != null && !"".equals(profileName.trim());
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(ThemeProfilesOptionsPanel.class);
            }

            @Nonnull
            public CodeAreaThemeOptionsImpl createOptions() {
                return new CodeAreaThemeOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, CodeAreaThemeOptionsImpl options) {
                options.loadFromPreferences(new CodeAreaThemePreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, CodeAreaThemeOptionsImpl options) {
                options.saveToPreferences(new CodeAreaThemePreferences(preferences));
            }

            public void applyPreferencesChanges(CodeAreaThemeOptionsImpl options) {
                int selectedProfile = options.getSelectedProfile();
                if (selectedProfile >= 0) {
                    Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        return;
                    }
                    ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                    ExtendedCodeAreaThemeProfile profile = options.getThemeProfile(selectedProfile);
                    codeArea.setThemeProfile(profile);
                }
            }

            class ThemeProfileResult {
                ThemeProfilesPanel.ThemeProfile profile;

                ThemeProfileResult() {
                }
            }
        };
        optionsModule.addOptionsPage(this.themeProfilesOptionsPage);
        this.layoutProfilesOptionsPage = new DefaultOptionsPage<CodeAreaLayoutOptionsImpl>(){

            public OptionsComponent<CodeAreaLayoutOptionsImpl> createPanel() {
                LayoutProfilesOptionsPanel panel = new LayoutProfilesOptionsPanel();
                panel.setAddProfileOperation((parentComponent, profileName) -> {
                    LayoutProfilePanel layoutProfilePanel = new LayoutProfilePanel();
                    layoutProfilePanel.setLayoutProfile(new DefaultExtendedCodeAreaLayoutProfile());
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(layoutProfilePanel);
                    namedProfilePanel.setProfileName(profileName);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    LayoutProfileResult result = new LayoutProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Add Layout Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), layoutProfilePanel.getClass(), (ResourceBundle)layoutProfilePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new LayoutProfilesPanel.LayoutProfile(namedProfilePanel.getProfileName(), layoutProfilePanel.getLayoutProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setEditProfileOperation((parentComponent, profileRecord) -> {
                    LayoutProfilePanel layoutProfilePanel = new LayoutProfilePanel();
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(layoutProfilePanel);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    LayoutProfileResult result = new LayoutProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Edit Layout Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), layoutProfilePanel.getClass(), (ResourceBundle)layoutProfilePanel.getResourceBundle());
                    namedProfilePanel.setProfileName(profileRecord.getProfileName());
                    layoutProfilePanel.setLayoutProfile(profileRecord.getLayoutProfile());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new LayoutProfilesPanel.LayoutProfile(namedProfilePanel.getProfileName(), layoutProfilePanel.getLayoutProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setCopyProfileOperation((parentComponent, profileRecord) -> {
                    LayoutProfilePanel layoutProfilePanel = new LayoutProfilePanel();
                    layoutProfilePanel.setLayoutProfile(new DefaultExtendedCodeAreaLayoutProfile());
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(layoutProfilePanel);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    LayoutProfileResult result = new LayoutProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Copy Layout Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), layoutProfilePanel.getClass(), (ResourceBundle)layoutProfilePanel.getResourceBundle());
                    namedProfilePanel.setProfileName(profileRecord.getProfileName() + " #copy");
                    layoutProfilePanel.setLayoutProfile(profileRecord.getLayoutProfile());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new LayoutProfilesPanel.LayoutProfile(namedProfilePanel.getProfileName(), layoutProfilePanel.getLayoutProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setTemplateProfileOperation(parentComponent -> {
                    LayoutTemplatePanel layoutTemplatePanel = new LayoutTemplatePanel();
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(layoutTemplatePanel);
                    namedProfilePanel.setProfileName("");
                    layoutTemplatePanel.addListSelectionListener(e -> {
                        LayoutTemplatePanel.LayoutProfile selectedTemplate = layoutTemplatePanel.getSelectedTemplate();
                        namedProfilePanel.setProfileName(selectedTemplate != null ? selectedTemplate.getProfileName() : "");
                    });
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    LayoutProfileResult result = new LayoutProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Add Layout Template", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), layoutTemplatePanel.getClass(), (ResourceBundle)layoutTemplatePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Template Error", 0);
                                return;
                            }
                            LayoutTemplatePanel.LayoutProfile selectedTemplate = layoutTemplatePanel.getSelectedTemplate();
                            if (selectedTemplate == null) {
                                JOptionPane.showMessageDialog(parentComponent, "No template selected", "Profile Template Error", 0);
                                return;
                            }
                            result.profile = new LayoutProfilesPanel.LayoutProfile(namedProfilePanel.getProfileName(), selectedTemplate.getLayoutProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                return panel;
            }

            private boolean isValidProfileName(@Nullable String profileName) {
                return profileName != null && !"".equals(profileName.trim());
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(LayoutProfilesOptionsPanel.class);
            }

            @Nonnull
            public CodeAreaLayoutOptionsImpl createOptions() {
                return new CodeAreaLayoutOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, CodeAreaLayoutOptionsImpl options) {
                options.loadFromPreferences(new CodeAreaLayoutPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, CodeAreaLayoutOptionsImpl options) {
                options.saveToPreferences(new CodeAreaLayoutPreferences(preferences));
            }

            public void applyPreferencesChanges(CodeAreaLayoutOptionsImpl options) {
                int selectedProfile = options.getSelectedProfile();
                if (selectedProfile >= 0) {
                    Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        return;
                    }
                    ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                    DefaultExtendedCodeAreaLayoutProfile profile = options.getLayoutProfile(selectedProfile);
                    codeArea.setLayoutProfile((ExtendedCodeAreaLayoutProfile)profile);
                }
            }

            class LayoutProfileResult {
                LayoutProfilesPanel.LayoutProfile profile;

                LayoutProfileResult() {
                }
            }
        };
        optionsModule.addOptionsPage(this.layoutProfilesOptionsPage);
        this.colorProfilesOptionsPage = new DefaultOptionsPage<CodeAreaColorOptionsImpl>(){

            public OptionsComponent<CodeAreaColorOptionsImpl> createPanel() {
                ColorProfilesOptionsPanel panel = new ColorProfilesOptionsPanel();
                panel.setAddProfileOperation((parentComponent, profileName) -> {
                    ColorProfilePanel colorProfilePanel = new ColorProfilePanel();
                    colorProfilePanel.setColorProfile(new ExtendedCodeAreaColorProfile());
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(colorProfilePanel);
                    namedProfilePanel.setProfileName(profileName);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ColorProfileResult result = new ColorProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Add Colors Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), colorProfilePanel.getClass(), (ResourceBundle)colorProfilePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new ColorProfilesPanel.ColorProfile(namedProfilePanel.getProfileName(), colorProfilePanel.getColorProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setEditProfileOperation((parentComponent, profileRecord) -> {
                    ColorProfilePanel colorProfilePanel = new ColorProfilePanel();
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(colorProfilePanel);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ColorProfileResult result = new ColorProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Edit Colors Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), colorProfilePanel.getClass(), (ResourceBundle)colorProfilePanel.getResourceBundle());
                    namedProfilePanel.setProfileName(profileRecord.getProfileName());
                    colorProfilePanel.setColorProfile(profileRecord.getColorProfile());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new ColorProfilesPanel.ColorProfile(namedProfilePanel.getProfileName(), colorProfilePanel.getColorProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setCopyProfileOperation((parentComponent, profileRecord) -> {
                    ColorProfilePanel colorProfilePanel = new ColorProfilePanel();
                    colorProfilePanel.setColorProfile(new ExtendedCodeAreaColorProfile());
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(colorProfilePanel);
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ColorProfileResult result = new ColorProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Copy Colors Profile", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), colorProfilePanel.getClass(), (ResourceBundle)colorProfilePanel.getResourceBundle());
                    namedProfilePanel.setProfileName(profileRecord.getProfileName() + " #copy");
                    colorProfilePanel.setColorProfile(profileRecord.getColorProfile());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Edit Error", 0);
                                return;
                            }
                            result.profile = new ColorProfilesPanel.ColorProfile(namedProfilePanel.getProfileName(), colorProfilePanel.getColorProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                panel.setTemplateProfileOperation(parentComponent -> {
                    ColorTemplatePanel colorTemplatePanel = new ColorTemplatePanel();
                    NamedProfilePanel namedProfilePanel = new NamedProfilePanel(colorTemplatePanel);
                    namedProfilePanel.setProfileName("");
                    colorTemplatePanel.addListSelectionListener(e -> {
                        ColorTemplatePanel.ColorProfile selectedTemplate = colorTemplatePanel.getSelectedTemplate();
                        namedProfilePanel.setProfileName(selectedTemplate != null ? selectedTemplate.getProfileName() : "");
                    });
                    DefaultControlPanel controlPanel = new DefaultControlPanel();
                    JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)namedProfilePanel, (JPanel)controlPanel);
                    ColorProfileResult result = new ColorProfileResult();
                    WindowUtils.DialogWrapper dialog = WindowUtils.createDialog((JComponent)dialogPanel, (Component)parentComponent, (String)"Add Colors Template", (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), colorTemplatePanel.getClass(), (ResourceBundle)colorTemplatePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                            if (!this.isValidProfileName(namedProfilePanel.getProfileName())) {
                                JOptionPane.showMessageDialog(parentComponent, "Invalid profile name", "Profile Template Error", 0);
                                return;
                            }
                            ColorTemplatePanel.ColorProfile selectedTemplate = colorTemplatePanel.getSelectedTemplate();
                            if (selectedTemplate == null) {
                                JOptionPane.showMessageDialog(parentComponent, "No template selected", "Profile Template Error", 0);
                                return;
                            }
                            result.profile = new ColorProfilesPanel.ColorProfile(namedProfilePanel.getProfileName(), selectedTemplate.getColorProfile());
                        }
                        dialog.close();
                        dialog.dispose();
                    });
                    dialog.showCentered((Component)parentComponent);
                    return result.profile;
                });
                return panel;
            }

            private boolean isValidProfileName(@Nullable String profileName) {
                return profileName != null && !"".equals(profileName.trim());
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(ColorProfilesOptionsPanel.class);
            }

            @Nonnull
            public CodeAreaColorOptionsImpl createOptions() {
                return new CodeAreaColorOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, CodeAreaColorOptionsImpl options) {
                options.loadFromPreferences(new CodeAreaColorPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, CodeAreaColorOptionsImpl options) {
                options.saveToPreferences(new CodeAreaColorPreferences(preferences));
            }

            public void applyPreferencesChanges(CodeAreaColorOptionsImpl options) {
                int selectedProfile = options.getSelectedProfile();
                if (selectedProfile >= 0) {
                    Optional activeFile = BinedOptionsManager.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        return;
                    }
                    ExtCodeArea codeArea = ((BinEdFileHandler)activeFile.get()).getCodeArea();
                    ExtendedCodeAreaColorProfile profile = options.getColorsProfile(selectedProfile);
                    codeArea.setColorsProfile((CodeAreaColorsProfile)profile);
                }
            }

            class ColorProfileResult {
                ColorProfilesPanel.ColorProfile profile;

                ColorProfileResult() {
                }
            }
        };
        optionsModule.addOptionsPage(this.colorProfilesOptionsPage);
    }

    public void startWithFile(String filePath) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        URI uri = new File(filePath).toURI();
        fileModule.loadFromFile(uri);
    }

    @Nonnull
    private ThemeProfilePanel createThemeProfilePanel() {
        ThemeProfilePanel themeProfilePanel = new ThemeProfilePanel();
        ArrayList<String> backgroundModes = new ArrayList<String>();
        for (ExtendedBackgroundPaintMode mode : ExtendedBackgroundPaintMode.values()) {
            backgroundModes.add(this.resourceBundle.getString("backgroundPaintMode." + mode.name().toLowerCase()));
        }
        themeProfilePanel.setBackgroundModes(backgroundModes);
        return themeProfilePanel;
    }
}

