/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.color;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.color.BasicCodeAreaColorGroup;
import org.exbin.bined.color.CodeAreaColorGroup;
import org.exbin.bined.color.CodeAreaColorType;

@ParametersAreNonnullByDefault
public enum CodeAreaBasicColors implements CodeAreaColorType
{
    TEXT_COLOR("textColor", BasicCodeAreaColorGroup.MAIN),
    TEXT_BACKGROUND("textBackground", BasicCodeAreaColorGroup.MAIN),
    SELECTION_COLOR("selectionColor", BasicCodeAreaColorGroup.SELECTION),
    SELECTION_BACKGROUND("selectionBackground", BasicCodeAreaColorGroup.SELECTION),
    SELECTION_MIRROR_COLOR("selectionMirrorColor", BasicCodeAreaColorGroup.SELECTION),
    SELECTION_MIRROR_BACKGROUND("selectionMirrorBackground", BasicCodeAreaColorGroup.SELECTION),
    ALTERNATE_COLOR("alternateColor", BasicCodeAreaColorGroup.MAIN),
    ALTERNATE_BACKGROUND("alternateBackground", BasicCodeAreaColorGroup.MAIN),
    CURSOR_COLOR("cursorColor", null),
    CURSOR_NEGATIVE_COLOR("cursorNegativeColor", null);

    @Nonnull
    private final String typeId;
    @Nullable
    private final BasicCodeAreaColorGroup group;

    private CodeAreaBasicColors(String typeId, BasicCodeAreaColorGroup group) {
        this.typeId = typeId;
        this.group = group;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.typeId;
    }

    @Override
    @Nonnull
    public Optional<CodeAreaColorGroup> getGroup() {
        return Optional.ofNullable(this.group);
    }
}

