/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.basic;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeType;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaStructure;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;

@ParametersAreNonnullByDefault
public class BasicCodeAreaLayout {
    public int computeBytesPerRow(BasicCodeAreaStructure structure, int charactersPerPage) {
        int computedBytesPerRow;
        CodeAreaViewMode viewMode = structure.getViewMode();
        CodeType codeType = structure.getCodeType();
        int maxBytesPerLine = structure.getMaxBytesPerLine();
        int wrappingBytesGroupSize = structure.getWrappingBytesGroupSize();
        RowWrappingMode rowWrapping = structure.getRowWrapping();
        if (rowWrapping == RowWrappingMode.WRAPPING) {
            int wrappingBytesGroupOffset;
            int charactersPerByte = 0;
            if (viewMode != CodeAreaViewMode.TEXT_PREVIEW) {
                charactersPerByte += codeType.getMaxDigitsForByte() + 1;
            }
            if (viewMode != CodeAreaViewMode.CODE_MATRIX) {
                ++charactersPerByte;
            }
            computedBytesPerRow = charactersPerPage / charactersPerByte;
            if (maxBytesPerLine > 0 && computedBytesPerRow > maxBytesPerLine) {
                computedBytesPerRow = maxBytesPerLine;
            }
            if (wrappingBytesGroupSize > 1 && (wrappingBytesGroupOffset = computedBytesPerRow % wrappingBytesGroupSize) > 0) {
                computedBytesPerRow -= wrappingBytesGroupOffset;
            }
        } else {
            computedBytesPerRow = maxBytesPerLine;
        }
        if (computedBytesPerRow < 1) {
            computedBytesPerRow = 1;
        }
        return computedBytesPerRow;
    }

    public int computeCharactersPerRow(BasicCodeAreaStructure structure) {
        CodeAreaViewMode viewMode = structure.getViewMode();
        int bytesPerRow = structure.getBytesPerRow();
        int charsPerRow = 0;
        if (viewMode != CodeAreaViewMode.TEXT_PREVIEW) {
            charsPerRow += this.computeLastCodeCharPos(structure, bytesPerRow - 1) + 1;
        }
        if (viewMode != CodeAreaViewMode.CODE_MATRIX) {
            charsPerRow += bytesPerRow;
            if (viewMode == CodeAreaViewMode.DUAL) {
                ++charsPerRow;
            }
        }
        return charsPerRow;
    }

    public long computeRowsPerDocument(BasicCodeAreaStructure structure) {
        long dataSize = structure.getDataSize();
        int bytesPerRow = structure.getBytesPerRow();
        return dataSize / (long)bytesPerRow + 1L;
    }

    public int computePositionByte(BasicCodeAreaStructure structure, int rowCharPosition) {
        CodeType codeType = structure.getCodeType();
        return rowCharPosition / (codeType.getMaxDigitsForByte() + 1);
    }

    public int computeFirstCodeCharacterPos(BasicCodeAreaStructure structure, int byteOffset) {
        CodeType codeType = structure.getCodeType();
        return byteOffset * (codeType.getMaxDigitsForByte() + 1);
    }

    public int computeLastCodeCharPos(BasicCodeAreaStructure structure, int byteOffset) {
        CodeType codeType = structure.getCodeType();
        return byteOffset * (codeType.getMaxDigitsForByte() + 1) + codeType.getMaxDigitsForByte() - 1;
    }

    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(BasicCodeAreaStructure structure, CodeAreaCaretPosition position, MovementDirection direction, int rowsPerPage) {
        CodeType codeType = structure.getCodeType();
        int bytesPerRow = structure.getBytesPerRow();
        long dataSize = structure.getDataSize();
        CodeAreaSection section = position.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
        DefaultCodeAreaCaretPosition target = new DefaultCodeAreaCaretPosition(position.getDataPosition(), position.getCodeOffset(), section);
        switch (direction) {
            case LEFT: {
                if (section != BasicCodeAreaSection.TEXT_PREVIEW) {
                    int codeOffset = position.getCodeOffset();
                    if (codeOffset > 0) {
                        target.setCodeOffset(codeOffset - 1);
                        break;
                    }
                    if (position.getDataPosition() <= 0L) break;
                    target.setDataPosition(position.getDataPosition() - 1L);
                    target.setCodeOffset(codeType.getMaxDigitsForByte() - 1);
                    break;
                }
                if (position.getDataPosition() <= 0L) break;
                target.setDataPosition(position.getDataPosition() - 1L);
                break;
            }
            case RIGHT: {
                if (section != BasicCodeAreaSection.TEXT_PREVIEW) {
                    int codeOffset = position.getCodeOffset();
                    if (position.getDataPosition() < dataSize && codeOffset < codeType.getMaxDigitsForByte() - 1) {
                        target.setCodeOffset(codeOffset + 1);
                        break;
                    }
                    if (position.getDataPosition() >= dataSize) break;
                    target.setDataPosition(position.getDataPosition() + 1L);
                    target.setCodeOffset(0);
                    break;
                }
                if (position.getDataPosition() >= dataSize) break;
                target.setDataPosition(position.getDataPosition() + 1L);
                break;
            }
            case UP: {
                if (position.getDataPosition() < (long)bytesPerRow) break;
                target.setDataPosition(position.getDataPosition() - (long)bytesPerRow);
                break;
            }
            case DOWN: {
                if (position.getDataPosition() >= dataSize - (long)bytesPerRow && (position.getDataPosition() != dataSize - (long)bytesPerRow || position.getCodeOffset() != 0)) break;
                target.setDataPosition(position.getDataPosition() + (long)bytesPerRow);
                break;
            }
            case ROW_START: {
                long dataPosition = position.getDataPosition();
                dataPosition -= dataPosition % (long)bytesPerRow;
                target.setDataPosition(dataPosition);
                target.setCodeOffset(0);
                break;
            }
            case ROW_END: {
                long dataPosition = position.getDataPosition();
                long increment = (long)(bytesPerRow - 1) - dataPosition % (long)bytesPerRow;
                if (dataPosition > Long.MAX_VALUE - increment || dataPosition + increment > dataSize) {
                    target.setDataPosition(dataSize);
                } else {
                    target.setDataPosition(dataPosition + increment);
                }
                if (section == BasicCodeAreaSection.TEXT_PREVIEW) break;
                if (target.getDataPosition() == dataSize) {
                    target.setCodeOffset(0);
                    break;
                }
                target.setCodeOffset(codeType.getMaxDigitsForByte() - 1);
                break;
            }
            case PAGE_UP: {
                long dataPosition = position.getDataPosition();
                long increment = (long)bytesPerRow * (long)rowsPerPage;
                if (dataPosition < increment) {
                    target.setDataPosition(dataPosition % (long)bytesPerRow);
                    break;
                }
                target.setDataPosition(dataPosition - increment);
                break;
            }
            case PAGE_DOWN: {
                long dataPosition = position.getDataPosition();
                long increment = (long)bytesPerRow * (long)rowsPerPage;
                if (dataPosition > dataSize - increment) {
                    long lastRowDataStart = dataSize - dataSize % (long)bytesPerRow;
                    long positionOnRow = dataPosition % (long)bytesPerRow;
                    if (lastRowDataStart == dataSize - positionOnRow) {
                        target.setDataPosition(dataSize);
                        target.setCodeOffset(0);
                        break;
                    }
                    if (lastRowDataStart > dataSize - positionOnRow) {
                        if (lastRowDataStart <= (long)bytesPerRow) break;
                        target.setDataPosition((lastRowDataStart -= (long)bytesPerRow) + positionOnRow);
                        break;
                    }
                    target.setDataPosition(lastRowDataStart + positionOnRow);
                    break;
                }
                target.setDataPosition(dataPosition + increment);
                break;
            }
            case DOC_START: {
                target.setDataPosition(0L);
                target.setCodeOffset(0);
                break;
            }
            case DOC_END: {
                target.setDataPosition(dataSize);
                target.setCodeOffset(0);
                break;
            }
            case SWITCH_SECTION: {
                BasicCodeAreaSection activeSection;
                BasicCodeAreaSection basicCodeAreaSection = activeSection = section == BasicCodeAreaSection.TEXT_PREVIEW ? BasicCodeAreaSection.CODE_MATRIX : BasicCodeAreaSection.TEXT_PREVIEW;
                if (activeSection == BasicCodeAreaSection.TEXT_PREVIEW) {
                    target.setCodeOffset(0);
                }
                target.setSection(activeSection);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(direction);
            }
        }
        return target;
    }

    public int computePositionX(int charsPerRow, int characterWidth) {
        return charsPerRow * characterWidth;
    }
}

