/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CharEditDataOperation;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.ModifyDataOperation;
import org.exbin.bined.operation.swing.RemoveDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class OverwriteCharEditDataOperation
extends CharEditDataOperation {
    private final long startPosition;
    private long length = 0L;
    private EditableBinaryData undoData = null;

    public OverwriteCharEditDataOperation(CodeAreaCore coreArea, long startPosition) {
        super(coreArea);
        this.startPosition = startPosition;
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.EDIT_DATA;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        throw new IllegalStateException("Cannot be executed");
    }

    @Override
    public void appendEdit(char value) {
        int i;
        EditableBinaryData data = (EditableBinaryData)CodeAreaUtils.requireNonNull((Object)this.codeArea.getContentData());
        long editedDataPosition = this.startPosition + this.length;
        Charset charset = ((CharsetCapable)this.codeArea).getCharset();
        byte[] bytes = CodeAreaUtils.characterToBytes((char)value, (Charset)charset);
        if (editedDataPosition < data.getDataSize()) {
            long overwritten = data.getDataSize() - editedDataPosition;
            if (overwritten > (long)bytes.length) {
                overwritten = bytes.length;
            }
            EditableBinaryData overwrittenData = (EditableBinaryData)data.copy(editedDataPosition, overwritten);
            if (this.undoData == null) {
                this.undoData = overwrittenData;
            } else {
                this.undoData.insert(this.undoData.getDataSize(), (BinaryData)overwrittenData);
            }
            i = 0;
            while ((long)i < overwritten) {
                data.setByte(editedDataPosition + (long)i, bytes[i]);
                ++i;
            }
        }
        if (editedDataPosition + (long)bytes.length > data.getDataSize()) {
            if (editedDataPosition == data.getDataSize()) {
                data.insert(editedDataPosition, bytes);
            } else {
                int inserted = (int)(editedDataPosition + (long)bytes.length - data.getDataSize());
                long insertPosition = editedDataPosition + (long)bytes.length - (long)inserted;
                data.insert(insertPosition, (long)inserted);
                for (i = 0; i < inserted; ++i) {
                    data.setByte(insertPosition + (long)i, bytes[bytes.length - inserted + i]);
                }
            }
        }
        this.length += (long)bytes.length;
        long dataPosition = this.startPosition + this.length;
        ((CaretCapable)this.codeArea).setCaretPosition(dataPosition);
        ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
    }

    @Override
    @Nonnull
    public CodeAreaOperation[] generateUndo() {
        long undoDataSize;
        long removeLength;
        ModifyDataOperation modifyOperation = null;
        if (this.undoData != null && !this.undoData.isEmpty()) {
            modifyOperation = new ModifyDataOperation(this.codeArea, this.startPosition, this.undoData.copy());
        }
        if ((removeLength = this.length - (undoDataSize = this.undoData == null ? 0L : this.undoData.getDataSize())) == 0L) {
            return new CodeAreaOperation[]{modifyOperation};
        }
        RemoveDataOperation removeOperation = new RemoveDataOperation(this.codeArea, this.startPosition + undoDataSize, 0, removeLength);
        if (modifyOperation != null) {
            return new CodeAreaOperation[]{modifyOperation, removeOperation};
        }
        return new CodeAreaOperation[]{removeOperation};
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        if (this.undoData != null) {
            this.undoData.dispose();
        }
    }
}

