/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.operation.BinaryDataCommand;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoUpdateListener;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class CodeAreaUndoHandler
implements BinaryDataUndoHandler {
    private long undoMaximumCount;
    private long undoMaximumSize;
    private long usedSize;
    private long commandPosition;
    private long syncPointPosition = -1L;
    private final List<BinaryDataCommand> commands = new ArrayList<BinaryDataCommand>();
    private final CodeAreaCore codeArea;
    private final List<BinaryDataUndoUpdateListener> listeners = new ArrayList<BinaryDataUndoUpdateListener>();

    public CodeAreaUndoHandler(CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.undoMaximumCount = 1024L;
        this.undoMaximumSize = 65535L;
        this.init();
    }

    private void init() {
        this.usedSize = 0L;
        this.commandPosition = 0L;
        this.setSyncPoint(0L);
    }

    public void execute(BinaryDataCommand command) throws BinaryDataOperationException {
        command.execute();
        this.commandAdded(command);
    }

    public void addCommand(BinaryDataCommand command) {
        command.use();
        this.commandAdded(command);
    }

    private void commandAdded(BinaryDataCommand addedCommand) {
        while ((long)this.commands.size() > this.commandPosition) {
            BinaryDataCommand command = this.commands.get((int)this.commandPosition);
            try {
                command.dispose();
            }
            catch (BinaryDataOperationException ex) {
                Logger.getLogger(CodeAreaUndoHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.commands.remove(command);
        }
        this.commands.add(addedCommand);
        ++this.commandPosition;
        this.undoUpdated();
        this.listeners.forEach(listener -> listener.undoCommandAdded(addedCommand));
    }

    public void performUndo() throws BinaryDataOperationException {
        this.performUndoInt();
        this.undoUpdated();
    }

    private void performUndoInt() throws BinaryDataOperationException {
        --this.commandPosition;
        BinaryDataCommand command = this.commands.get((int)this.commandPosition);
        command.undo();
    }

    public void performRedo() throws BinaryDataOperationException {
        this.performRedoInt();
        this.undoUpdated();
    }

    private void performRedoInt() throws BinaryDataOperationException {
        BinaryDataCommand command = this.commands.get((int)this.commandPosition);
        command.redo();
        ++this.commandPosition;
    }

    public void performUndo(int count) throws BinaryDataOperationException {
        if (this.commandPosition < (long)count) {
            throw new IllegalArgumentException("Unable to perform " + count + " undo steps");
        }
        while (count > 0) {
            this.performUndoInt();
            --count;
        }
        this.undoUpdated();
    }

    public void performRedo(int count) throws BinaryDataOperationException {
        if ((long)this.commands.size() - this.commandPosition < (long)count) {
            throw new IllegalArgumentException("Unable to perform " + count + " redo steps");
        }
        while (count > 0) {
            this.performRedoInt();
            --count;
        }
        this.undoUpdated();
    }

    public void clear() {
        this.commands.forEach(command -> {
            try {
                command.dispose();
            }
            catch (BinaryDataOperationException ex) {
                Logger.getLogger(CodeAreaUndoHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.commands.clear();
        this.init();
        this.undoUpdated();
    }

    public boolean canUndo() {
        return this.commandPosition > 0L;
    }

    public boolean canRedo() {
        return (long)this.commands.size() > this.commandPosition;
    }

    public long getMaximumUndo() {
        return this.undoMaximumCount;
    }

    public long getCommandPosition() {
        return this.commandPosition;
    }

    public void doSync() throws BinaryDataOperationException {
        this.setCommandPosition(this.syncPointPosition);
    }

    public void setUndoMaxCount(long maxUndo) {
        this.undoMaximumCount = maxUndo;
    }

    public long getUndoMaximumSize() {
        return this.undoMaximumSize;
    }

    public void setUndoMaximumSize(long maxSize) {
        this.undoMaximumSize = maxSize;
    }

    public long getUsedSize() {
        return this.usedSize;
    }

    public long getSyncPoint() {
        return this.syncPointPosition;
    }

    public void setSyncPoint(long syncPoint) {
        this.syncPointPosition = syncPoint;
    }

    public void setSyncPoint() {
        this.syncPointPosition = this.commandPosition;
    }

    @Nonnull
    public List<BinaryDataCommand> getCommandList() {
        return this.commands;
    }

    public void setCommandPosition(long targetPosition) throws BinaryDataOperationException {
        if (targetPosition < this.commandPosition) {
            this.performUndo((int)(this.commandPosition - targetPosition));
        } else if (targetPosition > this.commandPosition) {
            this.performRedo((int)(targetPosition - this.commandPosition));
        }
    }

    private void undoUpdated() {
        this.codeArea.notifyDataChanged();
        this.listeners.forEach(BinaryDataUndoUpdateListener::undoCommandPositionChanged);
    }

    public void addUndoUpdateListener(BinaryDataUndoUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void removeUndoUpdateListener(BinaryDataUndoUpdateListener listener) {
        this.listeners.remove(listener);
    }
}

