/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.about.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.plugin.XBModuleRecord;

@ParametersAreNonnullByDefault
public class AboutModulesPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AboutModulesPanel.class);
    private JScrollPane modulesScrollPane;
    private JTable modulesTable;

    public AboutModulesPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.modulesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.resourceBundle.getString("modulesTable.moduleNameColumn"), this.resourceBundle.getString("modulesTable.moduleDescriptionColumn"), this.resourceBundle.getString("modulesTable.moduleLicenseColumn")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class};
            }

            @Nonnull
            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
    }

    public void setApplication(XBApplication application) {
        DefaultTableModel modulesTableModel = (DefaultTableModel)this.modulesTable.getModel();
        List modulesList = application.getModuleRepository().getModulesList();
        for (XBModuleRecord moduleRecord : modulesList) {
            String moduleName = moduleRecord.getName().isEmpty() ? moduleRecord.getModuleId() : moduleRecord.getName();
            Object[] newRow = new String[]{moduleName, moduleRecord.getDescription()};
            modulesTableModel.addRow(newRow);
        }
    }

    private void initComponents() {
        this.modulesScrollPane = new JScrollPane();
        this.modulesTable = new JTable();
        this.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.modulesScrollPane.setViewportView(this.modulesTable);
        this.add((Component)this.modulesScrollPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AboutModulesPanel());
    }
}

