/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.handler.RemovalControlHandler;

@ParametersAreNonnullByDefault
public class RemovalControlPanel
extends JPanel
implements RemovalControlHandler.RemovalControlService {
    private final ResourceBundle resourceBundle;
    private RemovalControlHandler handler;
    private OkCancelListener okCancelListener;
    private JButton cancelButton;
    private JButton okButton;
    private JButton removeButton;

    public RemovalControlPanel() {
        this(LanguageUtils.getResourceBundleByClass(RemovalControlPanel.class));
    }

    public RemovalControlPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initComponents();
        this.okCancelListener = new OkCancelListener(){

            @Override
            public void okEvent() {
                RemovalControlPanel.this.performClick(RemovalControlHandler.ControlActionType.OK);
            }

            @Override
            public void cancelEvent() {
                RemovalControlPanel.this.performClick(RemovalControlHandler.ControlActionType.CANCEL);
            }
        };
    }

    public void setHandler(RemovalControlHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.removeButton = new JButton();
        this.cancelButton.setText(this.resourceBundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemovalControlPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText(this.resourceBundle.getString("okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemovalControlPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(this.resourceBundle.getString("removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemovalControlPanel.this.removeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.removeButton)).addContainerGap()));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(RemovalControlHandler.ControlActionType.CANCEL);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(RemovalControlHandler.ControlActionType.OK);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(RemovalControlHandler.ControlActionType.REMOVE);
        }
    }

    @Override
    public void performClick(RemovalControlHandler.ControlActionType actionType) {
        UiUtils.doButtonClick(actionType == RemovalControlHandler.ControlActionType.OK ? this.okButton : this.cancelButton);
    }

    @Override
    @Nonnull
    public JButton getDefaultButton() {
        return this.okButton;
    }

    @Override
    @Nonnull
    public OkCancelListener getOkCancelListener() {
        return this.okCancelListener;
    }

    @Override
    @Nonnull
    public RemovalControlHandler.RemovalControlEnablementListener createEnablementListener() {
        return (actionType, enablement) -> {
            switch (actionType) {
                case OK: {
                    this.okButton.setEnabled(enablement);
                    break;
                }
                case CANCEL: {
                    this.cancelButton.setEnabled(enablement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal action type " + actionType.name());
                }
            }
        };
    }
}

